#
# postdialog.tcl
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# PostDialog
#
# Public attributes:
#   -closecommand	command when quit is selected
#   -title		title
#
# Methods:
#
itcl_class ArticleWindow \
{
  constructor {config} \
  {
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::frame $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this

    LabelEntry $this.newsgroup -labeltext "Newsgroup" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.from -labeltext "From" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.subject -labeltext "Subject" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.organization -labeltext "Organization" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.references -labeltext "References" \
		-labelwidth 15 -entrywidth 50
    pack $this.newsgroup $this.from $this.subject $this.organization \
		$this.references -side top -fill x

    frame $this.article
    text $this.article.text -relief sunken -bd 2\
	-yscrollcommand "$this.article.scroll set" -setgrid true \
	-width 70 -height 30
    scrollbar $this.article.scroll -relief sunken \
	-command "$this.article.text yview" -width 14
    pack $this.article.scroll -side right -fill y
    pack $this.article.text -expand yes -fill both
    pack $this.article -expand yes -side top -fill both
 
    $this.organization setEntry [$main getConfig organization]
    $this.from setEntry "[$main getConfig email] ([$main getConfig name])"
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method clearAll {} \
  { $this.article.text delete 1.0 end
    $this.newsgroup setEntry ""
    $this.from setEntry ""
    $this.subject setEntry ""
    $this.organization setEntry ""
    $this.references setEntry ""
  }

  method setArticleBody {text} \
  { $this.article.text delete 1.0 end
    $this.article.text insert 1.0 $text
  }

  method setHeaders {newsgroup from subject organization references} \
  { $this.newsgroup setEntry $newsgroup
    $this.from setEntry $from
    $this.subject setEntry $subject
    $this.organization setEntry $organization
    $this.references setEntry $references
  }

  method takeFocus {} \
  {
  }

  public main ""
}


