#
# postdialog.tcl
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# PostDialog
#
# Public attributes:
#   -closecommand	command when quit is selected
#   -title		title
#
# Methods:
#
itcl_class PostDialog \
{
  constructor {config} \
  {
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::toplevel $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this
    wm title $this $title
    wm protocol . WM_DELETE_WINDOW "$this cancel"

    LabelEntry $this.newsgroup -labeltext "Newsgroup" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.from -labeltext "From" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.subject -labeltext "Subject" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.organization -labeltext "Organization" \
		-labelwidth 15 -entrywidth 50
    LabelEntry $this.references -labeltext "References" \
		-labelwidth 15 -entrywidth 50
    pack $this.newsgroup $this.from $this.subject $this.organization \
		$this.references -side top -fill x

    frame $this.article
    text $this.article.text -relief sunken -bd 2\
	-yscrollcommand "$this.article.scroll set" -setgrid true \
	-width 70 -height 30
    scrollbar $this.article.scroll -relief sunken \
	-command "$this.article.text yview" -width 14
    pack $this.article.scroll -side right -fill y
    pack $this.article.text -expand yes -fill both
    pack $this.article -expand yes -side top -fill both
 
    frame $this.buttons -relief sunken -bd 1
    button $this.buttons.ok -text "OK" -width 8 \
		-command "$this ok"
    button $this.buttons.cancel -text "Cancel" -width 8 \
		-command "$this cancel"
    pack $this.buttons.cancel $this.buttons.ok -side right \
		-padx 3 -pady 2
    pack $this.buttons -side top -fill x

    $this.organization setEntry [$main getConfig organization]
    $this.from setEntry "[$main getConfig email] ([$main getConfig name])"
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method ok {} \
  { set nntp_socket [$main getNntpSocket]
    set error_flag 0
    if {$nntp_socket != ""} \
    {
      dp_send $nntp_socket "group $current_group"
      gets $nntp_socket line
      dp_send $nntp_socket "post"
      gets $nntp_socket line
      if {[lindex $line 0] >= 400} \
      { show_error $this "Error" $line
        set error_flag 1
      } \
      else \
      { set newsgroup [$this.newsgroup getEntry]
        set from [$this.from getEntry]
        set organization [$this.organization getEntry]
        set subject [$this.subject getEntry]
        set references [$this.references getEntry]
        set article [$this.article.text get 1.0 end]
        dp_send $nntp_socket "From: $from"
        dp_send $nntp_socket "Newsgroups: $newsgroup"
        dp_send $nntp_socket "Subject: $subject"
        dp_send $nntp_socket "Organization: $organization"
        dp_send $nntp_socket "References: $references"
        dp_send $nntp_socket "X-Newsreader: [$main getAppVersion]"
        dp_send $nntp_socket ""
        set lines [split $article \n]
        foreach line $lines \
        { if {$line == "."} { set line ".." }
          dp_send $nntp_socket $line
        }
        dp_send $nntp_socket "."
        gets $nntp_socket line
        if {[lindex $line 0] >= 400} \
        { show_error $this "Error" $line
          set error_flag 1
        }
      }
    }
    if {$error_flag == 0} \
    { eval $closecommand }
  }

  method cancel {} \
  { eval $closecommand }

  method setGroupAndClear {group} \
  { set current_group $group
    $this.article.text delete 1.0 end
    $this.article.text insert 1.0 "\n--\n[$main getSignature]"
    $this.newsgroup setEntry $group
    $this.subject setEntry ""
  }

  method setFollowup {subject references} \
  { $this.subject setEntry $subject
    $this.references setEntry $references
  }

  method takeFocus {} \
  {
  }

  public closecommand ""
  public title ""
  public main ""

  protected current_group ""
}








