#!/usr/local/bin/wish4.1 -f
#
## this is tkbroadcast
## there is no documentation as yet.
## Ethan Gold, January, 1996 (etgold@cs.vassar.edu)


## global variables
set rcfilepath $env(HOME)/.tkbcrc
set daemonfilepath $env(HOME)/.tkbcd
#set rcfilepath ./.tkbcrc
set rcfile ""
set port 5000
## set userarray
set thelist ""


## define all the widgets for the main window
scrollbar .scroll -command ".names yview"
listbox .names -relief sunken -yscrollcommand ".scroll set"
entry .arbitrary -width 30 -relief sunken -textvariable whoname
button .arbsend -command {arbsend $whoname} -text "send to above"
button .addname -command {addNew} -text "add new"
button .send -command {sendTest} -text "send"
button .close -command {quit} -text "close"
button .reread -command {reRead} -text "reread"
button .personalinfo -command {personalInfo} -text "own info"
button .delete -command {deleteEntry} -text "delete entry"

## pack the main window
pack .scroll -side left -fill y -pady 1m
pack .names -side left -expand 1 -fill both -pady 1m
#pack .arbitrary .arbsend .send .reread .close
pack .arbitrary .arbsend .send .addname .delete .personalinfo .reread .close


proc findRc {} {
    ## check for the .tkbcrc file
    global rcfilepath rcfile
    if { [file exists $rcfilepath] } {
	set rcfile [open $rcfilepath r]
    } else {
	error "\$HOME/.tkbcrc missing. please enter your personal info."
	exec touch $rcfilepath
	set rcfile [open $rcfilepath r]	
    }
}


proc readRc {} {
    ## read in the rc file and set things up
    ## the rcfile will be of the format:
    ##   record(keyword) handle_name machine_name port_number
    ## the data will be stored in an array indexed on the handle
    ## name. the handle will be the text appearing in the selection
    ## box and will be used to key the data for that receipient.
    global rcfile userarray thelist myport myname
    while { [gets $rcfile line] != -1 } {
	if { [regexp {^record\ .*} $line] } {
	    set userarray([lindex $line 1]) [lrange $line 2 end]
	}
	if { [regexp {myname\ .*} $line] } {
	    set myname [lindex $line 1]
	}
	if { [regexp {myport\ .*} $line] } {
	    set myport [lindex $line 1]
	}

	append thelist $line
    }
    close $rcfile
}


proc error {errormessage} {
    ## display an error message
    toplevel .error -class Dialog
    message .error.message -text "$errormessage"
    button .error.ok -text "Ok" -command {destroy .error}
    pack .error.message .error.ok
}

proc sendTest {} {
    ## catch selection errors
    ## from the send button
    if { [catch {selection get}] } {
	error "you must select an entry first"
    } else {
	send [selection get]
    }
}

proc showNames {} {
    ## put the names into the listbox
    global userarray
    foreach name [array names userarray] {
	.names insert end $name
    }
}


proc deleteEntry {} {
    ## delete an entry from the name
    ## list and rcfile

    global rcfilepath
    
    if { [catch {selection get}] } {
	error "you must select an entry first"
    } else {
	set record [selection get]
	set newrc [open $rcfilepath.new w]
	set rcfile [open $rcfilepath r]
	while { [gets $rcfile line] != -1 } {
	    if { [regexp ".*$record.*" $line] } {
		continue
	    } else {
		puts $newrc $line
	    }
	}
	close $newrc
	close $rcfile
	exec mv $rcfilepath $rcfilepath.bak
	exec mv $rcfilepath.new $rcfilepath
	findRc
	reRead
    }   
}


proc doChange {newname newport} {
    ## helper function to do the actual
    ## personal name and port changes
    ## and restart the background daemon

    global myport myname rcfilepath daemonfilepath env
    set newrc [open $rcfilepath.new w]
    set rcfile [open $rcfilepath r]
    puts $newrc "myname \"$newname\""
    puts $newrc "myport $newport"
    while { [gets $rcfile line] != -1 } {
	if { [regexp {myname\ .*} $line] } {
	    continue
	} elseif { [regexp {myport\ .*} $line] } {
	    continue
	} else {
	    puts $newrc $line
	}
    }
    close $newrc
    close $rcfile
    exec mv $rcfilepath $rcfilepath.bak
    exec mv $rcfilepath.new $rcfilepath
    if { [file exists $daemonfilepath] } {
	catch {exec cat $daemonfilepath | xargs kill}
	catch {exec rm $daemonfilepath}
	set env(PWD) $env(HOME)
	exec tkbcd &
    }
    
    findRc
    reRead
}


proc personalInfo {} {
    ## manage personal info:
    ## alias and port number

    global myname myport
    toplevel .pInfo -class Dialog
    label .pInfo.aliaslabel -text "alias:"
    label .pInfo.portlabel -text "port:"
    entry .pInfo.alias -width 30 -relief sunken -textvariable myname
    entry .pInfo.port -width 10 -relief sunken -textvariable myport
    button .pInfo.close -text "close" -command {destroy .pInfo}
    button .pInfo.change -text "change" -command {doChange $myname $myport}

    pack .pInfo.aliaslabel .pInfo.alias
    pack .pInfo.portlabel .pInfo.port
    pack .pInfo.change -side left
    pack .pInfo.close -side right
    
}


proc doAdd {alias machine port} {
    ## add new record to rcfile

    global rcfilepath
    set rcfile [open $rcfilepath a]
    puts $rcfile "record \"$alias\" $machine $port"
    close $rcfile
    findRc
    reRead
}

proc addNew {} {
    ## add a new name from the entry widget
    ## to the rcfile and read it in again

    toplevel .newaddress -class Dialog
    label .newaddress.aliaslabel -text "alias:"
    label .newaddress.machinelabel -text "machine:"
    label .newaddress.portlabel -text "port:"
    entry .newaddress.alias -width 30 -relief sunken -textvariable newalias
    entry .newaddress.machine -width 30 -relief sunken -textvariable newmachine
    entry .newaddress.port -width 10 -relief sunken -textvariable newport
    button .newaddress.close -text "close" -command {destroy .newaddress}
    button .newaddress.add -text "add" -command {doAdd $newalias \
	    $newmachine $newport}

    pack .newaddress.aliaslabel .newaddress.alias 
    pack .newaddress.machinelabel .newaddress.machine
    pack .newaddress.portlabel .newaddress.port
    pack .newaddress.add -side left
    pack .newaddress.close -side right
}

proc reRead {} {
    ## reread the resource file and update
    ## the address list widget
    global userarray
    catch {unset userarray}
    findRc
    readRc
    .names delete 0 end
    showNames
}

proc send {destination} {
    ## spawn a sender script to handle
    ## an outgoing message

    global userarray
    set machine [lindex $userarray($destination) 0]
    set port [lindex $userarray($destination) 1]
    exec tkbroadcastsend.tcl $machine $port &
}

proc arbsend {whoto} {
    ## send to an abritary destination
    ## from the entry box
    exec tkbroadcastsend.tcl [lindex $whoto 0] [lindex $whoto 1] &
}

proc quit {} {
    ## exit
    global rcfilepath
    exit
}

##-------------------------------------------------
## begin running everything below this divider
##-------------------------------------------------


## check for the resource file
findRc

## read in the resource file
readRc

## show the names in the listbox
foreach name [array names userarray] {
    .names insert end $name
}




## do key bindings
bind .names <Double-1> {
	send [selection get]
}

bind .names <Return> {
    if { [catch {selection get}] } {
	error { "you must select a name" }
    } else {
	send [selection get]
    }
}

#bind . <Return> {
#    send [selection get]
#}

bind .arbitrary <Return> {
    arbsend $whoname
}




