#!/usr/local/bin/tclsh7.5
## this is tkbroadcast
## there is no documentation as yet.
## Ethan Gold, January, 1996 (etgold@cs.vassar.edu)

set portnum 5000
set terminal 0
set rcfilepath $env(HOME)/.tkbcrc
#set rcfilepath ./.tkbcrc
set sound 0
set soundpath /usr/local/student/lib/tkbc.au
set rcfile ""
set x 200
set y 200

# keep magic cookie receiver off in mind.

## look for "terminal" command line switch
## which indicates that we are NOT logged
## in under X
if { [string compare [lindex $argv 0] "terminal"] } {
    set terminal 1
}


proc findRc {} {
    global rcfile rcfilepath env
    if { [file exists $rcfilepath] } {
	set rcfile [open $rcfilepath r]
    } else {
	puts ".tkbcrc file missing"
	exit
    }
    exec echo [pid] > $env(HOME)/.tkbcd
}



proc readRc {} {
    ## read in resource file
    global rcfile portnum sound
    while { [gets $rcfile line] != -1 } {
	if { [regexp {^myport\ [0-9]+.*} $line] } {
	    set portnum [lindex $line 1]
	}
	if { [regexp {^sound\ on.*} $line] } {
	    set sound 1
	}
    }
    close $rcfile
}


proc incoming { socket machine port } {
    global x y sound
    gets $socket info
    while { [gets $socket line] != -1 } {
	append message $line\n
    }
    if { $y >7900 } {
	set x 200
	set y 200
    }
    if { $sound } {
	catch {exec cat $soundpath > /dev/audio &}
    }
    catch {exec tkbroadcastshow.tcl -geometry +$x+$y $info $message &}
    set x [expr $x + 50]
    set y [expr $y + 50]
}

## find the resource file
findRc

## read in the resrouce file
readRc

## set up the port we're listening on
#set theport [tcp listen $portnum]

## main event loop to handle incoming
## messages and spawn message windows
set sockflag [socket -server { incoming } $portnum]

while { 1 } {
    vwait sockflag
}


