#!/usr/local/bin/wish4.1 -f
## this is tkbroadcast
## there is no documentation as yet.
## Ethan Gold, January, 1996 (etgold@cs.vassar.edu)

if { $argc != 2} {
    puts "tkbroadcastsend: wrong number of arguments\n \
	    should be: tkbroadcastsend machine port"
    exit
}

set machine [lindex $argv 0]
set port [lindex $argv 1]
set domainpath /etc/resolv.conf
set mydomain ""
set file ""


set rcfilepath $env(HOME)/.tkbcrc
#set rcfilepath ./.tkbcrc

if { [file exists $rcfilepath] } {
    set rcfile [open $rcfilepath r]
} else {
    puts ".tkbcrc file missing"
    exit
}

## parse /etc/resolve.conf for domainname
set resolv [open $domainpath r]
while { [gets $resolv line] != -1 } {
    if { [regexp {domain.*} $line] } {
	set mydomain [lindex $line 1]
    }
}

## get hostname and see if it is absolute
set hostname [exec hostname]
if { [regexp $mydomain $hostname] == 0 } {
    set hostname $hostname.$mydomain
}


## keep magic cookie receiver off in mind.

while { [gets $rcfile line] != -1 } {
    if { [regexp {myname\ .*} $line] } {
	set myname [lindex $line 1]
    } elseif { [regexp {myport\ .*} $line] } {
	set myport [lindex $line 1]
    }
}
close $rcfile

proc sendmessage {message} {
    global machine port myname myport hostname
    set mysock [socket $machine $port]
    puts $mysock "\"$myname\" $hostname $myport"
    puts $mysock $message
    close $mysock
    exit
}

proc insert {file} {
    global env
    ## do tilde expansion, assuming everyone has the
    ## same $HOME/.. directory

    regsub "~/" $file "$env(HOME)/" newfile
    regsub $env(USER) $env(HOME) "" tophome
    regsub "~" $newfile $tophome file

    set infile [exec cat $file]
    .message insert end $infile
}

scrollbar .scroll -command ".message yview"
text .message -width 50 -height 5 -yscrollcommand ".scroll set"
entry .file -textvariable file
button .send -text "Send" -command {sendmessage [.message get 0.0 end]}
button .cancel -text "Cancel" -command {exit}
button .include -text "insert file" -command {insert $file}

pack .scroll -side left -fill y -pady 1m
pack .message -expand 1 -fill both
pack .send -side right
pack .cancel -side right
pack .include -side right
pack .file -side right

bind .message <KP_Enter> {
    sendmessage [.message get 0.0 end]
}

bind .file <Return> {
    insert $file
}

bind .file <KP_Enter> {
    sendmessage [.message get 0.0 end]
}
