#!/usr/local/bin/wish4.1 -f
## this is tkbroadcast
## there is no documentation as yet.
## Ethan Gold, January, 1996 (etgold@cs.vassar.edu)

if { $argc != 2} {
    puts "tkbroadcastshow: wrong number of arguments\n \
	    should be: tkbroadcastsend info_string message_string"
    exit
}

set info [lindex $argv 0]
set message [lindex $argv 1]
set handle [lindex $info 0]
set machine [lindex $info 1]
set port [lindex $info 2]

set rcfilepath $env(HOME)/.tkbcrc
#set rcfilepath ./.tkbcrc

if { [file exists $rcfilepath] } {
    set rcfile [open $rcfilepath r]
} else {
    puts ".tkbcrc file missing"
    exit
}


#if { [string compare [lindex $argv 0] "terminal"] } {
#    set terminal 1
#}


# keep magic cookie receiver off in mind.

proc error {errormessage} {
    ## display an error message
    toplevel .error -class Dialog
    message .error.message -text "$errormessage"
    button .error.ok -text "Ok" -command {destroy .error}
    pack .error.message .error.ok
}

proc save {} {
    global filename env
    if { [string compare $filename ""] == 0} {
	error "you must provide a filename before saving"
    } else {
	## do tilde expansion
	regsub "~/" $filename "$env(HOME)/" newfile
	regsub $env(USER) $env(HOME) "" tophome
	regsub "~" $newfile $tophome filename
	## replace spaces with _
	regsub -all " " $filename "_" filename
	set thetext [.message get 0.0 end]
	set outfile [open $filename w]
	puts $outfile $thetext
	close $outfile
    }
}

proc reply {} {
    global handle machine port
    exec tkbroadcastsend.tcl $machine $port &
}

scrollbar .scroll -command ".message yview"
text .message -width 50 -height 5 -yscrollcommand ".scroll set"
button .reply -text "Reply" -command {reply}
button .close -text "Close" -command {exit}
button .save -text "Save" -command {save}
entry .filename -text "tkbc.save" -textvariable filename
label .from -text "$handle@$machine:$port"

pack .from
pack .scroll -side left -fill y -pady 1m
pack .message -expand 1 -fill both
pack .reply -side right
pack .close -side right
pack .save -side right
pack .filename -side right

.message insert end $message

bind .message <KP_Enter> {
    reply
}

bind .filename <KP_Enter> {
    reply
}

bind .filename <Return> {
    save
}
