#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Object.tcl,v $
# $Date: 1996/12/06 10:38:03 $
# $Revision: 1.18.1.9 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
package provide zircon 1.18
#
proc objName {class} {
    global OType
    set n [newName $class]
    set OType($n) $class
    return $n
}
#
proc newName {thing} {
    global zircon
    return [string tolower $thing][incr zircon(nameCount)]
}
#
proc class {name vars args} {
    global $name Private.$name Configure.$name
    set $name {}
    foreach {x y z} $vars {
	lappend $name $x $y
	set Configure.${name}($x) $z
    }
    switch {} $args {} default {set Private.$name [lindex $args 0]}
}
#
proc initObj {name args} {
    foreach x $args {
	uplevel #0 "array set $name \[set $x\]"
	catch {uplevel #0 "array set $name \[set Private.$x\]"}
    }
}
