/*
 *	$Source: /home/nlfm/Working/Frink/RCS/frink.c,v $
 *	$Date: 1997/08/13 14:35:10 $
 *	$Revision: 1.2.1.22 $
 *
 *------------------------------------------------------------------------
 *   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
 *------------------------------------------------------------------------
 *    Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
 *========================================================================
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "frink.h"

int lmargin	= 0;
int tclX	= 0;
int addSpaces	= 0;
int width	= 80;
int indent	= 4;
int contdent	= 2;
int nocomments	= 0;
int obfuscate	= 0;
int tabsOn	= 1;
int putElse	= 0;
int putThen	= 0;
int tabStops	= 8;
int minimise	= 0;
int xf		= 0;
int oneliner	= 0;
int doBind	= 1;
int haltonWarn	= 0;
int doCatch	= 1;
int debrace	= 0;
int embrace	= 0;
int trace	= 0;
int varbrace	= 0;
int noblanks	= 0;
int procnls	= 0;
int switchIn	= 0;
int elseif	= 0;
int doTime	= 1;
int olcomments	= 1;
int eValue	= 0;
char *style	= (char *) 0;
char *pstyle	= (char *) 0;
char *contString 	= "";


#ifndef __FreeBSD__
extern int getopt(int, char*const*, const char*);
#endif

extern int optind;
extern char *optarg;
extern int fclose(FILE*);

static void doVersion()
{
    printf("Frink 1.2 patch level 22\n");
    exit(0);
}

static void usage()
{
    fprintf(stderr, "frink [flags] [files] where the flags can be"
	    "\n"
	    "\n-a 	: put spaces around -command code in {} and \"\". (default = OFF)"
	    "\n-b 	: add braces (see manual page for details) (default = OFF)"
	    "\n-B	: turns OFF processing of code with bind calls."
	    "\n-c <n>	: set further indent for continuations to n. default = 2"
	    "\n-C	: turns OFF processing of code with catch calls."
	    "\n-d	: remove braces in certain (safe) circumstances (default = OFF)"
	    "\n-e	: produce \"else\". default = OFF"
	    "\n-E	: optimise string comparisons. Use at your own risk.  (default = 0)"
	    "\n-g	: indent switch cases. (default = OFF)"
	    "\n-h	: print this message."
	    "\n-i <n>	: set indent for each level to n. default = 4"
	    "\n-j	: remove non-essential blank lines. (default = OFF)"
	    "\n-k	: remove non-essential braces."
	    "\n-l	: try for one-liners (not yet implemented)"
	    "\n-m	: minimise the code by removing redundant spacing. default = OFF"
	    "\n-n 	: do not generate tab characters. default = OFF"
	    "\n-o	: obfuscate (not implemented yet) : default = OFF"
	    "\n-p <v>	: If v is a number produce that many blank lines after each"
	    "\n	proc definition, otherwise produce whatever format the code"
	    "\n	indicates. No codes are defined yet..... (default = do nothing)"
	    "\n-P	: Turn off processing of \"time\" command. default = OFF"
	    "\n-r	: remove comments. default = OFF"
	    "\n-s <c>	: format according to style \"c:\""
	    "\n-S	: Don't preserve end of line comments. default = OFF"
	    "\n-t <n>	: set tabstops every n characters. default = 8"
	    "\n-T	: produce \"then\". default = OFF"
	    "\n-u	: safe to remove brackets from elseif conds"
	    "\n-v	: put { } round variable names where appropriate."
	    "\n-w <n>	: set line length. default = 80"
	    "\n-W    	: halt on Warnings as well as errors"
	    "\n-x	: produce \"xf style\" continuations"
	    "\n-z	: do not put a single space before the \\ character on continuations."
	    "\n-T	: produce \"then\". default = OFF"
	    "\n-V	: the current version number"
	    "\n-X	: recognise tclX constructs"
	    "\n");
}

void setOption(int flag, char *value)
{
    switch (flag)
    {
    case 'B' :	doBind = 0; break;
    case 'C' :  doCatch = 0; break;
    case 'D' :	trace = 1; break;
    case 'P' :  doTime = 0; break;
    case 'S' :  olcomments = 0; break;
    case 'T' :	putThen = 1; break;
    case 'W' :  haltonWarn = 1; break;
    case 'V' :  doVersion();
    case 'X' :	tclX = 1; break;
    case 'a' :	addSpaces = 1; break;
    case 'b' :	embrace = 1; debrace = 0; break;
    case 'c' :	contdent = atoi(value); break;
    case 'd' :	debrace = 1; embrace = 0; break;
    case 'e' :	putElse = 1; break;
    case 'E' :	eValue = atoi(value); break;
    case 'g' :	switchIn = 1; break;
    case 'i' :	indent = atoi(value); break;
    case 'j' :	noblanks = 1; break;
    case 'k' :	debrace = 1; break;
    case 'l' :	oneliner = 1; break;
    case 'm' :	minimise = 1; break;
    case 'n' :	tabsOn = 0; break;
    case 'o' :	obfuscate = 1; break;
    case 'p' :
	if (isdigit(*value))
	{
	    procnls = atoi(value);
	}
	else
	{
	    pstyle = optarg;
	}
	break;
    case 'r' :	nocomments = 1; break;
    case 's' :	style = value; break;
    case 't' :	tabStops = atoi(value); break;
    case 'u' :  elseif = 1; break;
    case 'v' :	varbrace = 1; break;
    case 'w' :	width = atoi(value); break;
    case 'x' :	xf = 1; break;
    case 'z' :	contString = " "; break;
    case 'h' :
    default :	usage(); exit(1);
    }
}

static void options(int argc, char *argv[])

{
    int flg;

    while ((flg = getopt(argc, argv ,"BCDE:PSTVWXabc:deghi:jklmnoprs:t:uvw:xz")) != -1)
    {
	setOption(flg, optarg);
    }
}

static void setStyle()
{
    if (style != (char *) 0)
    {
	if (strcmp(style, "ouster") == 0)
	{
	    switchIn = 1;
	    putElse = 1;
	    debrace = 1;
	}
    }
    if (obfuscate || minimise)
    {
	minimise = 1;
	debrace = 1;
	embrace = 0;
	noblanks = 1;
	nocomments = 1;
	putElse = 0;
	putThen = 0;
	oneliner = 1;
	indent = 0;
	contdent = 0;
    }
}

static void readrc(char *file)
{
    char *opts[50], buff[128], *cp;
    FILE *desc;
    int leng, i;

    if ((desc = fopen(file, "r")) != NULL)
    {
	leng = fread(buff, 1, 127, desc);
	fclose(desc);
	buff[leng] = '\0';
	cp = buff;
	opts[0] = "";
	leng = 1;
	while (*cp)
	{
	    while (isspace(*cp)) { cp++; }
	    opts[leng++] = cp;
	    while (*cp && !isspace(*cp)) { cp++; }
	    if (*cp) { *cp++ = '\0'; }
	}
	for (i = 0; i < leng; i += 1)
	{
	    if (*opts[i] == '-')
	    {
		setOption(opts[i][1], opts[i+1]);
	    }
	}
    }
}

static void findrc()
{
    char *home, file[512];
    if ((home = getenv("HOME")) != (char *) 0)
    {
	strcat(strcpy(file, home),"/.frinkrc");
	readrc(file);
    }
    readrc("./.frinkrc");
}

static void process(FILE *desc)
{
    extern void flushOutput();
    extern int handle(Token *line);
    extern void streamMore(Input *);

    Input file;

    file.text = (char *) malloc(64*1024);
    file.stream = desc;
    file.tcall = 0;
    file.lineNumber = 1;
    file.lineStart = 1;    
    streamMore(&file);
    while (handle(collect(&file)))
    {
    }
    flushOutput();
    free(file.text);
}


int main(int argc, char **argv)
{
    FILE  *desc;
    extern void initOutput();

    findrc();
    options(argc, argv);
    setStyle();
    initOutput();
    if (argv[optind] == (char *) 0)
    {
	process(stdin);
    }
    else
    {
	while (argv[optind] != (char *) 0)
	{
	    if ((desc = fopen(argv[optind], "r")) == NULL)
	    {
		fprintf(stderr, "\"%s\" cannot be accessed!!\n", argv[optind]);
	    }
	    else
	    {
		process(desc);
		fclose(desc);
	    }
	    optind += 1;
	}
    }
    return 0;
}
