/*
 * tcl.h --
 *
 *	This header file describes the externally-visible facilities
 *	of the Tcl interpreter.
 *
 * Copyright (c) 1987-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * /u/durian/cvs/tclm2/WINDOWS/include/tcl.h,v 1.2 1995/09/06 17:53:08 durian Exp SPRITE (Berkeley)
 */
/*
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef _TCL
#define _TCL

#ifndef BUFSIZ
#include <stdio.h>
#endif

#define TCL_VERSION "7.3"
#define TCL_MAJOR_VERSION 7
#define TCL_MINOR_VERSION 3

#ifdef _WINDOWS
#define MAX_VAR 65500
#define EXPORT __export
#define CDECL __cdecl
#define PASCAL __pascal
#define FAR __far
#define NEAR __near
#define stdin ((FILE*)0)
#define stdout ((FILE*)1)
#define stderr ((FILE*)2)
#else
#define EXPORT
#define CDECL
#define PASCAL
#define FAR 
#define NEAR 
#endif /* _WINDOWS */

/*
 * Definitions that allow this header file to be used either with or
 * without ANSI C features like function prototypes.
 */

#undef _ANSI_ARGS_
#undef CONST
#if ((defined(__STDC__) || defined(SABER)) && !defined(NO_PROTOTYPE)) || defined(__cplusplus)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)	x
#   define CONST const
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else
#   define _ANSI_ARGS_(x)	()
#   define CONST
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif

/*
 * Macro to use instead of "void" for arguments that must have
 * type "void *" in ANSI C;  maps them to type "char *" in
 * non-ANSI systems.
 */

#ifndef VOID
#   ifdef __STDC__
#       define VOID void
#   else
#       define VOID char
#   endif
#endif

/*
 * Miscellaneous declarations (to allow Tcl to be used stand-alone,
 * without the rest of Sprite).
 */

#ifndef NULL
#define NULL 0
#endif

#ifndef _CLIENTDATA
#   ifdef __STDC__
    typedef void *ClientData;
#   else
    typedef int *ClientData;
#   endif /* __STDC__ */
#define _CLIENTDATA
#endif

/*
 * Data structures defined opaquely in this module.  The definitions
 * below just provide dummy types.  A few fields are made visible in
 * Tcl_Interp structures, namely those for returning string values.
 * Note:  any change to the Tcl_Interp definition below must be mirrored
 * in the "real" definition in tclInt.h.
 */

typedef struct Tcl_Interp{
    char *result;		/* Points to result string returned by last
				 * command. */
    void (*freeProc) _ANSI_ARGS_((char *blockPtr));
				/* Zero means result is statically allocated.
				 * If non-zero, gives address of procedure
				 * to invoke to free the result.  Must be
				 * freed by Tcl_Eval before executing next
				 * command. */
    int errorLine;		/* When TCL_ERROR is returned, this gives
				 * the line number within the command where
				 * the error occurred (1 means first line). */
} Tcl_Interp;

typedef int *Tcl_Trace;
typedef struct Tcl_AsyncHandler_ *Tcl_AsyncHandler;

/*
 * When a TCL command returns, the string pointer interp->result points to
 * a string containing return information from the command.  In addition,
 * the command procedure returns an integer value, which is one of the
 * following:
 *
 * TCL_OK		Command completed normally;  interp->result contains
 *			the command's result.
 * TCL_ERROR		The command couldn't be completed successfully;
 *			interp->result describes what went wrong.
 * TCL_RETURN		The command requests that the current procedure
 *			return;  interp->result contains the procedure's
 *			return value.
 * TCL_BREAK		The command requests that the innermost loop
 *			be exited;  interp->result is meaningless.
 * TCL_CONTINUE		Go on to the next iteration of the current loop;
 *			interp->result is meaningless.
 */

#define TCL_OK		0
#define TCL_ERROR	1
#define TCL_RETURN	2
#define TCL_BREAK	3
#define TCL_CONTINUE	4

#define TCL_RESULT_SIZE 200

/*
 * Argument descriptors for math function callbacks in expressions:
 */

typedef enum {TCL_INT, TCL_DOUBLE, TCL_EITHER} Tcl_ValueType;
typedef struct Tcl_Value {
    Tcl_ValueType type;		/* Indicates intValue or doubleValue is
				 * valid, or both. */
    int intValue;		/* Integer value. */
    double doubleValue;		/* Double-precision floating value. */
} Tcl_Value;

/*
 * Procedure types defined by Tcl:
 */

typedef int (FAR PASCAL Tcl_AsyncProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int code));
typedef void (FAR PASCAL Tcl_CmdDeleteProc) _ANSI_ARGS_((ClientData clientData));
typedef int (FAR PASCAL Tcl_CmdProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));
typedef void (FAR PASCAL Tcl_CmdTraceProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int level, char *command, Tcl_CmdProc *proc,
	ClientData cmdClientData, int argc, char **argv));
typedef void (Tcl_FreeProc) _ANSI_ARGS_((char *blockPtr));
typedef void (FAR PASCAL Tcl_InterpDeleteProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp));
typedef int (FAR PASCAL Tcl_MathProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, Tcl_Value *args, Tcl_Value *resultPtr));
typedef char *(FAR PASCAL Tcl_VarTraceProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, char *part1, char *part2, int flags));

/*
 * The structure returned by Tcl_GetCmdInfo and passed into
 * Tcl_SetCmdInfo:
 */

typedef struct Tcl_CmdInfo {
    Tcl_CmdProc *proc;			/* Procedure that implements command. */
    ClientData clientData;		/* ClientData passed to proc. */
    Tcl_CmdDeleteProc *deleteProc;	/* Procedure to call when command
					 * is deleted. */
    ClientData deleteData;		/* Value to pass to deleteProc (usually
					 * the same as clientData). */
} Tcl_CmdInfo;

/*
 * The structure defined below is used to hold dynamic strings.  The only
 * field that clients should use is the string field, and they should
 * never modify it.
 */

#define TCL_DSTRING_STATIC_SIZE 200
typedef struct Tcl_DString {
    char *string;		/* Points to beginning of string:  either
				 * staticSpace below or a malloc'ed array. */
    int length;			/* Number of non-NULL characters in the
				 * string. */
    int spaceAvl;		/* Total number of bytes available for the
				 * string and its terminating NULL char. */
    char staticSpace[TCL_DSTRING_STATIC_SIZE];
				/* Space to use in common case where string
				 * is small. */
} Tcl_DString;

#define Tcl_DStringLength(dsPtr) ((dsPtr)->length)
#define Tcl_DStringValue(dsPtr) ((dsPtr)->string)

/*
 * Definitions for the maximum number of digits of precision that may
 * be specified in the "tcl_precision" variable, and the number of
 * characters of buffer space required by Tcl_PrintDouble.
 */

#define TCL_MAX_PREC 17
#define TCL_DOUBLE_SPACE (TCL_MAX_PREC+10)

/*
 * Flag values passed to Tcl_Eval (see the man page for details;  also
 * see tclInt.h for additional flags that are only used internally by
 * Tcl):
 */

#define TCL_BRACKET_TERM	1

/*
 * Flag that may be passed to Tcl_ConvertElement to force it not to
 * output braces (careful!  if you change this flag be sure to change
 * the definitions at the front of tclUtil.c).
 */

#define TCL_DONT_USE_BRACES	1

/*
 * Flag value passed to Tcl_RecordAndEval to request no evaluation
 * (record only).
 */

#define TCL_NO_EVAL		-1

/*
 * Special freeProc values that may be passed to Tcl_SetResult (see
 * the man page for details):
 */

#define TCL_VOLATILE	((Tcl_FreeProc *) -1)
#define TCL_STATIC	((Tcl_FreeProc *) 0)
#define TCL_DYNAMIC	((Tcl_FreeProc *) free)

/*
 * Flag values passed to variable-related procedures.
 */

#define TCL_GLOBAL_ONLY		1
#define TCL_APPEND_VALUE	2
#define TCL_LIST_ELEMENT	4
#define TCL_TRACE_READS		0x10
#define TCL_TRACE_WRITES	0x20
#define TCL_TRACE_UNSETS	0x40
#define TCL_TRACE_DESTROYED	0x80
#define TCL_INTERP_DESTROYED	0x100
#define TCL_LEAVE_ERR_MSG	0x200

/*
 * Types for linked variables:
 */

#define TCL_LINK_INT		1
#define TCL_LINK_DOUBLE		2
#define TCL_LINK_BOOLEAN	3
#define TCL_LINK_STRING		4
#define TCL_LINK_READ_ONLY	0x80

/*
 * Permission flags for files:
 */

#define TCL_FILE_READABLE	1
#define TCL_FILE_WRITABLE	2

#ifdef KANJI
/*
 * Integer values for KANJI codes
 */
#define TCL_NOT_KANJI	-1
#define TCL_JIS		0
#define TCL_SJIS	1
#define TCL_EUC		2
#define TCL_ANY		3

EXTERN char *Tcl_KanjiCodeStr[4];

#ifndef TCL_DEFAULT_KANJI_CODE
#define TCL_DEFAULT_KANJI_CODE TCL_EUC
#endif

/*
 * type definition for wide character
 */
#ifndef WCHAR_DEFINED
#define WCHAR_DEFINED
typedef unsigned short	wchar;
#endif

/*
 * type definition for an array of kanji encode/decode procedures
 */
#ifdef _WINDOWS
typedef int (FAR PASCAL _TclKanjiEncodeProc) _ANSI_ARGS_((unsigned char *ks, wchar *ws));
typedef int (FAR PASCAL _TclKanjiDecodeProc) _ANSI_ARGS_((wchar *ws, unsigned char *ks));
typedef _TclKanjiEncodeProc *Tcl_KanjiEncodeProc[4]; 
typedef _TclKanjiDecodeProc *Tcl_KanjiDecodeProc[4]; 
#else
typedef int (*Tcl_KanjiEncodeProc[]) _ANSI_ARGS_((unsigned char *ks, wchar *ws));
typedef int (*Tcl_KanjiDecodeProc[]) _ANSI_ARGS_((wchar *ws, unsigned char *ks));
#endif /* _WINDOWS */

/*
 * array of kanji encode/decode procedures
 */
EXTERN Tcl_KanjiEncodeProc Tcl_KanjiEncode;
EXTERN Tcl_KanjiDecodeProc Tcl_KanjiDecode;

/*
 * macros for wide characters
 */
#define ISWKANA(wc)	(((wc) & 0x8080) == 0x80)
#define ISWKANJI(wc)	(((wc) & 0x8080) == 0x8080)
#define ISWSPACE(wc)	(isascii(wc) && isspace(wc))
#define ISWUPPER(wc)	(isascii(wc) && isupper(wc))
#define ISWLOWER(wc)	(isascii(wc) && islower(wc))
#define ISWALNUM(wc)	(isascii(wc) && isalnum(wc))

#endif /* KANJI */

/*
 * The following declarations either map ckalloc and ckfree to
 * malloc and free, or they map them to procedures with all sorts
 * of debugging hooks defined in tclCkalloc.c.
 */

#ifdef TCL_MEM_DEBUG

EXTERN char *	FAR PASCAL EXPORT	Tcl_DbCkalloc _ANSI_ARGS_((unsigned int size,
			    char *file, int line));
EXTERN int	FAR PASCAL EXPORT	Tcl_DbCkfree _ANSI_ARGS_((char *ptr,
			    char *file, int line));
EXTERN char *	FAR PASCAL EXPORT	Tcl_DbCkrealloc _ANSI_ARGS_((char *ptr,
			    unsigned int size, char *file, int line));
EXTERN int	FAR PASCAL EXPORT	Tcl_DumpActiveMemory _ANSI_ARGS_((char *fileName));
EXTERN void	FAR PASCAL EXPORT	Tcl_ValidateAllMemory _ANSI_ARGS_((char *file,
			    int line));
#  define ckalloc(x) Tcl_DbCkalloc(x, __FILE__, __LINE__)
#  define ckfree(x)  Tcl_DbCkfree(x, __FILE__, __LINE__)
#  define ckrealloc(x,y) Tcl_DbCkrealloc((x), (y),__FILE__, __LINE__)

#else

#  define ckalloc(x) malloc(x)
#  define ckfree(x)  free(x)
#  define ckrealloc(x,y) realloc(x,y)
#  define Tcl_DumpActiveMemory(x)
#  define Tcl_ValidateAllMemory(x,y)

#endif /* TCL_MEM_DEBUG */

/*
 * Macro to free up result of interpreter.
 */

#define Tcl_FreeResult(interp)					\
    if ((interp)->freeProc != 0) {				\
	if ((interp)->freeProc == (Tcl_FreeProc *) free) {	\
	    ckfree((interp)->result);				\
	} else {						\
	    (*(interp)->freeProc)((interp)->result);		\
	}							\
	(interp)->freeProc = 0;					\
    }

/*
 * Forward declaration of Tcl_HashTable.  Needed by some C++ compilers
 * to prevent errors when the forward reference to Tcl_HashTable is
 * encountered in the Tcl_HashEntry structure.
 */

#ifdef __cplusplus
struct Tcl_HashTable;
#endif

/*
 * Structure definition for an entry in a hash table.  No-one outside
 * Tcl should access any of these fields directly;  use the macros
 * defined below.
 */

typedef struct Tcl_HashEntry {
    struct Tcl_HashEntry *nextPtr;	/* Pointer to next entry in this
					 * hash bucket, or NULL for end of
					 * chain. */
    struct Tcl_HashTable *tablePtr;	/* Pointer to table containing entry. */
    struct Tcl_HashEntry **bucketPtr;	/* Pointer to bucket that points to
					 * first entry in this entry's chain:
					 * used for deleting the entry. */
    ClientData clientData;		/* Application stores something here
					 * with Tcl_SetHashValue. */
    union {				/* Key has one of these forms: */
	char *oneWordValue;		/* One-word value for key. */
	int words[1];			/* Multiple integer words for key.
					 * The actual size will be as large
					 * as necessary for this table's
					 * keys. */
	char string[4];			/* String for key.  The actual size
					 * will be as large as needed to hold
					 * the key. */
    } key;				/* MUST BE LAST FIELD IN RECORD!! */
} Tcl_HashEntry;

/*
 * Structure definition for a hash table.  Must be in tcl.h so clients
 * can allocate space for these structures, but clients should never
 * access any fields in this structure.
 */

#define TCL_SMALL_HASH_TABLE 4
typedef struct Tcl_HashTable {
    Tcl_HashEntry **buckets;		/* Pointer to bucket array.  Each
					 * element points to first entry in
					 * bucket's hash chain, or NULL. */
    Tcl_HashEntry *staticBuckets[TCL_SMALL_HASH_TABLE];
					/* Bucket array used for small tables
					 * (to avoid mallocs and frees). */
    int numBuckets;			/* Total number of buckets allocated
					 * at **bucketPtr. */
    int numEntries;			/* Total number of entries present
					 * in table. */
    int rebuildSize;			/* Enlarge table when numEntries gets
					 * to be this large. */
    int downShift;			/* Shift count used in hashing
					 * function.  Designed to use high-
					 * order bits of randomized keys. */
    int mask;				/* Mask value used in hashing
					 * function. */
    int keyType;			/* Type of keys used in this table. 
					 * It's either TCL_STRING_KEYS,
					 * TCL_ONE_WORD_KEYS, or an integer
					 * giving the number of ints in a
					 */
    Tcl_HashEntry *(FAR PASCAL *findProc) _ANSI_ARGS_((struct Tcl_HashTable *tablePtr,
	    char *key));
    Tcl_HashEntry *(FAR PASCAL *createProc) _ANSI_ARGS_((struct Tcl_HashTable *tablePtr,
	    char *key, int *newPtr));
} Tcl_HashTable;

/*
 * Structure definition for information used to keep track of searches
 * through hash tables:
 */

typedef struct Tcl_HashSearch {
    Tcl_HashTable *tablePtr;		/* Table being searched. */
    int nextIndex;			/* Index of next bucket to be
					 * enumerated after present one. */
    Tcl_HashEntry *nextEntryPtr;	/* Next entry to be enumerated in the
					 * the current bucket. */
} Tcl_HashSearch;

/*
 * Acceptable key types for hash tables:
 */

#define TCL_STRING_KEYS		0
#define TCL_ONE_WORD_KEYS	1

/*
 * Macros for clients to use to access fields of hash entries:
 */

#define Tcl_GetHashValue(h) ((h)->clientData)
#define Tcl_SetHashValue(h, value) ((h)->clientData = (ClientData) (value))
#define Tcl_GetHashKey(tablePtr, h) \
    ((char *) (((tablePtr)->keyType == TCL_ONE_WORD_KEYS) ? (h)->key.oneWordValue \
						: (h)->key.string))

/*
 * Macros to use for clients to use to invoke find and create procedures
 * for hash tables:
 */

#define Tcl_FindHashEntry(tablePtr, key) \
	(*((tablePtr)->findProc))(tablePtr, key)
#define Tcl_CreateHashEntry(tablePtr, key, newPtr) \
	(*((tablePtr)->createProc))(tablePtr, key, newPtr)

#if defined ( TB ) && ! defined ( _DOS )
#define printf TbPrintf
#define fprintf TbFprintf
#define sscanf TbSscanf
#define fgets(b, n, f) TbFgets(b, n, f)
#define fgetc(f) TbFgetc(f)
#define fputs(s, f) TbFputs(s, f)
#define fputc(c, f) TbFputc(c, f)
#define clearerr(f) TbClearerr(f)
#define fileno(f) TbFileno(f)
#define fflush(f) TbFflush(f)
#undef ferror
#undef feof
#define ferror(f) TbFerror(f)
#define feof(f) TbFeof(f)

EXTERN int	TbPrintf(const char *, ...);
EXTERN int	TbFprintf(FILE *, const char *, ...);
EXTERN int	TbSscanf(char *, const char *, ...);
EXTERN int	TbFputs(const char *, FILE *);
EXTERN char *	TbFgets(char *, int, FILE *);
EXTERN int	TbFputc(int, FILE *);
EXTERN void	TbClearerr(FILE *);
EXTERN int	TbFileno(FILE *);
EXTERN int	TbFerror(FILE *);
EXTERN int	TbFflush(FILE *);
EXTERN FILE *	TbFopen(const char *, const char *);
EXTERN int	TbFeof(FILE *);
#endif 

/*
 * Exported Tcl variables:
 */

EXTERN int		tcl_AsyncReady;
EXTERN char *		tcl_RcFileName;
#ifdef _WINDOWS
EXTERN int	FAR PASCAL EXPORT	Tcl_AsyncReady(void);
#endif

/*
 * Exported Tcl procedures:
 */

EXTERN void	FAR PASCAL EXPORT	Tcl_AsyncMark _ANSI_ARGS_((Tcl_AsyncHandler async));
EXTERN Tcl_AsyncHandler	FAR PASCAL EXPORT	Tcl_AsyncCreate _ANSI_ARGS_((Tcl_AsyncProc *proc,
			    ClientData clientData));
EXTERN void	FAR PASCAL EXPORT	Tcl_AsyncDelete _ANSI_ARGS_((Tcl_AsyncHandler async));
EXTERN int	FAR PASCAL EXPORT	Tcl_AsyncInvoke _ANSI_ARGS_((Tcl_Interp *interp,
			    int code));
EXTERN void	FAR PASCAL EXPORT	Tcl_AppendElement _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string));
EXTERN void	FAR CDECL EXPORT	Tcl_AppendResult _ANSI_ARGS_(VARARGS);
EXTERN int	FAR PASCAL EXPORT	Tcl_AppInit _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN void	FAR PASCAL EXPORT	Tcl_AddErrorInfo _ANSI_ARGS_((Tcl_Interp *interp,
			    char *message));
EXTERN char	FAR PASCAL EXPORT	Tcl_Backslash _ANSI_ARGS_((char *src,
			    int *readPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_CallWhenDeleted _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_InterpDeleteProc *proc,
			    ClientData clientData));
EXTERN int	FAR PASCAL EXPORT	Tcl_CommandComplete _ANSI_ARGS_((char *cmd));
EXTERN char *	FAR PASCAL EXPORT	Tcl_Concat _ANSI_ARGS_((int argc, char **argv));
EXTERN int	FAR PASCAL EXPORT	Tcl_ConvertElement _ANSI_ARGS_((char *src,
			    char *dst, int flags));
EXTERN void	FAR PASCAL EXPORT	Tcl_CreateCommand _ANSI_ARGS_((Tcl_Interp *interp,
			    char *cmdName, Tcl_CmdProc *proc,
			    ClientData clientData,
			    Tcl_CmdDeleteProc *deleteProc));
EXTERN Tcl_Interp *	FAR PASCAL EXPORT	Tcl_CreateInterp _ANSI_ARGS_((void));
EXTERN void	FAR PASCAL EXPORT	Tcl_CreateMathFunc _ANSI_ARGS_((Tcl_Interp *interp,
			    char *name, int numArgs, Tcl_ValueType *argTypes,
			    Tcl_MathProc *proc, ClientData clientData));
EXTERN int	FAR PASCAL EXPORT	Tcl_CreatePipeline _ANSI_ARGS_((Tcl_Interp *interp,
			    int argc, char **argv, int **pidArrayPtr,
			    int *inPipePtr, int *outPipePtr,
			    int *errFilePtr));
EXTERN Tcl_Trace	FAR PASCAL EXPORT	Tcl_CreateTrace _ANSI_ARGS_((Tcl_Interp *interp,
			    int level, Tcl_CmdTraceProc *proc,
			    ClientData clientData));
EXTERN void	FAR PASCAL EXPORT	Tcl_DeleteHashEntry _ANSI_ARGS_((
			    Tcl_HashEntry *entryPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DeleteHashTable _ANSI_ARGS_((
			    Tcl_HashTable *tablePtr));
EXTERN char *	FAR PASCAL EXPORT	Tcl_DStringAppend _ANSI_ARGS_((Tcl_DString *dsPtr,
			    char *string, int length));
EXTERN char *	FAR PASCAL EXPORT	Tcl_DStringAppendElement _ANSI_ARGS_((
			    Tcl_DString *dsPtr, char *string));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringEndSublist _ANSI_ARGS_((Tcl_DString *dsPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringFree _ANSI_ARGS_((Tcl_DString *dsPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringInit _ANSI_ARGS_((Tcl_DString *dsPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringResult _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_DString *dsPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringStartSublist _ANSI_ARGS_((
			    Tcl_DString *dsPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DStringTrunc _ANSI_ARGS_((Tcl_DString *dsPtr,
			    int length));
EXTERN int	FAR PASCAL EXPORT	Tcl_DeleteCommand _ANSI_ARGS_((Tcl_Interp *interp,
			    char *cmdName));
EXTERN void	FAR PASCAL EXPORT	Tcl_DeleteInterp _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN void	FAR PASCAL EXPORT	Tcl_DeleteTrace _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_Trace trace));
EXTERN void	FAR PASCAL EXPORT	Tcl_DetachPids _ANSI_ARGS_((int numPids, int *pidPtr));
EXTERN void	FAR PASCAL EXPORT	Tcl_DontCallWhenDeleted _ANSI_ARGS_((
			    Tcl_Interp *interp, Tcl_InterpDeleteProc *proc,
			    ClientData clientData));
EXTERN void	FAR PASCAL EXPORT	Tcl_EnterFile _ANSI_ARGS_((Tcl_Interp *interp,
			    FILE *file, int permissions));
EXTERN char *	FAR PASCAL EXPORT	Tcl_ErrnoId _ANSI_ARGS_((void));
EXTERN int	FAR PASCAL EXPORT	Tcl_Eval _ANSI_ARGS_((Tcl_Interp *interp, char *cmd));
EXTERN int	FAR PASCAL EXPORT	Tcl_EvalFile _ANSI_ARGS_((Tcl_Interp *interp,
			    char *fileName));
EXTERN int	FAR PASCAL EXPORT	Tcl_ExprBoolean _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int *ptr));
EXTERN int	FAR PASCAL EXPORT	Tcl_ExprDouble _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, double *ptr));
EXTERN int	FAR PASCAL EXPORT	Tcl_ExprLong _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, long *ptr));
EXTERN int	FAR PASCAL EXPORT	Tcl_ExprString _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string));
EXTERN int	FAR PASCAL EXPORT	Tcl_FilePermissions _ANSI_ARGS_((FILE *file));
EXTERN Tcl_HashEntry *	FAR PASCAL EXPORT	Tcl_FirstHashEntry _ANSI_ARGS_((
			    Tcl_HashTable *tablePtr,
			    Tcl_HashSearch *searchPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetBoolean _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int *boolPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetCommandInfo _ANSI_ARGS_((Tcl_Interp *interp,
			    char *cmdName, Tcl_CmdInfo *infoPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetDouble _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, double *doublePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetInt _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int *intPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetOpenFile _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int write, int checkUsage,
			    FILE **filePtr));
EXTERN char *	FAR PASCAL EXPORT	Tcl_GetVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, int flags));
EXTERN char *	FAR PASCAL EXPORT	Tcl_GetVar2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, int flags));
EXTERN int	FAR PASCAL EXPORT	Tcl_GlobalEval _ANSI_ARGS_((Tcl_Interp *interp,
			    char *command));
EXTERN char *	FAR PASCAL EXPORT	Tcl_HashStats _ANSI_ARGS_((Tcl_HashTable *tablePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN void	FAR PASCAL EXPORT	Tcl_InitHashTable _ANSI_ARGS_((Tcl_HashTable *tablePtr,
			    int keyType));
EXTERN void	FAR PASCAL EXPORT	Tcl_InitMemory _ANSI_ARGS_((Tcl_Interp *interp));
#ifdef KANJI
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiFile _ANSI_ARGS_((Tcl_Interp *interp,
			    char *fileName, int *kanjiCodePtr));
#endif /* KANJI */
EXTERN int	FAR PASCAL EXPORT	Tcl_LinkVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, char *addr, int type));
EXTERN char *	FAR PASCAL EXPORT	Tcl_Merge _ANSI_ARGS_((int argc, char **argv));
EXTERN Tcl_HashEntry *	FAR PASCAL EXPORT	Tcl_NextHashEntry _ANSI_ARGS_((
			    Tcl_HashSearch *searchPtr));
EXTERN char *	FAR PASCAL EXPORT	Tcl_ParseVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, char **termPtr));
EXTERN char *	FAR PASCAL EXPORT	Tcl_PosixError _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN void	FAR PASCAL EXPORT	Tcl_PrintDouble _ANSI_ARGS_((Tcl_Interp *interp,
			    double value, char *dst));
EXTERN void	FAR PASCAL EXPORT	Tcl_ReapDetachedProcs _ANSI_ARGS_((void));
EXTERN int	FAR PASCAL EXPORT	Tcl_RecordAndEval _ANSI_ARGS_((Tcl_Interp *interp,
			    char *cmd, int flags));
EXTERN int	FAR PASCAL EXPORT	Tcl_RegExpMatch _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, char *pattern));
EXTERN void	FAR PASCAL EXPORT	Tcl_ResetResult _ANSI_ARGS_((Tcl_Interp *interp));
#define Tcl_Return Tcl_SetResult
EXTERN int	FAR PASCAL EXPORT	Tcl_ScanElement _ANSI_ARGS_((char *string,
			    int *flagPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_SetCommandInfo _ANSI_ARGS_((Tcl_Interp *interp,
			    char *cmdName, Tcl_CmdInfo *infoPtr));
EXTERN void	FAR CDECL EXPORT	Tcl_SetErrorCode _ANSI_ARGS_(VARARGS);
EXTERN int	FAR PASCAL EXPORT	Tcl_SetRecursionLimit _ANSI_ARGS_((Tcl_Interp *interp,
			    int depth));
EXTERN void	FAR PASCAL EXPORT	Tcl_SetResult _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, Tcl_FreeProc *freeProc));
EXTERN char *	FAR PASCAL EXPORT	Tcl_SetVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, char *newValue, int flags));
EXTERN char *	FAR PASCAL EXPORT	Tcl_SetVar2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, char *newValue,
			    int flags));
EXTERN char *	FAR PASCAL EXPORT	Tcl_SignalId _ANSI_ARGS_((int sig));
EXTERN char *	FAR PASCAL EXPORT	Tcl_SignalMsg _ANSI_ARGS_((int sig));
EXTERN int	FAR PASCAL EXPORT	Tcl_SplitList _ANSI_ARGS_((Tcl_Interp *interp,
			    char *list, int *argcPtr, char ***argvPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_StringMatch _ANSI_ARGS_((char *string,
			    char *pattern));
EXTERN char *	FAR PASCAL EXPORT	Tcl_TildeSubst _ANSI_ARGS_((Tcl_Interp *interp,
			    char *name, Tcl_DString *bufferPtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_TraceVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, int flags, Tcl_VarTraceProc *proc,
			    ClientData clientData));
EXTERN int	FAR PASCAL EXPORT	Tcl_TraceVar2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, int flags,
			    Tcl_VarTraceProc *proc, ClientData clientData));
EXTERN void	FAR PASCAL EXPORT	Tcl_UnlinkVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName));
EXTERN int	FAR PASCAL EXPORT	Tcl_UnsetVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, int flags));
EXTERN int	FAR PASCAL EXPORT	Tcl_UnsetVar2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, int flags));
EXTERN void	FAR PASCAL EXPORT	Tcl_UntraceVar _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, int flags, Tcl_VarTraceProc *proc,
			    ClientData clientData));
EXTERN void	FAR PASCAL EXPORT	Tcl_UntraceVar2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, int flags,
			    Tcl_VarTraceProc *proc, ClientData clientData));			    
EXTERN int	FAR CDECL EXPORT	Tcl_VarEval _ANSI_ARGS_(VARARGS);
EXTERN ClientData	FAR PASCAL EXPORT	Tcl_VarTraceInfo _ANSI_ARGS_((Tcl_Interp *interp,
			    char *varName, int flags,
			    Tcl_VarTraceProc *procPtr,
			    ClientData prevClientData));
EXTERN ClientData	FAR PASCAL EXPORT	Tcl_VarTraceInfo2 _ANSI_ARGS_((Tcl_Interp *interp,
			    char *part1, char *part2, int flags,
			    Tcl_VarTraceProc *procPtr,
			    ClientData prevClientData));
#ifdef KANJI
EXTERN int	FAR PASCAL EXPORT	Tcl_EncodeJIS _ANSI_ARGS_((unsigned char *ks, wchar *ws));
EXTERN int	FAR PASCAL EXPORT	Tcl_EncodeSJIS _ANSI_ARGS_((unsigned char *ks, wchar *ws));
EXTERN int	FAR PASCAL EXPORT	Tcl_EncodeEUC _ANSI_ARGS_((unsigned char *ks, wchar *ws));
EXTERN int	FAR PASCAL EXPORT	Tcl_EncodeANY _ANSI_ARGS_((unsigned char *ks, wchar *ws));
EXTERN int	FAR PASCAL EXPORT	Tcl_DecodeJIS _ANSI_ARGS_((wchar *ws, unsigned char *ks));
EXTERN int	FAR PASCAL EXPORT	Tcl_DecodeSJIS _ANSI_ARGS_((wchar *ws, unsigned char *ks));
EXTERN int	FAR PASCAL EXPORT	Tcl_DecodeEUC _ANSI_ARGS_((wchar *ws, unsigned char *ks));
EXTERN int	FAR PASCAL EXPORT	Tcl_DecodeANY _ANSI_ARGS_((wchar *ws, unsigned char *ks));
EXTERN int	FAR PASCAL EXPORT	Tcl_DefaultKanjiCode _ANSI_ARGS_((void));
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiCode _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiStart _ANSI_ARGS_((
			    unsigned char *string, int *kanjiCodePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiEnd _ANSI_ARGS_((
			    unsigned char *string, int *kanjiCodePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiLength _ANSI_ARGS_((
			    unsigned char *string, int kanjiCode));
EXTERN int	FAR PASCAL EXPORT	Tcl_KanjiString _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int *kanjiCodePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_GetKanjiCode _ANSI_ARGS_((Tcl_Interp *interp,
			    char *string, int *kanjiCodePtr));
EXTERN int	FAR PASCAL EXPORT	Tcl_WStrlen _ANSI_ARGS_((wchar *wstr));
EXTERN wchar *	FAR PASCAL EXPORT	Tcl_WStrcpy _ANSI_ARGS_((wchar *wstr1, wchar *wstr2));
EXTERN wchar *	FAR PASCAL EXPORT	Tcl_WStrncpy _ANSI_ARGS_((wchar *wstr1, wchar *wstr2, int n));
EXTERN int	FAR PASCAL EXPORT	Tcl_WStrcmp _ANSI_ARGS_((wchar *wstr1, wchar *wstr2));
EXTERN int	FAR PASCAL EXPORT	Tcl_WStrncmp _ANSI_ARGS_((wchar *wstr1, wchar *wstr2, int n));
EXTERN int	FAR PASCAL EXPORT	Tcl_WStringMatch _ANSI_ARGS_((wchar *string,
			    wchar *pattern));
#endif /* KANJI */

#endif /* _TCL */
