/*
 * util.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef _X_LIB_H_
#include <X11/Xlib.h>
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif

/* adjust.c */
EXTERN void 	NEAR PASCAL 	InitAdjustment(void);
EXTERN int 	NEAR PASCAL 	AdjustWidth(int, int);
EXTERN int 	NEAR PASCAL 	AdjustHeight(int, int);
EXTERN int	NEAR PASCAL	ReAdjustWidth(int, int);
EXTERN int	NEAR PASCAL	ReAdjustHeight(int, int);
EXTERN int	NEAR PASCAL 	AdjustX(int, int);
EXTERN int	NEAR PASCAL 	AdjustY(int, int);
EXTERN int	NEAR PASCAL	ReAdjustX(int, int);
EXTERN int	NEAR PASCAL	ReAdjustY(int, int);

/* callback.c */
EXTERN	BOOL 	CALLBACK __export	SendActivate(HWND, LPARAM);
EXTERN	BOOL 	CALLBACK __export	PostPaint(HWND, LPARAM);
EXTERN	BOOL 	CALLBACK __export	DeleteProperty(HWND, LPCSTR, HANDLE);
EXTERN	LRESULT CALLBACK __export	DeliverEnterLeave(int, WPARAM, LPARAM);
EXTERN	void	FAR PASCAL __export	SetHookDeliverEL(HHOOK);

/* cursor.c */
EXTERN void 	NEAR PASCAL	SetDefaultCursor(HCURSOR);
EXTERN HCURSOR 	NEAR PASCAL	GetDefaultCursor(void);
EXTERN HCURSOR 	NEAR PASCAL	FindCursor(HWND);

/* event.c  */
EXTERN XEvent *		NEAR PASCAL	peekEvent(_XQEvent *, XEvent *);
EXTERN _XQEvent *	NEAR PASCAL	discardEvent(_XQEvent *);
EXTERN _XQEvent *	NEAR PASCAL	putEvent(XEvent *, _XQEvent *);

/* instance.c */
EXTERN void		__far __pascal __export	SetAppInstance(HINSTANCE);
EXTERN HINSTANCE	__far __pascal __export	GetAppInstance(void);
EXTERN void		__far __pascal __export	SetTbWindow(HWND);
EXTERN HWND		__far __pascal __export	GetTbWindow(void);
EXTERN void		__far __pascal __export DestroyTerm(void);


/* window.c */
EXTERN unsigned char	NEAR PASCAL	_SetWindowChanges(HWND, unsigned long, XWindowChanges *);
EXTERN unsigned char	NEAR PASCAL	_SetWindowAttributes(HWND, unsigned long, XSetWindowAttributes *);

/* xseterrh.c */
EXTERN void	NEAR PASCAL	postError(unsigned char, unsigned int);

EXTERN void	__far __pascal __export	wputs(const char *, HWND);
EXTERN WPARAM __far __pascal __export main(int, char **);

EXTERN int	msg3event(Display *, MSG *, XEvent *);

EXTERN void	NEAR PASCAL	SetClearProps(HINSTANCE);

