###########################################################
###########################################################
##          E-Mail Library Ver 2.1 by Catalin MC         ##
##       EMail    : catalin@xantipa.comp-craiova.ro      ##
##        HomePage : http://free.xtel.com/~catalin       ##
###########################################################
###########################################################

global phost pport puser ppass psocketlist puserlist phostlist p_error
global smtp_socket_list smtp_addr_list suser shost smtpaddr smtpsender
global base64_en base64 pform

set hostname $env(HOSTNAME)
set username $env(LOGNAME)
set pform $tcl_platform(platform)
set smtpsender "$username@$hostname"

set p_error {}
set psocketlist {}
set puserlist {}
set phostlist {}
set smtp_socket_list {}
set smtp_addr_list {}
set smtpaddr {}

proc p_addto_list { psock } {
global psocketlist puserlist phostlist puser phost

  set psocketlist "$psocketlist $psock"
  set puserlist "$puserlist $puser"
  set phostlist "$phostlist $phost"

}

proc p_delfrom_list { psock } {
global psocketlist puserlist phostlist puser phost
  
  set ps {}
  set pu {}
  set ph {}
  set l [llength $psocketlist]
  for {set i 0} {$i < [ expr $l ]} {incr i} {  
    set k1 [lindex $psocketlist $i]
    set k2 [lindex $puserlist $i]
    set k3 [lindex $phostlist $i]
    if { $k1 != $psock } {
      set ps "$ps $k1"
      set pu "$pu $k2"
      set ph "$ph $k3";
    }
  }
 set psocketlist $ps
 set puserlist $pu
 set phostlist $ph
}

proc p_test_connect { psock } {
global psocketlist
  set l [llength $psocketlist]
  for {set i 0} {$i < [ expr $l ]} {incr i} {  
    set k1 [lindex $psocketlist $i]
    if { $k1 == $psock } {
      return 0;
    }
  }
  return -1;
}

proc p_write { s mes } {
  puts $s "$mes"
  flush $s
}

proc p_read { s } {
  set t [gets $s k]
  if { $k == "" && $t == -1} {

      return -1;
  }
  return $k;
}

proc p_connect {  } {
global phost pport p_error
   set err [catch [set sock [ socket $phost $pport ]]]
  if { $err } {
   set p_error "Cannot open socket to $phost ..."
   return -3;
  } 
  set r [ p_read $sock ] 
  if {$r == -1} {
    set p_error "$sock closed by remote server ..."
    p_delfrom_list $psock
    return -2;
  }
  set k [lindex $r 0]
  if {$k == "+OK"} {
        p_addto_list $sock
	return $sock ;
  } else {
	set p_error $r
	return -1;
    }
}

proc p_disconnect { psock } {
global p_error


  set k [p_test_connect $psock]
  if { $k == -1} {
     set p_error "$psock not open ..."
     return -1; 
  }
  p_write $psock "QUIT"
  set r [ p_read $psock ] 
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."    
    p_delfrom_list $psock
    return -2;
  }
  set k [p_test_connect $psock]
  if { $k != -1} {
    close $psock;
  }
  p_delfrom_list $psock
  return 0
}

proc p_logged_in { psock } {
global puser ppass p_error

  set k [ p_test_connect $psock ]
  if {$k == -1} {
    set p_error "$psock not open ..."
    return -3;
  }

  p_write $psock "USER $puser"
  set r [ p_read $psock ]
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."
    p_delfrom_list $psock
    return -4;
  }
  set k [string first "-ERR" $r]
  if {$k == 0} { 
    close $psock
    set p_error $r
    return -2;
  }

  p_write $psock "PASS $ppass"
  set r [ p_read $psock ]
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."
    p_delfrom_list $psock
    return -4;
  }
  set k [string first "-ERR" $r]
  if {$k == 0} {
	    close $psock
	    set p_error $r
	    return -1;
  }
return 0;
}

proc p_delete_email { psock i } {
global p_error	
  set k [ p_test_connect $psock ] 
  if {$k == -1} {
    set p_error "$psock not open ..."
    return -2;
  }

  p_write $psock "DELE $i"
  set r [ p_read $psock ]
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."
    p_delfrom_list $psock
    return -3;
  }
  set k [lindex $r 0]
  if {$k == "+OK" } {
    return 0;
  } else {
    set p_error $r
    return -1;
      }
}

proc p_get_email { psock i f } {
global p_error
  set k [ p_test_connect $psock ]
  if {$k == -1} {
    set p_error "$psock not open ..."
    return -2;
  }

  set fid [open $f "w"]
  p_write $psock "RETR $i"
  set r [p_read $psock]
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."
    p_delfrom_list $psock
    return -3;
  }
  set k [string first "-ERR" $r]
  if { $k == 0 } {
    set p_error $r
    close $fid
    return -1;
  }
  while {$r != "."} {
    set r [p_read $psock]
    if {$r == -1} {
      set p_error "$psock closed by remote server ..."
      p_delfrom_list $psock
      return -3;
    }
    puts $fid $r
    set k [string first "-ERR" $r]
    if { $k == 0 } {
      set p_error $r
      close $fid
      return -1;
    }
  }
  close $fid
  return 0;
}

proc p_get_header { psock i f} {
global p_error
  set k [ p_test_connect $psock ]
  if {$k == -1} {
    set p_error "$psock not open ..."
    return -2;
  }

  set fid [open $f "w"]
  p_write $psock "TOP $i 1"
  set r [p_read $psock]
  if {$r == -1} {
    set p_error "$psock closed by remote server ...
    p_delfrom_list $psock
    return -3;
  }
  set k [string first "-ERR" $r]
  if { $k == 0 } {
    set p_error $r
    close $fid
    return -1;
  }
  while {$r != "."} {
    set r [p_read $psock] 
    if {$r == -1} {
      set p_error "$psock closed by remote server ..."
      p_delfrom_list $psock
      return -3;
    }
    puts $fid $r
    set k [string first "-ERR" $r]
    if { $k == 0 } {
      set p_error $r
      close $fid
      return -1;
    }
  }
  puts $fid "."
  close $fid
  return 0;
}

proc p_get_email_info { psock } {
global p_error
  set k [ p_test_connect $psock ]
  if {$k == -1} {
    set p_error "$psock not open ..."
    return -2;
  }

  p_write $psock "LIST"
  set r [p_read $psock]
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."
    p_delfrom_list $psock
    return -3;
  }
  set k [string first "-ERR" $r]
  if { $k == 0 } {
    set p_error $r
    return -1;
  }
  set x {}
  set nr -1
  while {$r != "."} {
    set r [p_read $psock] 
    if {$r == -1} {
      set p_error "$psock closed by remote server ..."
      p_delfrom_list $psock
      return -3;
    }
    set k [string first "-ERR" $r]
    if { $k == 0 } {
      set p_error $r
      return -1;
    }
    incr nr
    set x "$x $r"
  }
  set y [llength $x]
  set z {}
  set sum 0
  set c {}
  for {set i 1} {$i < [expr $y]} { incr i 2 } {
    set z [lindex $x $i]
    incr sum $z
    set c "$c $z"
  }
  set c "$nr $sum$c"
  return $c;
}

proc p_get_header_info { f } {
global p_error
  
  if {[file exists $f] != 1} {
    set p_error "File $f not found ..."
    return -1;
  }
  
  set sender {}
  set from {}
  set subj {}
  set date {}
  set fid [ open $f r ]
  set s [read $fid]
  set s [split $s "\n"]
  set i 0
  set l 0
  while { $i == 0 } {
    set line [lindex $s $l]
    incr l
    set k [string first "Sender:" $line]
    if {$k == 0} {
      set sender $line;
    }
    set k [string first "From:" $line]
    if {$k == 0} {
      set from $line;
    }
    set k [string first "Subject:" $line]
    if {$k == 0} {
      set subj $line;
    }
    set k [string first "Date:" $line]
    if {$k == 0} {
      set date $line;
    }
    set k [string first "X-Status:" $line]
    if {$k == 0} {
      set i 1;
    }
  }
  return "$date\n$from\n$subj\n$sender"
}


proc p_configure { user pass host port } {
global phost pport puser ppass
  set phost $host
  set pport $port
  set puser $user
  set ppass $pass
}

proc smtp_addto_list { psock } {
global smtp_socket_list smtp_addr_list smtpaddr

  set smtp_socket_list "$smtp_socket_list $psock"
  set smtp_addr_list "$smtp_addr_list $smtpaddr"

}

proc smtp_delfrom_list { psock } {
global smtp_socket_list smtp_addr_list smtpaddr
  
  set sl {}
  set sa {}
  set l [llength $smtp_socket_list]
  for {set i 0} {$i < [ expr $l ]} {incr i} {  
    set k1 [lindex $smtp_socket_list $i]
    set k2 [lindex $smtp_addr_list $i]
    if { $k1 != $psock } {
      set sl "$sl $k1"
      set sa "$sa $k2"
    }
  }
 set smtp_socket_list $sl
 set smtp_addr_list $sa
}

proc smtp_test_connect { psock } {
global smtp_socket_list
  set l [llength $smtp_socket_list]
  for {set i 0} {$i < [ expr $l ]} {incr i} {  
    set k1 [lindex $smtp_socket_list $i]
    if { $k1 == $psock } {
      return 0;
    }
  }
  return -1;
}

proc smtp_connect { } {
global p_error shost

  set err [catch [set sock [ socket $shost 25 ]]]
  if { $err } {
   set p_error "Cannot open socket to $shost ..."
   return -3;
  } 
  set r [ p_read $sock ] 
  if {$r == -1} {
    set p_error "$sock closed by remote server ..."
    smtp_delfrom_list $sock
    return -2;
  }

  set k [lindex $r 0]
  if {$k == 220} {
        smtp_addto_list $sock
	return $sock ;
  } else {
	set p_error $r
	return -1;
    }
}

proc smtp_disconnect { psock } {
global p_error

  set k [smtp_test_connect $psock]
  if { $k == -1} {
     set p_error "$psock not open ..."
     return -1; 
  }
  p_write $psock "QUIT"
  set r [ p_read $psock ] 
  if {$r == -1} {
    set p_error "$psock closed by remote server ..."    
    smtp_delfrom_list $psock
    return -2;
  }
  set k [smtp_test_connect $psock]
  if { $k != -1} {
    close $psock;
  }
  smtp_delfrom_list $psock
  return 0
}


proc smtp_send_email { ssock f } {
global p_error global suser smtpsender

  set fid [open $f r]
  set stxt [read $fid]
  close $fid
  
  p_write $ssock "MAIL FROM: $smtpsender"
  p_write $ssock "RCPT TO: $suser"
  p_write $ssock "DATA"
  p_write $ssock $stxt 
  p_write $ssock "." 

  return 0;
}

proc smtp_configure { addr } {
global shost suser

  set smtpaddr $addr

  set addr [split $addr "@"]
   
  set shost [lindex $addr 1]
  set suser [lindex $addr 0]
}



proc base64_encode { infile outfile } {
  set f [open $infile r]
  set k [read $f]
  close $f
  set k [ encode64 $k ]
  set f [open $outfile w]
  puts $f $k
  close $f
}

proc base64_decode { infile outfile } {
  set f [open $infile r]
  set k [read $f]
  close $f
  set k [ decode64 $k ]
  set f [open $outfile w]
  puts $f $k
  close $f
}


proc cnf_base64 { } {
global base64_en base64
set i 0
 foreach char {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
	      a b c d e f g h i j k l m n o p q r s t u v w x y z \
	      0 1 2 3 4 5 6 7 8 9 + /} {
    set base64($char) $i
    set base64_en($i) $char
    incr i
 }
}

proc encode64 {string} {
    global base64_en
    set result {}
    set state 0
    set length 0
    cnf_base64
    foreach {c} [split $string {}] {
	scan $c %c x
	switch [incr state] {
	    1 {	append result $base64_en([expr {($x >>2) & 0x3F}]) }
	    2 { append result $base64_en([expr {(($old << 4) & 0x30) | (($x >> 4) & 0xF)}]) }
	    3 { append result $base64_en([expr {(($old << 2) & 0x3C) | (($x >> 6) & 0x3)}])
		append result $base64_en([expr {($x & 0x3F)}])
		set state 0}
	}
	set old $x
	incr length
	if {$length >= 72} {
	    append result \n
	    set length 0
	}
    }
    set x 0
    switch $state {
	0 { # OK }
	1 { append result $base64_en([expr {(($old << 4) & 0x30)}])== }
	2 { append result $base64_en([expr {(($old << 2) & 0x3C)}])=               }
    }
    return $result
}

proc decode64 {string} {
    global base64

    set output {}
    set group 0
    set j 18
    cnf_base64
    foreach char [split $string {}] {
       if {$char != "\n"} {
	if [string compare $char "="] {
	    set bits $base64($char)
	    set group [expr {$group | ($bits << $j)}]
	}
	if {[incr j -6] < 0} {
		scan [format %06x $group]] %2x%2x%2x a b c
                set t [format %c%c%c $a $b $c]
		append output $t
		set group 0
		set j 18
	}
      }
    }
    return $output
}

proc fixdosname { file } {
	regsub -nocase {^[a-z]:} $file {} file
	regsub -all {/} $file {\\} $file
	return $file
}

proc uuencode { infile name outfile } {
	global pform env

	if {$pform=="unix"} {
		exec uuencode $infile $name > $outfile
	} elseif {$pform=="windows"} {
		set infile [fixdosname $infile]
		set outfile [fixdosname $outfile]
		exec $env(COMSPEC) /c uuencode $infile $name > $outfile
	} else {
		set p_error "ERROR - uuencode not supported under $pform"
		return -1
	}
	return 0
}

proc uudecode { infile } {
	global env  pform

	if {$pform=="unix"} {
		exec uudecode $infile
	} elseif {$pform=="windows"} {
		set infile [fixdosname $infile]
		set outfile [fixdosname $outfile]
		exec $env(COMSPEC) /c uudnt $infile
	} else {
		set p_error "ERROR - uudecode not supported under $pform"
		return -1
	}
	return 0
}

