# load the MetaKit extension in Tcl
#load ../mk4tcl.dll
load ./mk4tcl.so
#package require mk
	# this defines several commands in namespace "mk"

# open a datafile called "test.dat", call it "try" in this script
mk::file open try test.dat
	# the file is opened read/write
	# it will be created if necessary

# define the structure of a view called "names"
mk::view layout try.names {first last age:I {info {code:I text}}}
	# the structure contains the following properties:
	#		first	- a string
	#		last	- a string
	#		age		- an integer
	#		info	- a subview of the "names" view
	#		code	- an integer in the subview
	#		text	- a string in the subview
	# the structure on file is adjusted if it was different
	# in that case, structural changes will be saved on commit

# define a synonym for this view in the file
set v try.names
	# synonyms can be more complex for nested views
	# for example, the 3rd info table would be "try.names!2.info"

# see how many rows it contains
puts "the size of $v is: [mk::view size $v]"

# resize the view to contain exactly 123 rows
mk::view size $v 123
puts "the size of $v is: [mk::view size $v]"

# set some values in the row at index 5 (zero based)
mk::set $v!5 first abc last xyz age:I 99
	# this sets first to "abc", last to "xyz", and age to 99
	# the remaining properties are not affected

# create an cursor pointing row 5
set r $v!5

# get a value back from the view
puts "last is: [mk::get $r last]"

# get a list of values
puts "contents of '$r' is: [mk::get $r first last age:I]"

# set new age values in several rows
for {set x 10} {$x <= 100} {incr x} {mk::set $v!$x age:I [expr $x*$x]}
	# this stores 10*10 in row 10, 11*11 in row 11, and so on...

# copy row 12 to row 15
mk::row replace $v!15 $v!12

# insert 3 copies of row 15 at position 18 of the same view
mk::row insert $v!18 3 $v!15

# remove row 60..69
mk::row delete $v!60 10

# create a buffer with data (not part of the datafile)
mk::set [mk::cursor n] name "John Doe" age:I 21
	# this also a new synonym in variable "n"
	# note that "name" is a new property

# lets see what identifier this temporary row has
puts "new cursor = $n"

# lets get the name and age properties
puts "get cursor = [mk::get $n name age:I]"

# change cursor "r" to point to row 23 instead of 5
mk::cursor position r 23
puts "set cursor = $r at [mk::cursor position r]"

# advance the cursor by one (even if it there is no such row)
mk::cursor incr r
puts "rel cursor = $r at [mk::cursor position r]"

# move the cursor to point to the last row in the view
mk::cursor position r end
puts "end cursor = $r at [mk::cursor position r]"

# store some info in the last row
mk::set $r first one last two age:I 3 name you
puts "row $r values: [mk::get $r]"
puts "  properties: [mk::view info $r]"
	# note that the name was remembered, though it is not on file

# dump the current state of our data to a backup file
mk::file save try test.bak

# clear the last row on file
mk::row replace $r
puts "clear [mk::get $r]"
	# should return empty strings and zero

# now restore the entire data from our saved snapshot
mk::file load try test.bak

# display the end row, which should contain data again
puts "row $r values: [mk::get $r]"
puts "  properties: [mk::view info $r]"
	# the name is gone, since it was not a persistent property

# loop over a few rows
mk::loop i $v 12 30 5 {puts "row $r [mk::get $i]"}

puts "Done."
