//	Copyright (C) 1998 Equi4 Software.  All rights reserved.
//
//	This is utility code to simplify turning MetaKit into an extension.
//
//	NOTE: this is prerelease software, it's neither well-behaved nor robust!
///////////////////////////////////////////////////////////////////////////////

#include "m4kit.h"
#include "scripted.h"

#include <stdlib.h>

///////////////////////////////////////////////////////////////////////////////

	class MkPath;
	class MkWorkspace;

///////////////////////////////////////////////////////////////////////////////
//	Utility code: return next token up to char < '0', and
//	advance the string pointer past following character.

c4_String f4_GetToken(const char*& str_)
{
	// assert(str_ && *str_ >= '0');

	const char* p = str_;
	while (*p >= '0')
		++p;

	c4_String result (str_, p - str_);

	if (*p)
		++p;
	str_ = p;

	return result;
}

///////////////////////////////////////////////////////////////////////////////

MkPath::MkPath (MkWorkspace& ws_, const char*& path_)
	: _refs (1), _ws (ws_), _path (path_)
{
		// if this view is not part of any storage, make a new temporary row
	if (_path.IsEmpty())
	{
		_path = _ws.AllocTempRow();

		AttachView();
	}
	else
	{
		int n = AttachView();
		path_ += n;		// move past all processed characters

			// but trim white space and unprocessed tail from stored path
		while (n > 0 && _path[n-1] < '0')
			--n;
		if (n < _path.GetLength())
			_path = _path.Left(n);
	}
}

MkPath::~MkPath ()
{
	_ws.ForgetPath(this);
}

int MkPath::AttachView()
{
	const char* base = _path;
	const char* p = base;

		//	The format of a path description is:
		//
		//		storage '.' viewname [ '!' row# '.' viewprop ]*
		//	or
		//		storage '.' viewname [ '!' row# '.' viewprop ]* '!' row#
		//
		//	In the second case, the trailing row# is ignored.

	int row = _ws.Find(f4_GetToken(p));
	if (row >= 0 && *p)
	{
		_view = _ws.Nth(row)->_storage.View(f4_GetToken(p));

		while (*p)
		{
			const char* q = p;

			row = atoi(f4_GetToken(p));

			if (!*p)
				return q - base; // return partial number of chars processed

				//	A future version could parse derived view expressions here.
				//	Perhaps this could be done as MetaKit property expressions.

			c4_ViewProp prop (f4_GetToken(p));
			_view = prop (_view[row]);
		}
	}
	else
		_view = c4_View ();

	return p - base; // return pointer to ending null byte
}

int MkPath::Refs(int diff_)
{
	// assert(-1 <= diff_ && diff_ <= +1);

	_refs += diff_;

	// assert(_refs >= 0);

	if (_refs == 0 && diff_ < 0)
	{
		delete this;
		return 0;
	}

	return _refs;
}

///////////////////////////////////////////////////////////////////////////////

MkWorkspace::Item::Item ()
{
	_storage.GetAs("_[_[_:I]]").SetSize(100); //##// must allocate as needed
}

MkWorkspace::Item::Item (const char* name_, const char* fileName_, bool rw_)
	: _storage (fileName_, rw_), _name (name_)
{
}

MkWorkspace::Item::~Item ()
{
//	_paths->Refs(-1);
}

MkWorkspace::MkWorkspace ()
{
	_items.Add(new Item ());
}

MkWorkspace::~MkWorkspace ()
{
	for (int i = 0; i < _items.GetSize(); ++i)
	{
		Item* ip = Nth(i);
		if (ip)
			delete ip;
	}
}

int MkWorkspace::Open(const char* name_, const char* fileName_, bool rw_)
{
	int n = Find(name_);

	if (n < 0)
	{
		while (++n < _items.GetSize())
			if (Nth(n) == 0)
				break;

		if (n >= _items.GetSize())
			_items.SetSize(n + 1);

		_items.SetAt(n, new Item (name_, fileName_, rw_));
	}

	return n;
}

bool MkWorkspace::Close(int index_)
{
	Item* ip = Nth(index_);

	if (!ip)
		return false;

	delete ip;
	_items.SetAt(index_, 0);
	return true;
}

int MkWorkspace::Find(const char* name_) const
{
	for (int i = 0; i < _items.GetSize(); ++i)
	{
		Item* ip = Nth(i);
		if (ip && ip->_name == name_)
			return i;
	}

	return -1;
}

MkWorkspace::Item* MkWorkspace::Nth(int index_) const
{
	return (Item*) _items.GetAt(index_);
}

MkPath* MkWorkspace::AddPath(const char*& name_)
{
	const char* p = name_;

	int n = Find(f4_GetToken(p));
	if (n < 0)
	{
		n = 0;
		name_ = p - 1;	// skip the storage name, but leave the leading dot
	}

	Item* ip = Nth(n);
	// assert(ip != 0);

	for (int i = 0; i < ip->_paths.GetSize(); ++i)
	{
		MkPath* path = (MkPath*) ip->_paths.GetAt(i);
		// assert(path != 0);

		if (path->_path.CompareNoCase(name_) == 0)
		{
			path->Refs(+1);
			return path;
		}
	}

	MkPath* newPath = new MkPath (*this, name_);
	ip->_paths.Add(newPath);

	return newPath;
}

c4_String MkWorkspace::AllocTempRow()
{
	int i;
	
		// find an unused row
	for (i = 0; i < _usedRows.GetLength(); ++i)
		if (*(const char*) _usedRows.GetData(i) == 0)
			break;

		// flag it as being in use
	_usedRows.Grow(i + 1);
	*(char*) _usedRows.GetData(i) = 1;

		// temporary rows have special names
	char buf[20];
	sprintf(buf, "._!%d._", i);

	return buf;
}

void MkWorkspace::ForgetPath(const MkPath* path_)
{
	const char* p = path_->_path;

	int i = Find(f4_GetToken(p));
	if (i >= 0)
	{
		Item* ip = Nth(i);
		// assert(ip != 0);

		for (int j = 0; j < ip->_paths.GetSize(); ++j)
			if ((MkPath*) ip->_paths.GetAt(j) == path_)
			{
				ip->_paths.RemoveAt(j);
				break;
			}

			// last ref to a temporary row determines when to release it
		if (i == 0)
		{
			int n = atoi(path_->_path);
			// assert(*(const char*) _usedRows.GetData(n));
			*(char*) _usedRows.GetData(n) = 0;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
