//	Copyright (C) 1998 Equi4 Software.  All rights reserved.
//
//	This is utility code to simplify turning MetaKit into an extension.
//
//	NOTE: this is prerelease software, it's neither well-behaved nor robust!
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

	class MkPath;
	class MkWorkspace;

	extern c4_String f4_GetToken(const char*& str_);

///////////////////////////////////////////////////////////////////////////////
// A path is a view which knows what storage object it belongs to, if any.

class MkPath
{
	int _refs;					// reference count
	MkWorkspace& _ws;			// avoid globals, but there is usually just one

	int AttachView();

public:
	MkPath (MkWorkspace& ws_, const char*& path_);
	~MkPath (); 				// no explicit destruction, use Refs(-1)

	int Refs(int diff_);

	c4_View _view;				// the view corresponding to this path
	c4_String _path; 			// describes view, starting with storage name
};

///////////////////////////////////////////////////////////////////////////////
// A workspace manages a number of storage objects and their associated paths.

class MkWorkspace
{
	c4_PtrArray _items;			// items, or null if released
	c4_BaseArray _usedRows;		// 1 if that row in item 0 is currently in use

public:
	struct Item
	{
		const c4_String _name;	// the alias for this storage
		c4_Storage _storage;	// the storage object
		c4_PtrArray _paths;		// the paths associated with this entry

		Item ();				// special first entry initializer
		Item (const char* name_, const char* fileName_, bool rw_);
		~Item ();
	};

	MkWorkspace ();
	~MkWorkspace ();

	int Open(const char* name_, const char* fileName_, bool rw_);
	bool Close(int index_);

	int Find(const char* name_) const;
	Item* Nth(int index_) const;

	MkPath* AddPath(const char*& name_);
	void ForgetPath(const MkPath* path_);
	c4_String AllocTempRow();
};

///////////////////////////////////////////////////////////////////////////////
