# Hunt the Wumpus in TCL

# Initial cave

set cave(1)  {2 3 4}
set cave(2)  {1 3 5}
set cave(3)  {1 2 6}
set cave(4)  {1 7 9}
set cave(5)  {2 7 8}
set cave(6)  {3 8 9}
set cave(7)  {4 5 10}
set cave(8)  {5 6 11}
set cave(9)  {4 6 12}
set cave(10) {7 11 12}
set cave(11) {8 10 12}
set cave(12) {9 10 11}

proc swap {a b} {
  global cave

  set i 12
  while {$i > 0} {
    set j 2
    while {$j >= 0} {
      set k [lindex $cave($i) $j]
      if {$k == $a} {
        set k $b
      } else {
        if {$k == $b} {set k $a}
      }
      set cave($i) [lreplace $cave($i) $j $j $k]
      incr j -1
    }
    incr i -1
  }
  set k $cave($a)
  set cave($a) $cave($b)
  set cave($b) $k
}

proc game {} {
  global cave

  SafeTcl_displayline "Hunt the Wumpus!"
  set i 24
  while {$i > 0} {
    swap [SafeTcl_random 1 12] [SafeTcl_random 1 12]
    incr i -1
  }
  while {1} {
    set bat(1) [SafeTcl_random 1 12]
    set bat(2) [SafeTcl_random 1 12]
    set pit(1) [SafeTcl_random 1 12]
    set pit(2) [SafeTcl_random 1 12]
    set wumpus [SafeTcl_random 1 12]
    set room [SafeTcl_random 1 12]
    if {($room != $bat(1)) && ($room != $bat(2)) &&
        ($room != $pit(1)) && ($room != $pit(2)) &&
        ($room != $wumpus)} {
      break
    }
  }
  set quiver 3
  while {1} {
    SafeTcl_displayline "You are in room $room."
    if {($room == $pit(1)) || ($room == $pit(2))} {
      SafeTcl_displayline "Aieeee!!! You fell in a pit!"
      break
    }
    if {$room == $wumpus} {
      SafeTcl_displayline "Whoops! The Wumpus has eaten you!"
      break
    }
    if {($room == $bat(1)) || ($room == $bat(2))} {
      SafeTcl_displayline "Superbat attack!"
      set room [SafeTcl_random 1 12]
      continue
    }
    set connect1 [lindex $cave($room) 0]
    set connect2 [lindex $cave($room) 1]
    set connect3 [lindex $cave($room) 2]
    SafeTcl_displayline "Tunnels connect to $connect1, $connect2, and $connect3."
    if {($connect1 == $bat(1)) || ($connect2 == $bat(1)) ||
        ($connect3 == $bat(1)) || ($connect1 == $bat(2)) ||
        ($connect2 == $bat(2)) || ($connect3 == $bat(2))} {
      SafeTcl_displayline "Bats nearby!"
    }
    if {($connect1 == $pit(1)) || ($connect2 == $pit(1)) ||
        ($connect3 == $pit(1)) || ($connect1 == $pit(2)) ||
        ($connect2 == $pit(2)) || ($connect3 == $pit(2))} {
      SafeTcl_displayline "I feel a draft..."
    }
    if {($connect1 == $wumpus) || ($connect2 == $wumpus) ||
        ($connect3 == $wumpus)} {
      SafeTcl_displayline "I smell a Wumpus!!"
    }
    set moveorshoot [SafeTcl_getline "Move, Shoot, or Quit (M, S, or Q)? "]
    if {($moveorshoot == "M") || ($moveorshoot == "m")} {
      set newroom [SafeTcl_getline "Move to what room? "]
      if {($newroom != $connect1) && ($newroom != $connect2) &&
          ($newroom != $connect3)} {
        SafeTcl_displayline "There's no tunnel to that room!"
        continue
      }
      set room $newroom
    } else {
      if {($moveorshoot == "S") || ($moveorshoot == "s")} {
        set arrow $room
        set i 1
        while {$i <= 3} {
          set newarrow [SafeTcl_getline "Through room #$i? "]
          if {([lindex $cave($arrow) 0] != $newarrow) &&
              ([lindex $cave($arrow) 1] != $newarrow) &&
              ([lindex $cave($arrow) 2] != $newarrow)} {
            SafeTcl_displayline "Your arrow hit a wall."
            break
          }
          if {$newarrow == $wumpus} {
            SafeTcl_displayline "Congratulations! You killed the Wumpus!"
            set wumpus 0
            break
          }
          if {$newarrow == $room} {
            SafeTcl_displayline "Whoops! You shot yourself!"
            set wumpus 0
            break
          }
          set arrow $newarrow
          incr i +1
        }
        if {$wumpus == 0} {
          break
        }
        incr quiver -1
        if {$quiver == 0} {
          SafeTcl_displayline "You have run out of arrows!"
          break
        }
        set wumpus [lindex $cave($wumpus) [SafeTcl_random 0 2]]
      } else {
        if {($moveorshoot == "Q") || ($moveorshoot == "q")} {
          break
        }
      }
    }
  }
}

game
exit
