#
# saves a copy of a message in the specified file
#
# usage: swish -nointerface -messaging -messagebody - -file archive.tcl \
#	     logident logfile mailbox
#
# e.g.,
#
#    /usr/local/bin/swish ... -file /var/mail/scripts/archive.tcl \
#			      archive /var/tmp/mailinfo.log \
#			      /var/mail/archives/interop-pc
#

if {$argc != 3} {
    puts    stdout	"usage: ... mailbox logfile logident"
    return
}
set	logident	[format "%-8s" [lindex $argv 0]]
set	logfile		[lindex $argv 1]
set	mailbox		[lindex $argv 2]

set	logfd	""
set	logpid	""
set	loguser	""
set logmonth(Jan) 1
set logmonth(Feb) 2
set logmonth(Mar) 3
set logmonth(Apr) 4
set logmonth(May) 5
set logmonth(Jun) 6
set logmonth(Jul) 7
set logmonth(Aug) 8
set logmonth(Sep) 9
set logmonth(Oct) 10
set logmonth(Nov) 11
set logmonth(Dec) 12

proc	logwrite {string} {
    global    env logfd logfile logident logmonth logpid loguser

    set now [SafeTcl_getdateprop "" proper]

    if {$logfd == ""} {
	if {[catch { set logfd [open $logfile "a"] }]} {
	    return
	}

	set	logpid	[format "%05d" [pid]]
	if {[catch { set loguser [format "%-8s" $env(USER)] }]} {
	    set	loguser	[format "%-8s" [concat "#" [id userid]]]
	}
    } else {
	seek	$logfd	0 end
    }

    set date [format "%s/%s %s" $logmonth([string range $now 8 10]) \
                     [string range $now 5 6] [string range $now 17 24]]
    puts $logfd "$date $logident $logpid $loguser $string"
}

proc	logclose {} {
    global    logfd

    if {$logfd != ""} {
	catch { close $logfd }
	set	logfd	""
    }
}


if {([set from [SafeTcl_getheader "From"]] == "")
	&& ([set from [SafeTcl_getheader "Sender"]] == "")
	&& ([set from [SafeTcl_getheader "Return-Path"]] == "")} {
    catch { set from $SafeTcl_Originator }
}

set	subject [SafeTcl_getheader "Subject"]

if {[set id [SafeTcl_getheader "Resent-Message-ID"]] == ""} {
    set	id	[SafeTcl_getheader "Message-ID"]
}
logwrite    "INIT $from $id ($subject)"


if {[catch { MIME_savemessage mbox $mailbox }  result]} {
    logwrite    "unable to save message in $mailbox: $result"
}

logwrite	"DONE $mailbox"
logclose


return

