#
# sends back a canned response
#
# usage: swish -nointerface -messaging -messagebody - -file canned.tcl 
#	     logident logfile entity directives
#
# e.g., 
#
#    /usr/local/bin/swish ... -file /var/mail/scripts/canned.tcl \
#			      proposals /var/tmp/mailinfo.log \
#			      proposals-request /var/mail/scripts/canned.info
#
# The file named directives contains zero or more lines of the form:
#
#	# comment
#	regexp filename [addresses]
#
# where each regexp is compared against the Subject: line.  On the first match,
# the contents of filename is sent back to the originator plus any addresses
#

if {$argc != 4} {
    puts    stdout	"usage: ... logident logfile entity directives"
    return
}
set	logident	[format "%-8s" [lindex $argv 0]]
set	logfile		[lindex $argv 1]
set	entity		[lindex $argv 2]
set	directives	[lindex $argv 3]


set	logfd	""
set	logpid	""
set	loguser	""
set logmonth(Jan) 1
set logmonth(Feb) 2
set logmonth(Mar) 3
set logmonth(Apr) 4
set logmonth(May) 5
set logmonth(Jun) 6
set logmonth(Jul) 7
set logmonth(Aug) 8
set logmonth(Sep) 9
set logmonth(Oct) 10
set logmonth(Nov) 11
set logmonth(Dec) 12

proc	logwrite {string} {
    global    env logfd logfile logident logmonth logpid loguser

    set now [SafeTcl_getdateprop "" proper]

    if {$logfd == ""} {
	if {[catch { set logfd [open $logfile "a"] }]} {
	    return
	}

	set	logpid	[format "%05d" [pid]]
	if {[catch { set loguser [format "%-8s" $env(USER)] }]} {
	    set	loguser	[format "%-8s" [concat "#" [id userid]]]
	}
    } else {
	seek	$logfd	0 end
    }

    set date [format "%s/%s %s" $logmonth([string range $now 8 10]) \
                     [string range $now 5 6] [string range $now 17 24]]
    puts $logfd "$date $logident $logpid $loguser $string"
}

proc	logclose {} {
    global    logfd

    if {$logfd != ""} {
	catch { close $logfd }
	set	logfd	""
    }
}


if {([set from [SafeTcl_getheader "Reply-To"]] == "")
	&& ([set from [SafeTcl_getheader "From"]] == "")
	&& ([set from [SafeTcl_getheader "Sender"]] == "")
	&& ([set from [SafeTcl_getheader "Return-Path"]] == "")} {
    catch { set from $SafeTcl_Originator }
    if {$from == ""} {
	logwrite    "ERR  unable to determine return address"
	logclose
	return
    }
}

if {[set subject [SafeTcl_getheader "Subject"]] == ""} {
    set	oldsubj	"help"	
    set subject "Your message to $logident"
} else {
    set	oldsubj	$subject
    set	subject	"Re: $subject"
}

if {[set id [SafeTcl_getheader "Resent-Message-ID"]] == ""} {
    set	id	[SafeTcl_getheader "Message-ID"]
}
logwrite    "INIT $from $id ($subject)"


if {[catch { set fd [open $directives "r"] } result]} {
    logwrite	"ERR  unable to open $directives: $result"

    if {[catch { MIME_sendmessage -to $from -subject $subject -cc $entity \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
			        -parameter "charset=us-ascii" \
				$result] } \
	     result]} {
	logwrite    "ERR  unable to send reply: $result"
    }

    logclose
    return
}

while {[gets $fd line] >= 0} {
    if {([string index $line 0] == "#") \
	    || ([llength $line] < 2)} {
	continue
    }
    set		pattern		[lindex $line 0]
    if {($pattern == "*") || ([regexp -nocase $pattern $oldsubj])} {
	break
    }
}

close	$fd

if {[llength $line] < 1} {
    logwrite	"DONE no match"
    logclose
    return
}
set	others		[lrange $line 2 end]

if {[catch { set fd [open [set canned [lindex $line 1]] "r"] } result]} {
    logwrite	"ERR  unable to open $canned: $result"

    if {[catch { MIME_sendmessage -to $from -subject $subject -cc $entity \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
			        -parameter "charset=us-ascii" \
				$result] } \
	     result]} {
	logwrite    "ERR  unable to send reply: $result"
    }

    logclose
    return
}

unset	result
while {[gets $fd line] >= 0} {
    append	result	$line\n
}

close	$fd

if {[catch { MIME_sendmessage -to $from -subject $subject \
		 -auxheader "From" $entity -auxheader "Dcc" $others \
	         -body [SafeTcl_makebody "text/plain" \
			    -parameter "charset=us-ascii" \
			    $result] } result]} {
    logwrite    "ERR  unable to send reply: $result"
}

logwrite    "DONE $canned"
logclose


return
