#
# returns a content-type
#
# usage: swish -nointerface -messaging -messagebody - -file mime-server.tcl 
#	     logident logfile entity directory
#
# e.g., 
#
#    /usr/local/bin/swish ... -file /var/mail/scripts/mime-server.tcl \
#			      mimesrvr /var/tmp/mailinfo.log \
#			      mime-server-request /var/spool/ftp/pub
#

if {$argc != 4} {
    puts    stdout	"usage: ... logident logfile entity directory"
    return
}
set	logident	[format "%-8s" [lindex $argv 0]]
set	logfile		[lindex $argv 1]
set	entity		[lindex $argv 2]
set	directory	[lindex $argv 3]


set	logfd	""
set	logpid	""
set	loguser	""
set logmonth(Jan) 1
set logmonth(Feb) 2
set logmonth(Mar) 3
set logmonth(Apr) 4
set logmonth(May) 5
set logmonth(Jun) 6
set logmonth(Jul) 7
set logmonth(Aug) 8
set logmonth(Sep) 9
set logmonth(Oct) 10
set logmonth(Nov) 11
set logmonth(Dec) 12

proc	logwrite {string} {
    global    env logfd logfile logident logmonth logpid loguser

    set now [SafeTcl_getdateprop "" proper]

    if {$logfd == ""} {
	if {[catch { set logfd [open $logfile "a"] }]} {
	    return
	}

	set	logpid	[format "%05d" [pid]]
	if {[catch { set loguser [format "%-8s" $env(USER)] }]} {
	    set	loguser	[format "%-8s" [concat "#" [id userid]]]
	}
    } else {
	seek	$logfd	0 end
    }

    set date [format "%s/%s %s" $logmonth([string range $now 8 10]) \
                     [string range $now 5 6] [string range $now 17 24]]
    puts $logfd "$date $logident $logpid $loguser $string"
}

proc	logclose {} {
    global    logfd

    if {$logfd != ""} {
	catch { close $logfd }
	set	logfd	""
    }
}


if {([set from [SafeTcl_getheader "Reply-To"]] == "")
	&& ([set from [SafeTcl_getheader "From"]] == "")
	&& ([set from [SafeTcl_getheader "Sender"]] == "")
	&& ([set from [SafeTcl_getheader "Return-Path"]] == "")} {
    catch { set from $SafeTcl_Originator }
    if {$from == ""} {
	logwrite    "ERR  unable to determine return address"
	logclose
	return
    }
}

if {[set subject [SafeTcl_getheader "Subject"]] == ""} {
    set subject "Your message to $logident"
} else {
    set	subject	"Re: $subject"
}

if {[set id [SafeTcl_getheader "Resent-Message-ID"]] == ""} {
    set	id	[SafeTcl_getheader "Message-ID"]
}
logwrite    "INIT $from $id ($subject)"


if {[set type [SafeTcl_getbodyprop "1" "type"]] != "text/plain"} {
    logwrite    "ERR  not a plain text content ($type)"

    if {[catch { MIME_sendmessage -to $from -subject $subject \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
			        -parameter "charset=us-ascii" \
			        "not a plain text content ($type)"] } \
	     result]} {
	logwrite    "ERR  unable to send reply: $result"
    }

    logclose
    return
}


if {[catch { set input [SafeTcl_decode \
			    [SafeTcl_getbodyprop "1" "encoding"] \
			    [SafeTcl_getbodyprop "1" "value"]] } result]} {
    logwrite	"ERR  decoding failed: $result"

    if {[catch { MIME_sendmessage -to $from -subject $subject \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
			        -parameter "charset=us-ascii" \
			        "decoding failed ($result)"] } result]} {
	logwrite    "ERR  unable to send reply: $result"
    }

    logclose
    return
}

proc	transcript {} {
    global    from subject entity msglog

    if {[catch { MIME_sendmessage -to $from -subject $subject \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
				-parameter "charset=us-ascii" \
				$msglog] } result]} {
	logwrite	"ERR  unable to send transcript: $result"
    }
}

set	type	""
set	id	""
set	limit	50000
set	msglog	""
set	msgsep	""

foreach	line	[split [string trim $input] "\n"] {
    if {$line == ""} {
	append	msgsep	"\n"
	continue
    }
    append	msglog	"$msgsep>>> $line\n"
    set		msgsep	"\n"

    if {[string range $line 0 0] == "#"} {
	set	msgsep	""
	continue
    }

    if {[regexp -nocase {^help} $line]} {
	append	msglog	"commands are:\n\nlimit <size>\tsets the fragmentation size\ntype  <string>\tsets the Content-Type for the next file retrieved\nid    <string>\tsets the Content-ID   for the next file retrieved\nretr  <string>\tretrieves the named file\n"
	continue
    }
    if {[regexp -nocase {^limit[ 	]} $line]} {
	set	arg	[string trim [string range $line 6 end]]
	if {[catch { scan $arg "%d" larg } result]} {
	    append	msglog	"invalid limit $arg\n"
	    logwrite	"ERR  invalid limit $arg: $result"
	} elseif {($larg < 25000) && ($larg != 0)} {
	    append	msglog	"limit too small $arg\n"
	    logwrite	"ERR  limit too small $arg"
	} elseif {[set limit $larg] > 0} {
	    append	msglog	"no problem\n"
	} else {
	    append	msglog	"no fragmentation\n"
	}
	continue
    }

    if {[regexp -nocase {^type[ 	]} $line]} {
	set	arg	[string trim [string range $line 4 end]]
	if {$arg == ""} {
	    append	msglog	"invalid type $arg\n"
	    logwrite	"ERR  invalid type $arg"
	} else {
	    set		type	$arg
	    append	msglog	"no problem\n"
	}
	continue
    }

    if {[regexp -nocase {^id[ 	]} $line]} {
	set	arg	[string trim [string range $line 3 end]]
	if {([string range $arg 0 0] != "<")
		|| ([string range $arg [expr [string length $arg]-1] end] \
			!= ">")
		|| ($arg == "<>")} {
	    append	msglog	"invalid id $arg\n"
	    logwrite	"ERR  invalid id $arg"
	} else {
	    set		id	$arg
	    append	msglog	"no problem\n"
	}
	continue
    }

    if {![regexp -nocase {^retr[ 	]} $line]} {
	append		msglog	"unknown command\n"
	logwrite	"ERR  unknown cmd $line"
	continue
    }

    if {($type == "") || ($id == "")} {
	append		msglog	"must specify type and id before retr\n"
	logwrite	"ERR  type/id not specified"
	continue
    }
    if {[set file [string trim [string range $line 5 end]]] == ""} {
	append		msglog	"empty filename\n"
	logwrite	"ERR  empty filename"
	continue
    }
    if {([string range $file 0 0] == "/")
	    || ([string range $file 0 0] == ".")} {
	append		msglog	"invalid filename $file\n"
	logwrite	"ERR  invalid filename $file"
	continue
    }
    logwrite    "RETR $directory/$file $id"

    if {[catch { set name [swish_filebody $type "$directory/$file" \
			       -id $id] } result]} {
	append		msglog	"unable to prepare $file\n"
	logwrite	"ERR filebody failed: $result"
	continue
    }
    if {[catch { set size [file size $name] } result]} {
	append		msglog	"unable to determine file size\n"
	logwrite	"ERR file size failed: $result"
	catch { exec rm $name }
	continue
    }
    if {[catch { set fd [open $name "r"] } result]} {
	append		msglog	"unable to open file\n"
	logwrite	"ERR file open failed: $result"
	catch { exec rm $name }
	continue
    }

    if {($limit == 0) || ($size < $limit)} {
	set	body	""
	while {[gets $fd line] >= 0} {
	    append	body	$line "\n"
	}
	close	$fd
	catch { exec rm $name }

	if {[catch { MIME_sendmessage -queue -to $from -subject "retr $file" \
			 -auxheader "From" $entity -body $body } result]} {
	    append	msglog	"unable to send content, sorry!\n"
	    logwrite	"ERR  unable to send content: $result"
	} else {
	    append	msglog	"queued for delivery\n"
	}
	unset	body
	set	type	""
	set	id	""
	continue
    }

    set		bodylen	[string length [set body ""]]
    set		partno	1
    while {[gets $fd line] >= 0} {
	append	line	"\n"
	if {([set linelen [string length $line]]+$bodylen) > $limit} {
	    if {[catch { MIME_sendmessage -queue \
			     -to $from -subject "retr $file, part $partno" \
			     -auxheader "From" $entity \
			     -body [SafeTcl_makebody "message/partial" \
					-parameter "number=$partno" \
					-parameter "id=\"$id\"" \
					$body] } result]} {
		append		msglog	"unable to send part $partno, sorry!\n"
		logwrite	"ERR  unable to send part $partno: $result"
		transcript
		logclose
		close		$fd
		catch 		{ exec rm $name }
		return
	    }
	    set		bodylen	[string length [set body ""]]
	    incr	partno
	}

	append	body	$line
	incr	bodylen	$linelen
    }
    close	$fd
    catch	{ exec rm $name }

    if {[catch { MIME_sendmessage -queue \
		     -to $from -subject "retr $file, part $partno" \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "message/partial" \
				-parameter "number=$partno" \
				-parameter "total=$partno" \
				-parameter "id=\"$id\"" \
				$body] } result]} {
	append		msglog	"unable to send part $partno, sorry!\n"
	logwrite	"ERR  unable to send part $partno: $result"
	transcript
	logclose
	return
    }
    unset	body
    set		type	""
    set		id	""
    append	msglog	"queued for delivery ($partno parts)\n"
}

transcript
logwrite    "DONE"
logclose


return
