#include <tcl.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/param.h>
#include <unistd.h>

#include "interfaceStyle.h"

#ifdef	SYS5
#define	index	strchr
#define	rindex	strrchr
#endif

extern Tcl_Interp *unrestricted_interp;
static Tcl_Interp *registered_restricted_interp = NULL;
extern char *index(), *malloc(), *getenv();
extern SafeTclP_configdata ();
extern char *RestrictContents, *UnrestrictContents, *UnrestrictContents2, *UnrestrictContents3;

static char *CommandsToNuke[] = {
    ".",
    "Acl+",
    "Acl-",
    "AclCheck",
    "alarm",
    "auto_execok",
    "auto_load",
    "auto_load_all",
    "auto_mkindex",
    "auto_reset",
    "bsearch",
    "catclose",
    "catgets",
    "catopen",
    "cd",
    "cequal",
    "cexpand",
    "chgrp",
    "chmod",
    "chown",
    "chroot",
    "cindex",
    "clength",
    "close",
    "cmdtrace",
    "commandloop",
    "convertclock",
    "copyfile",
    "crange",
    "csubstr",
    "ctoken",
    "ctype",
    "dp_AcceptRPCConnection",
    "dp_AppendTrigger",
    "dp_AppendTriggerUnique",
    "dp_CancelRPC",
    "dp_CheckHost",
    "dp_CleanupRPC",
    "dp_ClearTriggers",
    "dp_CloseRPC",
    "dp_CloseRPCFile",
    "dp_CreateRemoteObject",
    "dp_DeleteRemoteObject",
    "dp_DistributeObject",
    "dp_GetTriggers",
    "dp_Host",
    "dp_MakeRPCClient",
    "dp_MakeRPCServer",
    "dp_ProcessRPCCommand",
    "dp_ProcessRPCMessages",
    "dp_RDO",
    "dp_RPC",
    "dp_RPROC",
    "dp_ReceiveRPC",
    "dp_ReleaseTrigger",
    "dp_SetCheckCmd",
    "dp_SetTrigger",
    "dp_ShutdownRPC",
    "dp_ShutdownServer",
    "dp_SlotNames",
    "dp_UndistributeObject",
    "dp_accept",
    "dp_address",
    "dp_after",
    "dp_atclose",
    "dp_atclose_close",
    "dp_atexit",
    "dp_atexit_exit",
    "dp_connect",
    "dp_downsetf",
    "dp_filehandler",
    "dp_getf",
    "dp_isready",
    "dp_objectConfigure",
    "dp_objectCreateProc",
    "dp_objectExists",
    "dp_objectFree",
    "dp_objectSlot",
    "dp_objectSlotAppend",
    "dp_objectSlotFree",
    "dp_objectSlotSet",
    "dp_objectSlots",
    "dp_packetReceive",
    "dp_packetSend",
    "dp_receive",
    "dp_receiveFrom",
    "dp_send",
    "dp_sendTo",
    "dp_setf",
    "dp_shutdown",
    "dp_socketOption",
    "dp_update",
    "dp_waitvariable",
    "dp_whenidle",
    "dup",
    "echo",
    "eof",
    "exec",
    "execl",
    "fcntl",
    "file",
    "flock",
    "flush",
    "fmtclock",
    "fork",
    "frename",
    "fstat",
    "ftruncate",
    "funlock",
    "getclock",
    "gets",
    "glob",
    "id",
    "infox",
    "keyldel",
    "keylget",
    "keylkeys",
    "keylset",
    "kill",
    "lassign",
    "ldelete",
    "lempty",
    "lgets",
    "link",
    "lmatch",
    "loop",
    "lremovedup",
    "lvarcat",
    "lvarpop",
    "lvarpush",
    "match",
    "matchExact",
    "matchNoCaseExact",
    "matchNoCasePattern",
    "matchPattern",
    "max",
    "min",
    "mkdir",
    "nice",
    "open",
    "parray",
    "pid",
    "pipe",
    "profile",
    "puts",
    "pwd",
    "random",
    "read",
    "readdir",
    "replicate",
    "rmdir",
    "scancontext",
    "scanfile",
    "scanmatch",
    "seek",
    "select",
    "send",
    "server_open",
    "signal",
    "sleep",
    "source",
    "sync",
    "system",
    "tell",
    "time",
    "times",
    "tkerror.tk",
    "toplevel",
    "translit",
    "umask",
    "unknown",
    "unlink",
    "wait",
    ".",
    NULL};
static int CommandsToNukeCt=(sizeof (CommandsToNuke) / sizeof (char *)) -1 ;

static char *CommandsToKeep[] = {
    "after",
    "append",
    "array",
    "bind",
    "break",
    "button",
    "canvas",
    "case",
    "catch",
    "checkbutton",
    "concat",
    "continue",
    "destroy",
    "entry",
    "error",
    "eval",
    "exit",
    "expr",
    "focus",
    "for",
    "foreach",
    "format",
    "frame",
    "global",
    "grab",
    "history",
    "if",
    "incr",
    "info",
    "join",
    "label",
    "lappend",
    "lindex",
    "lineto",
    "linsert",
    "list",
    "listbox",
    "llength",
    "lower",
    "lrange",
    "lreplace",
    "lsearch",
    "lsort",
    "menu",
    "menubutton",
    "message",
    "moveto",
    "option",
    "pack",
    "place",
    "proc",
    "radiobutton",
    "raise",
    "regexp",
    "regsub",
    "rename",
    "return",
    "scale",
    "scan",
    "scrollbar",
    "selection",
    "set",
    "split",
    "string",
    "switch",
    "text",
    "time",
    "tk",
    "tk_bindForTraversal",
    "tk_butDown",
    "tk_butEnter",
    "tk_butLeave",
    "tk_butUp",
    "tk_entryBackspace",
    "tk_entryBackword",
    "tk_entrySeeCaret",
    "tk_firstMenu",
    "tk_getMenuButtons",
    "tk_invokeMenu",
    "tk_listboxSingleSelect",
    "tk_mbButtonDown",
    "tk_mbPost",
    "tk_mbUnpost",
    "tk_menuBar",
    "tk_menus",
    "tk_nextMenu",
    "tk_nextMenuEntry",
    "tk_textBackspace",
    "tk_textIndexCloser",
    "tk_textResetAnchor",
    "tk_textSelectTo",
    "tk_traverseToMenu",
    "tk_traverseWithinMenu",
    "tkerror",
    "tkwait",
    "trace",
    "unset",
    "update",
    "uplevel",
    "upvar",
    "while",
    "winfo",
    "wm",
    NULL};
static int CommandsToKeepCt=(sizeof (CommandsToKeep) / sizeof (char *)) -1 ;


/* The following allows the restricted interpreter to run specified commands in the unrestricted interpreter */

int
SafeTcl_RunUnrestrictedCommand(clientdata, interp, argc, argv)
ClientData clientdata;
Tcl_Interp     *interp;
int		argc;
char	      **argv;
{
    int i, resultcode;
    char *tmpstr;
    if (interp != registered_restricted_interp) {
        fprintf(stderr, "Unexpected error:  SafeTcl_RunUnrestrictedCommand called on an interpreter that is not the Safe-Tcl interpreter\n");
        exit(-1);
    }
    argv[0] = (char *) clientdata;
    /* Now evaluate it in the OTHER interpreter */
    resultcode = Tcl_Eval(unrestricted_interp, Tcl_Merge(argc, argv));
    Tcl_SetResult(registered_restricted_interp, unrestricted_interp->result, TCL_VOLATILE);
    tmpstr = Tcl_GetVar(unrestricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
    Tcl_AddErrorInfo(registered_restricted_interp, tmpstr ? tmpstr : "<no error info>");
    tmpstr = Tcl_GetVar(unrestricted_interp, "errorCode", TCL_GLOBAL_ONLY);
    if (tmpstr) Tcl_SetErrorCode(registered_restricted_interp, tmpstr, 0);
    return resultcode;
}

/* The following allows the unrestricted interpreter to run arbitrary commands in the restricted interpreter */

int
RestrictedEval_Cmd(clientdata, interp, argc, argv)
ClientData clientdata;
Tcl_Interp     *interp;
int		argc;
char	      **argv;
{
    int i, resultcode;
    char *tmpstr;
    if (interp != unrestricted_interp) {
        fprintf(stderr, "Unexpected error:  RestrictedEval called on an interpreter that is not the unrestricted interpreter associated with the Safe-Tcl interpreter\n");
        exit(-1);
    }
    argv[0] = "eval";
    /* Now evaluate it in the OTHER interpreter at the global level */
    resultcode = Tcl_GlobalEval(registered_restricted_interp, Tcl_Merge(argc, argv)); 
    Tcl_SetResult(unrestricted_interp, registered_restricted_interp->result, TCL_VOLATILE);
    tmpstr = Tcl_GetVar(registered_restricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
    Tcl_AddErrorInfo(unrestricted_interp, tmpstr ? tmpstr : "<no error info>");
    tmpstr = Tcl_GetVar(registered_restricted_interp, "errorCode", TCL_GLOBAL_ONLY);
    if (tmpstr) Tcl_SetErrorCode(unrestricted_interp, tmpstr, 0);
    return resultcode;
}


/* The following looks up a name in an alphabetized array of strings, returning the index, or -1 if it isn't found. */
int 
FindInTable(name, table, tabsize)
char *name, **table;
int tabsize;
{
    int bot=0, top=tabsize-1, i, cmp;
    while (bot<=top) {
        i=bot+((top-bot)/2);
        cmp = strcmp(table[i], name);
        if (cmp == 0) return i;
        if (cmp < 0) {
            bot = i+1;
        } else top = i-1;
    }
    return(-1);
}

/* The following defines a command that can be used in the 
  unrestricted interpreter to make new functionality available 
  in the restricted interpreter. */
int 
DeclareHarmless(clientdata, interp, argc, argv)
ClientData clientdata;
Tcl_Interp     *interp;
int		argc;
char	      **argv;
{
    char *cmdname;
    if (interp != unrestricted_interp) {
        fprintf(stderr, "Unexpected error:  DeclareHarmless called on an interpreter that is not the Safe-Tcl unrestricted interpreter\n");
        exit(-1);
    }
    if (argc != 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                          " command-name\"", (char *) NULL);
        return TCL_ERROR;
    }
    cmdname = malloc(1+strlen(argv[1]));
    if (!cmdname) {
        fprintf(stderr, "Out of memory!\n");
        exit (-1);
    }
    strcpy(cmdname, argv[1]);
    Tcl_CreateCommand(registered_restricted_interp, cmdname,
                       SafeTcl_RunUnrestrictedCommand,
                       (ClientData) cmdname, (void (*) ()) 0);
    return TCL_OK;
}

#ifdef SYSV
#define initstate srand
#define random rand
#endif

SafeTcl_RandomCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int min, max;
    char ansbuf[10];
    static int DidInitRandom=0;
    static char RandomSpace[64];

    if (argc != 3) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                          " min max\"", (char *) NULL);
        return TCL_ERROR;
    }
    min = atoi(argv[1]);
    max = atoi(argv[2]);
    if (!DidInitRandom) {
	initstate(time(0) ^ getpid(), RandomSpace, sizeof(RandomSpace));
	DidInitRandom = 1;
    }
    if (min > max) {
        Tcl_AppendResult(interp, "The min value may not be greater than the max value", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(ansbuf, "%d", (random() % (max - min + 1)) + min);
    Tcl_SetResult(interp, ansbuf, TCL_VOLATILE);
    return(TCL_OK);
}

char *
FindLibFile(libfilename, tklib, personallib, archivesite, archivedir)
char *libfilename, *tklib, *personallib, *archivesite, *archivedir;
{
    static char FullName[MAXPATHLEN];
    char remote[100];

    sprintf(FullName, "%s/%s.ste", tklib, libfilename);
    if (!access(FullName, R_OK)) return FullName;

    sprintf(FullName, "%s/%s.ste", personallib, libfilename);
    if (!access(FullName, R_OK)) return FullName;

    sprintf(remote, "%s.ste", libfilename);
    sprintf(FullName, "%s/%s.ste", personallib, libfilename);
    if (OpenFtpAux ((Tcl_Interp *) 0, archivesite, "anonymous", (char *) 0,
		    archivedir, remote, FullName, (char *) 0) == TCL_OK)
	return FullName;

    return NULL;
}

SafeTcl_LoadLib_Cmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    char *libname, *fname, *tklib, *personallib, *archivesite, *archivedir;

    if (argc != 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                          " libname\"", (char *) NULL);
        return TCL_ERROR;
    }
    libname = argv[1];
    tklib = Tcl_GetVar(unrestricted_interp, "configdata(public-library)", TCL_GLOBAL_ONLY);
    personallib = Tcl_GetVar(unrestricted_interp, "configdata(private-library)", TCL_GLOBAL_ONLY);
    archivesite = Tcl_GetVar(unrestricted_interp, "configdata(external-site)", TCL_GLOBAL_ONLY);
    archivedir = Tcl_GetVar(unrestricted_interp, "configdata(external-library)", TCL_GLOBAL_ONLY);
    fname = FindLibFile(libname, tklib, personallib, archivesite, archivedir);
    if (fname == NULL) {
        Tcl_AppendResult(interp, "Could not find and load library: ", libname, (char *) NULL);
        return TCL_ERROR;
    }
    if (Tcl_EvalFile(unrestricted_interp, fname) != TCL_OK) {
        char *tmpstr;
        /* Propogate errors to correct interp */
        Tcl_SetResult(interp, unrestricted_interp->result, TCL_VOLATILE);
        tmpstr = Tcl_GetVar(unrestricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
        Tcl_AddErrorInfo(interp, tmpstr ? tmpstr : "<no error info>");
        tmpstr = Tcl_GetVar(unrestricted_interp, "errorCode", TCL_GLOBAL_ONLY);
        if (tmpstr) Tcl_SetErrorCode(interp, tmpstr, 0);
        return TCL_ERROR;
    }
    Tcl_SetResult(interp, fname, TCL_VOLATILE);
    return(TCL_OK);
}

SafeTcl_GenidCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    static long mycounter = 0;
    register char *cp;
    char RawBuf[11];
    long dum;

    if (argc != 1) {
        Tcl_AppendResult(interp, "wrong # args: should be none", (char *) NULL);
        return TCL_ERROR;
    }
    dum=time(0);
    RawBuf[0] = (char) (dum>>24) & 0xFF;
    RawBuf[1] = (char) (dum>>16) & 0xFF;
    RawBuf[2] = (char) (dum>>8) & 0xFF;
    RawBuf[3] = (char) dum & 0xFF;
    dum = getpid();
    RawBuf[4] = (char) dum & 0xFF;
    RawBuf[5] = (char) (dum>>8) & 0xFF;
    dum = getuid();
    RawBuf[6] = (char) dum & 0xFF;
    RawBuf[7] = (char) (dum>>8) & 0xFF;
    ++mycounter;
    RawBuf[8] = (char) mycounter & 0xFF;
    RawBuf[9] = (char) (mycounter>>8) & 0xFF;
    RawBuf[10] = (char) NULL;
    if (SafeTcl_encode_aux (interp, "base64", RawBuf, sizeof RawBuf)
	    == TCL_ERROR)
	return TCL_ERROR;

    for (cp = interp -> result; *cp; cp++)
	if (*cp == '/' || *cp == '+')
	    *cp = '.';
	else
	    if (*cp == '=') {
		*cp = '\0';
		break;
	    }

    return TCL_OK;
}

static char *NotRenamables[] = {
    "rename",
    "exit",
    NULL
};

int
SafeTcl_RenameCmd(dummy, interp, argc, argv)
ClientData dummy;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
    int i;
    for (i=0; NotRenamables[i]; ++i) {
	if (!strcmp(NotRenamables[i], argv[1]) || !strcmp(NotRenamables[i], argv[2])) {
	    Tcl_AppendResult(interp, "This program is trying to use \"rename\" to subvert Safe-Tcl security!", (char *) NULL);
	    return TCL_ERROR;
	}
    }
    return Tcl_RenameCmd(dummy, interp, argc, argv);
}

int
SafeTcl_ProcCmd(dummy, interp, argc, argv)
ClientData dummy;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
    int i;
    for (i=0; NotRenamables[i]; ++i) {
	if (!strcmp(NotRenamables[i], argv[1])) {
	    Tcl_AppendResult(interp, "This program is trying to use \"proc\" to subvert Safe-Tcl security!", (char *) NULL);
	    return TCL_ERROR;
	}
    }
    return Tcl_ProcCmd(dummy, interp, argc, argv);
}

SafeTcl_ExitCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int	    status = 0;

    if (argc > 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                          " [statuscode]\"", (char *) NULL);
        return TCL_ERROR;
    }
    else
	if (argc > 1) {
	    if (Tcl_GetInt (interp, argv[1], &status) != TCL_OK)
		return TCL_ERROR;
	}
        else
	    status = 0;

    safeexit (status);
}

safeexit(code)
int code;
{
    CloseMessageBody();
    exit(code);
}

int
Tcl_MakeInterpreterSafe(restricted_interp, unrestricted_interp, w, generic)
Tcl_Interp *restricted_interp; /* The safe-tcl interpeter-to-be */
Tcl_Interp *unrestricted_interp; /* associated non-safe-tcl interpeter */
Tk_Window w; /* the main window */
int generic;
{
    int i, cmdcount;
    char **cmdlist;

    if (!Tcl_NoInterface ()) {
        Tcl_SetVar(restricted_interp, "SafeTcl_InterfaceStyle", "generic", TCL_GLOBAL_ONLY|TCL_LIST_ELEMENT);
/*
	Tk+$TK_VERSION
 */
        if (!generic) Tcl_SetVar(restricted_interp, "SafeTcl_InterfaceStyle", "Tk3.6", TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
    } else {
        Tcl_SetVar(restricted_interp, "SafeTcl_InterfaceStyle", "", TCL_GLOBAL_ONLY|TCL_LIST_ELEMENT);
    }
    registered_restricted_interp = restricted_interp;
    /* First, some basic initialization */
    if (Tcl_Eval(restricted_interp, RestrictContents) != TCL_OK) {
        return TCL_ERROR;
    }
    if (Tcl_Eval(restricted_interp, "info commands") != TCL_OK) {
	return TCL_ERROR;
    }
    Tcl_SplitList(restricted_interp, restricted_interp->result, &cmdcount, &cmdlist);
    for (i=0; i<cmdcount; ++i) {
	if (FindInTable(cmdlist[i], CommandsToNuke, CommandsToNukeCt) >= 0) {
            Tcl_DeleteCommand(restricted_interp, cmdlist[i]);
        } else if (FindInTable(cmdlist[i], CommandsToKeep, CommandsToKeepCt) >= 0) {
            /* Silently accept it */
        } else {
            printf("WARNING:  Found an unexpected command, \"%s\", deleting it.\n", cmdlist[i]);
            Tcl_DeleteCommand(restricted_interp, cmdlist[i]);
        }
    }
    free((char *)cmdlist);
    /* Here we add in new Safe-Tcl commands, including UI dependent ones, etc. */
    Tcl_CreateCommand(restricted_interp, "rename", SafeTcl_RenameCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "proc", SafeTcl_ProcCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "SafeTcl_loadlibrary", SafeTcl_LoadLib_Cmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "exit", SafeTcl_ExitCmd,
                       (ClientData) w, (void (*) ()) 0);
    Tcl_CreateCommand(restricted_interp, "SafeTcl_random", SafeTcl_RandomCmd,
                       (ClientData) w, (void (*) ()) 0);
    /* Now some special initialization for the unrestricted interpreter */
    InitUnrestricted(generic);
    Tcl_CreateCommand(unrestricted_interp, "exit",
		       SafeTcl_ExitCmd,
                       (ClientData) w, (void (*) ()) 0);
    /* New commands for the unrestricted interpreter */
    Tcl_CreateCommand(unrestricted_interp, "restrictedeval",
                       RestrictedEval_Cmd,
                       (ClientData) 0, (void (*) ()) 0);
    Tcl_CreateCommand(unrestricted_interp, "declareharmless",
                       DeclareHarmless,
                       (ClientData) 0, (void (*) ()) 0);
    Tcl_CreateCommand(unrestricted_interp, "SafeTclP_configdata", SafeTclP_configdata,
		       (ClientData) 0, (void (*) ()) 0);
		       
    RegisterInterfaceStyleCommands(restricted_interp, w);
    
    if (Tcl_VarEval(unrestricted_interp, UnrestrictContents, "\n", UnrestrictContents2, "\n", UnrestrictContents3, "\n", 0, (char **) NULL) != TCL_OK) {
        char *m;
        /* Propogate the error to the restricted interpreter for reporting */
        Tcl_SetResult(restricted_interp, unrestricted_interp->result, TCL_VOLATILE);
        m = Tcl_GetVar(unrestricted_interp, "errorInfo", TCL_GLOBAL_ONLY);
        Tcl_AddErrorInfo(restricted_interp, m ? m : "<no error info>");
        m = Tcl_GetVar(unrestricted_interp, "errorCode", TCL_GLOBAL_ONLY);
        if (m) Tcl_SetErrorCode(restricted_interp, m, 0);
        return TCL_ERROR;
    }
    return(TCL_OK);
}

RemoveInterface(interp, unrestricted_interp)
Tcl_Interp     *interp, *unrestricted_interp;
{
    /* And remove the following fromt he restricted interpreter */
      Tcl_DeleteCommand(interp, "SafeTcl_gettext");
      Tcl_DeleteCommand(interp, "SafeTcl_displaybody");
      Tcl_DeleteCommand(interp, "SafeTcl_displaytext");
      Tcl_DeleteCommand(interp, "SafeTcl_getline");
      Tcl_DeleteCommand(interp, "SafeTcl_displayline");
    /* And remove the following from the unrestricted interpreter */
      if (!unrestricted_interp) unrestricted_interp = interp; /* no -safe */
      Tcl_DeleteCommand(unrestricted_interp, "MIME_ConfirmAction");
      Tcl_DeleteCommand(unrestricted_interp, "MIME_displaybody");
}

static int   temporaryP = 0;
extern char *SafeTcl_message;
extern FILE *SafeTcl_fp;
extern char *getcpy (), *m_tmpfil (), *rindex ();
    
int	InitMessageBody (interp, myname, filename)
Tcl_Interp *interp;
char   *myname,
       *filename;
{
    char    buffer[BUFSIZ];
    FILE   *zp = stdin;

    if (!filename)
	return TCL_OK;

    if (!(temporaryP = !strcmp (filename, "-"))) {
	if (!(SafeTcl_fp = fopen (SafeTcl_message = filename, "r")))
	    goto losing;
	if (fgets (buffer, sizeof buffer, SafeTcl_fp)
	        && !strncmp (buffer, "From ", sizeof "From " - 1)) {
	    zp = SafeTcl_fp, SafeTcl_fp = NULL;
	    rewind (zp);
	    temporaryP = 1;
	    goto copy_file;
	}
    }
    else {
copy_file: ;
	if (!(SafeTcl_fp = fopen (SafeTcl_message = getcpy (m_tmpfil (myname)),
				  "w+"))) {
losing: ;
	    interp -> result = Tcl_PosixError (interp);
	    if (zp != stdin)
		fclose (zp);
	    return TCL_ERROR;
	}

	if (!fgets (buffer, sizeof buffer, zp))
	    goto done_copy;
	if (!strncmp (buffer, "From ", sizeof "From " - 1)) {
	    register char  *fp,
			   *cp,
			   *hp,
			   *ep;
	    char    rpath[BUFSIZ];

	    hp = cp = index (fp = buffer + sizeof "From " - 1, ' ');
	    while (hp = index (++hp, 'r'))
		if (uprf (hp, "remote from")) {
		    hp = rindex (hp, ' ');
		    break;
		}
	    if (hp) {
		ep = rindex (++hp, '\n');
		(void) sprintf (rpath, "%.*s!%.*s", ep - hp, hp, cp - fp, fp);
	    }
	    else
		(void) sprintf (rpath, "%.*s", cp - fp, fp);
	    if (!Tcl_GetVar (interp, "SafeTcl_Originator", TCL_GLOBAL_ONLY))
		Tcl_SetVar (interp,  "SafeTcl_Originator", rpath,
			    TCL_GLOBAL_ONLY);

#ifdef	RPATHS
	    fprintf (SafeTcl_fp, "Return-Path: <%s>\n", rpath);
#endif
	}
	else
	    (void) fputs (buffer, SafeTcl_fp);
	
	while (fgets (buffer, sizeof buffer, zp))
	    (void) fputs (buffer, SafeTcl_fp);

done_copy: ;
	if (fflush (SafeTcl_fp))
	    goto losing;
	(void) chmod (SafeTcl_message, 0600);
	rewind (SafeTcl_fp);
    }

    if (zp != stdin)
	fclose (zp);
    return TCL_OK;
}

int	CloseMessageBody ()
{
    if (temporaryP && SafeTcl_message) {
	(void) unlink (SafeTcl_message);
	free (SafeTcl_message);
	SafeTcl_message = NULL;
    }
    if (SafeTcl_fp) {
	(void) fclose (SafeTcl_fp);
	SafeTcl_fp = NULL;
    }
}


InitUnrestricted(generic)
int generic;
{
    if (generic) {
        /* Still need to define the library, etc. */
        char *libDir = getenv("TK_LIBRARY");
        if (libDir == NULL) {
            libDir = TK_LIBRARY;
        }
        Tcl_SetVar(unrestricted_interp, "tk_library", libDir, TCL_GLOBAL_ONLY);
        Tcl_SetVar(unrestricted_interp, "tk_version", TK_VERSION, TCL_GLOBAL_ONLY);
        Tcl_SetVar(unrestricted_interp, "tkVersion", TK_VERSION, TCL_GLOBAL_ONLY);
	Tcl_Eval(unrestricted_interp, "wm withdraw .");
    }
    InitTclLibs(unrestricted_interp);
#ifdef SAFETCL_INTERFACESTYLE_TK3_6
    InitTkLibs(unrestricted_interp);
#endif /* defined SAFETCL_INTERFACESTYLE_TK3_6 */
}
