# include "stdio.h"
static int start_cond = 0;
#define BEGIN start_cond =
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
# define Z 2
#ifndef	lint
static char ident[] = "@(#)$Id: dtimep.lex,v 2.14 1992/12/15 00:20:22 jromine Exp $";
#endif
#include "tws.h"
#include "../h/strings.h"
#include <ctype.h>
#include <sys/types.h>
#ifndef SYS5
#include <sys/timeb.h>
#endif /* not SYS5 */

#ifdef SYS5
extern int  daylight;
extern long timezone;
extern char *tzname[];
#endif /* SYS5 */

/*
 * Patchable flag that says how to interpret NN/NN/NN dates. When
 * true, we do it European style: DD/MM/YY. When false, we do it
 * American style: MM/DD/YY.  Of course, these are all non-RFC822
 * compliant.
 */
int europeandate = 0;

/*
 * Table to convert month names to numeric month.  We use the
 * fact that the low order 5 bits of the sum of the 2nd & 3rd
 * characters of the name is a hash with no collisions for the 12
 * valid month names.  (The mask to 5 bits maps any combination of
 * upper and lower case into the same hash value).
 */
static	int month_map[] = {
	0,
	6,	/* 1 - Jul */
	3,	/* 2 - Apr */
	5,	/* 3 - Jun */
	0,
	10,	/* 5 - Nov */
	0,
	1,	/* 7 - Feb */
	11,	/* 8 - Dec */
	0,
	0,
	0,
	0,
	0,
	0,
	0,	/*15 - Jan */
	0,
	0,
	0,
	2,	/*19 - Mar */
	0,
	8,	/*21 - Sep */
	0,
	9,	/*23 - Oct */
	0,
	0,
	4,	/*26 - May */
	0,
	7	/*28 - Aug */
};
/*
 * Same trick for day-of-week using the hash function
 *  (c1 & 7) + (c2 & 4)
 */
static	int day_map[] = {
	0,
	0,
	0,
	6,	/* 3 - Sat */
	4,	/* 4 - Thu */
	0,
	5,	/* 6 - Fri */
	0,	/* 7 - Sun */
	2,	/* 8 - Tue */
	1	/* 9 - Mon */,
	0,
	3	/*11 - Wed */
};
#define SETDAY	{ tw.tw_wday= day_map[(cp[0] & 7) + (cp[1] & 4)];\
		tw.tw_flags &= ~TW_SDAY; tw.tw_flags |= TW_SEXP;\
		cp += 2; }
#define SETMONTH { tw.tw_mon = month_map[(cp[0] + cp[1]) & 0x1f]; gotdate++;\
		 cp += 2;\
		 SKIPD;}
#define	CVT1OR2	(i=(*cp++ - '0'), isdigit(*cp)? i*10 + (*cp++ - '0') : i)
#define	CVT2	  ((cp[0] - '0')*10 + (cp[1] - '0'))
#define	CVT4	((((cp[0] - '0')*10 + (cp[1] - '0'))*10 + \
				      (cp[2] - '0'))*10 + (cp[3] - '0'))
#define SKIPD	{ while ( !isdigit(*cp++) ) ;  --cp; }
#define EXPZONE	{ tw.tw_flags &= ~TW_SZONE; tw.tw_flags |= TW_SZEXP; }
#define ZONE(x)	{ tw.tw_zone=(x); EXPZONE; }
#define ZONED(x) { ZONE(x); tw.tw_flags |= TW_DST; }
#define	LC(c)	(isupper (c) ? tolower (c) : (c))

#ifdef	DSTXXX
#ifdef	_AIX
#include <sys/time.h>
#include <time.h>
#else
#ifndef	BSD42
#include <time.h>
#else	/* BSD42 */
#include <sys/time.h>
#endif	/* BSD42 */
#endif

static	zonehack (tw)
register struct tws *tw;
{
    register struct tm *tm;

    if (twclock (tw) == -1L)
	return;

    tm = localtime (&tw -> tw_clock);
    if (tm -> tm_isdst) {
	tw -> tw_flags |= TW_DST;
	tw -> tw_zone -= 60;
    }
}
#endif	/* DSTXXX */
struct tws *dparsetime (str)
	char *str;
{
	register int i;
	static struct tws tw;
	register char *cp;
	register int gotdate = 0;
#ifndef SYS5
	struct timeb	tb;
#endif /* not SYS5 */
	long tclock;

	start_cond = 0;

	/* Zero out the struct. */
	bzero( (char *) &tw, sizeof tw);

	/* Set default time zone. */
#ifndef SYS5
	ftime( &tb );
	tw.tw_zone = -tb.timezone;
#else /* SYS5 */
	tzset( );
	tw.tw_zone = -(timezone / 60);
#endif /* SYS5 */

	while (isspace(*str))
		str++;
	while ( 1 )
		switch (cp = str, *cp ? lex_string( &str, start_cond) : 0) {

		case -1:
			if (!gotdate || tw.tw_year == 0)
				return (struct tws *)0;
			/* fall through */
		case 0:
			if ( tw.tw_year == 0 ) {
				/* Set default year. */
				time (&tclock);
				tw.tw_year = localtime(&tclock)->tm_year + 1900;
			}
			else if (tw.tw_year < 100) {
				/* assume no 2-digit years > 1999 */
				tw.tw_year += 1900;
			}
			return &tw;

case 1:
			SETDAY;
break;
case 2:
		{
					cp++;
					SETDAY;
					}
break;
case 3:
{
					if (europeandate) {
						/* European: DD/MM/YY */
						tw.tw_mday = CVT1OR2;
						cp++;
						tw.tw_mon  = CVT1OR2 - 1;
					} else {
						/* American: MM/DD/YY */
						tw.tw_mon  = CVT1OR2 - 1;
						cp++;
						tw.tw_mday = CVT1OR2;
					}
					cp++;
					for (i = 0; isdigit(*cp); )
						i = i*10 + (*cp++ - '0');
					tw.tw_year = i;
					gotdate++;	/* XXX */
					}
break;
case 4:
		{
					if (europeandate) {
						tw.tw_mday = CVT1OR2; cp++;
						tw.tw_mon  = CVT1OR2 - 1;
					} else {
						tw.tw_mon = CVT1OR2 - 1; cp++;
						tw.tw_mday  = CVT1OR2;
					}
					gotdate++;
					}
break;
case 5:
{
					tw.tw_mday = CVT1OR2;
					while ( !isalpha(*cp++) )
						;
					SETMONTH;
					for (i = 0; isdigit(*cp); )
						i = i*10 + (*cp++ - '0');
					tw.tw_year = i;
					}
break;
case 6:
              {
                                        tw.tw_mday = CVT1OR2;
                                        while ( ! isalpha( *cp++ ) )
                                                ;
                                        SETMONTH;
                                        }
break;
case 7:
{
					cp++;
					SETMONTH;
					tw.tw_mday = CVT1OR2;
					SKIPD;
					for (i = 0; isdigit(*cp); )
						i = i*10 + (*cp++ - '0');
					tw.tw_year = i;
					}
break;
case 8:
		{
					cp++;
					SETMONTH;
					tw.tw_mday = CVT1OR2;
					}
break;
case 9:
	{	/* hack: ctime w/o TZ */
					tw.tw_hour = CVT1OR2; cp++;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					SKIPD;
					tw.tw_year = CVT4; cp+=4;
					}
break;
case 10:
			{
					tw.tw_hour = CVT1OR2; cp++;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 11:
			{
					tw.tw_hour = CVT1OR2; cp++;
					tw.tw_min = CVT1OR2;
					BEGIN Z;
					}
break;
case 12:
			{
					tw.tw_hour = CVT1OR2; cp++;
					if (tw.tw_hour == 12)
						tw.tw_hour = 0;
					tw.tw_min  = CVT1OR2;
					BEGIN Z;
					}
break;
case 13:
		{
					tw.tw_hour = CVT1OR2; cp++;
					if (tw.tw_hour == 12)
						tw.tw_hour = 0;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 14:
			{
					tw.tw_hour = CVT1OR2; cp++;
					if (tw.tw_hour != 12)
						tw.tw_hour += 12;
					tw.tw_min  = CVT1OR2;
					BEGIN Z;
					}
break;
case 15:
		{
					tw.tw_hour = CVT1OR2; cp++;
					if (tw.tw_hour != 12)
						tw.tw_hour += 12;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 16:
		{
					tw.tw_hour = CVT2; cp+=2;
					tw.tw_min  = CVT2; cp+=2;
					tw.tw_sec  = CVT2; cp+=2;
					BEGIN Z;
					}
break;
case 17:
			{
					/*
					 * Luckly, 4 digit times in the range
					 * 1960-1999 aren't legal as hour
					 * and minutes.
					 */
					tw.tw_year = CVT4; cp+=4;
					}
break;
case 18:
		{
					if (tw.tw_hour || tw.tw_min 
							    || tw.tw_sec) {
					    tw.tw_year = CVT4; cp+=4;
					    tw.tw_zone = 0;
					} else {
					    tw.tw_hour = CVT2; cp+=2;
					    tw.tw_min  = CVT2; cp+=2;
					    BEGIN Z;
					}
					}
break;
case 19:
			ZONE(0 * 60);
break;
case 20:
			ZONE(0 * 60);
break;
case 21:
			ZONE(2 * 60);
break;
case 22:
			ZONED(2 * 60);
break;
case 23:
			ZONE(-5 * 60);
break;
case 24:
			ZONED(-5 * 60);
break;
case 25:
			ZONE(-6 * 60);
break;
case 26:
			ZONED(-6 * 60);
break;
case 27:
			ZONE(-7 * 60);
break;
case 28:
			ZONED(-7 * 60);
break;
case 29:
			ZONE(-8 * 60);
break;
case 30:
			ZONED(-8 * 60);
break;
case 31:
			ZONE(-(3 * 60 + 30));
break;
case 32:
			ZONE(-4 * 60);
break;
case 33:
			ZONED(-4 * 60);
break;
case 34:
			ZONE(-9 * 60);
break;
case 35:
			ZONED(-9 * 60);
break;
case 36:
			ZONE(-10 * 60);
break;
case 37:
			ZONED(-10 * 60);
break;
case 38:
			ZONED(-1 * 60);
break;
case 39:
			{
					tw.tw_zone = 60 * (('a'-1) - LC(*cp));
					EXPZONE; 
					}
break;
case 40:
			{
					tw.tw_zone = 60 * ('a' - LC(*cp));
					EXPZONE; 
					}
break;
case 41:
			{
					tw.tw_zone = 60 * (LC(*cp) - 'm');
					EXPZONE; 
					}
break;
case 42:
		{
					cp++;
					tw.tw_zone = ((cp[0] * 10 + cp[1])
						     -('0' * 10   + '0'))*60
						    +((cp[2] * 10 + cp[3])
						     -('0' * 10   + '0'));
					EXPZONE;
#ifdef	DSTXXX
					zonehack (&tw);
#endif	/* DSTXXX */
					cp += 4;
					}
break;
case 43:
		{
					cp++;
					tw.tw_zone = (('0' * 10   + '0')
						     -(cp[0] * 10 + cp[1]))*60
						    +(('0' * 10   + '0')
						     -(cp[2] * 10 + cp[3]));
					EXPZONE;
#ifdef	DSTXXX
					zonehack (&tw);
#endif	/* DSTXXX */
					cp += 4;
					}
break;
case 44:
		{
					SKIPD;
					tw.tw_year = CVT4; cp+=4;
					}
break;
case 45:
case 46:
;
break;
default: return(0);
} }
/* end of yylex */
int yyvstop[] = {
0,

46,
0,

45,
0,

46,
0,

39,
0,

39,
0,

39,
0,

39,
0,

39,
0,

39,
0,

39,
0,

39,
0,

39,
0,

40,
0,

40,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

41,
0,

19,
0,

4,
0,

4,
0,

11,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

33,
0,

32,
0,

38,
0,

26,
0,

25,
0,

24,
0,

23,
0,

20,
0,

37,
0,

36,
0,

22,
0,

21,
0,

28,
0,

27,
0,

31,
0,

30,
0,

29,
0,

35,
0,

34,
0,

4,
0,

4,
0,

4,
0,

18,
0,

11,
0,

11,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

17,
18,
0,

1,
0,

2,
0,

18,
0,

10,
0,

12,
0,

14,
0,

6,
0,

17,
18,
0,

8,
0,

44,
0,

42,
0,

43,
0,

2,
0,

3,
0,

16,
0,

10,
0,

10,
0,

5,
0,

8,
0,

8,
0,

1,
0,

3,
0,

3,
0,

13,
0,

15,
0,

6,
0,

5,
0,

5,
0,

5,
0,

5,
0,

7,
0,

9,
0,

7,
0,

7,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,5,	1,6,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,5,	0,0,	0,0,	
3,21,	3,6,	5,5,	0,0,	
0,0,	1,7,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,8,	1,9,	1,8,	
1,10,	1,10,	1,10,	1,10,	
1,10,	1,10,	1,10,	3,21,	
0,0,	5,5,	0,0,	0,0,	
0,0,	0,0,	0,0,	3,7,	
0,0,	0,0,	3,22,	0,0,	
3,23,	0,0,	0,0,	3,8,	
3,9,	3,8,	3,10,	3,10,	
3,10,	3,10,	3,10,	3,10,	
3,10,	9,63,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
22,83,	22,83,	1,11,	0,0,	
0,0,	1,12,	0,0,	1,13,	
0,0,	0,0,	0,0,	1,14,	
0,0,	0,0,	1,15,	1,16,	
1,17,	0,0,	0,0,	0,0,	
1,18,	1,19,	0,0,	0,0,	
1,20,	0,0,	0,0,	0,0,	
3,24,	3,25,	3,26,	3,27,	
3,28,	3,29,	3,30,	3,31,	
3,32,	3,33,	3,34,	3,34,	
3,35,	3,36,	3,37,	3,38,	
3,39,	3,39,	3,40,	3,41,	
3,42,	3,39,	3,43,	3,39,	
3,44,	7,45,	8,50,	12,67,	
11,65,	16,74,	13,68,	14,70,	
7,46,	11,66,	15,72,	17,75,	
18,76,	19,79,	7,47,	7,48,	
18,77,	20,81,	7,49,	13,69,	
25,99,	30,104,	42,114,	45,117,	
15,73,	8,50,	19,80,	14,71,	
46,118,	21,21,	36,74,	49,123,	
18,78,	47,119,	36,111,	56,139,	
23,84,	23,84,	8,51,	26,100,	
8,52,	8,53,	8,53,	8,53,	
8,53,	8,53,	8,53,	8,53,	
8,53,	8,53,	8,53,	8,54,	
21,21,	47,120,	26,101,	55,137,	
57,140,	59,143,	60,144,	61,145,	
55,138,	62,146,	65,148,	66,149,	
28,102,	31,105,	24,97,	38,112,	
21,82,	21,82,	21,82,	21,82,	
21,82,	21,82,	21,82,	21,82,	
21,82,	21,82,	24,65,	28,103,	
31,106,	24,98,	38,113,	24,66,	
67,150,	23,85,	23,86,	23,87,	
48,121,	23,88,	8,55,	23,89,	
23,90,	8,56,	23,91,	8,57,	
44,115,	23,92,	23,93,	8,58,	
23,94,	48,122,	8,59,	8,60,	
8,61,	23,95,	50,50,	33,70,	
8,62,	23,96,	33,107,	44,116,	
35,72,	68,151,	69,152,	35,109,	
70,153,	71,154,	73,158,	71,155,	
74,159,	58,141,	51,124,	75,160,	
76,161,	33,108,	35,73,	33,71,	
77,162,	50,50,	35,110,	52,134,	
52,134,	52,134,	52,134,	52,134,	
52,134,	52,134,	52,134,	52,134,	
52,134,	58,142,	50,124,	78,163,	
79,164,	51,124,	53,135,	53,135,	
53,135,	53,135,	53,135,	53,135,	
53,135,	53,135,	53,135,	53,135,	
80,165,	81,166,	93,111,	97,170,	
98,171,	51,133,	51,133,	51,133,	
51,133,	51,133,	51,133,	51,133,	
51,133,	51,133,	51,133,	54,136,	
54,136,	54,136,	54,136,	54,136,	
54,136,	54,136,	54,136,	54,136,	
54,136,	63,135,	63,135,	63,135,	
63,135,	63,135,	63,135,	63,147,	
63,147,	63,147,	63,147,	64,50,	
99,172,	72,156,	50,125,	100,173,	
85,97,	50,126,	101,174,	50,127,	
72,157,	91,107,	92,109,	50,128,	
102,175,	103,176,	50,129,	50,130,	
50,131,	104,177,	51,55,	85,98,	
50,132,	51,56,	64,50,	51,57,	
91,108,	92,110,	105,178,	51,58,	
106,179,	107,180,	51,59,	51,60,	
51,61,	108,181,	109,182,	64,51,	
51,62,	64,52,	82,167,	82,167,	
82,167,	82,167,	82,167,	82,167,	
82,167,	82,167,	82,167,	82,167,	
64,54,	83,168,	83,168,	83,168,	
83,168,	83,168,	83,168,	83,168,	
83,168,	83,168,	83,168,	84,169,	
84,169,	84,169,	84,169,	84,169,	
84,169,	84,169,	84,169,	84,169,	
84,169,	110,183,	111,184,	112,185,	
113,186,	115,187,	116,188,	117,189,	
118,190,	119,191,	120,192,	121,193,	
122,194,	123,195,	126,198,	124,124,	
125,196,	127,199,	129,202,	64,55,	
128,200,	125,197,	64,56,	130,203,	
64,57,	131,204,	132,205,	133,206,	
64,58,	137,216,	138,217,	64,59,	
64,60,	64,61,	139,218,	140,219,	
141,220,	64,62,	124,124,	134,206,	
128,201,	142,221,	143,223,	142,222,	
144,225,	145,226,	146,227,	153,236,	
155,157,	143,224,	133,206,	135,210,	
135,210,	135,210,	135,210,	135,210,	
135,210,	135,210,	135,210,	135,210,	
135,210,	158,238,	134,206,	133,207,	
159,239,	160,240,	133,208,	133,208,	
133,208,	133,208,	133,208,	133,208,	
133,208,	133,208,	133,208,	133,208,	
148,229,	134,207,	134,209,	134,209,	
134,209,	134,209,	134,209,	134,209,	
134,209,	134,209,	134,209,	134,209,	
136,211,	147,228,	147,228,	147,228,	
147,228,	147,228,	147,228,	147,228,	
147,228,	147,228,	147,228,	148,229,	
149,229,	150,229,	151,229,	124,125,	
162,242,	163,243,	124,126,	189,250,	
124,127,	190,252,	192,254,	136,211,	
124,128,	196,258,	191,250,	124,129,	
124,130,	124,131,	152,234,	154,229,	
156,229,	124,132,	157,229,	149,229,	
150,229,	151,229,	161,234,	136,212,	
136,212,	136,212,	136,212,	136,212,	
136,212,	136,212,	136,212,	136,212,	
136,212,	136,213,	197,259,	164,234,	
165,234,	152,234,	154,229,	156,229,	
166,234,	157,229,	198,260,	199,261,	
193,250,	161,234,	194,250,	200,262,	
202,265,	152,234,	195,250,	201,263,	
203,267,	201,264,	204,268,	202,266,	
205,269,	161,234,	164,234,	165,234,	
208,207,	209,207,	189,251,	166,234,	
212,213,	206,206,	214,274,	215,275,	
148,230,	220,283,	164,234,	165,234,	
136,214,	222,224,	225,285,	166,234,	
167,247,	167,247,	167,247,	167,247,	
167,247,	167,247,	167,247,	167,247,	
167,247,	167,247,	191,253,	136,215,	
206,206,	150,232,	168,248,	168,248,	
168,248,	168,248,	168,248,	168,248,	
168,248,	168,248,	168,248,	168,248,	
211,211,	226,286,	227,287,	151,233,	
149,231,	152,235,	156,237,	169,249,	
169,249,	169,249,	169,249,	169,249,	
169,249,	169,249,	169,249,	169,249,	
169,249,	193,255,	230,157,	195,257,	
194,256,	231,290,	232,291,	211,211,	
233,292,	235,293,	236,294,	154,157,	
237,157,	238,295,	161,241,	210,271,	
239,296,	240,297,	241,298,	242,299,	
243,300,	244,301,	245,302,	246,303,	
164,244,	166,246,	165,245,	207,270,	
207,270,	207,270,	207,270,	207,270,	
207,270,	207,270,	207,270,	207,270,	
207,270,	250,307,	210,271,	213,273,	
213,273,	213,273,	213,273,	213,273,	
213,273,	213,273,	213,273,	213,273,	
213,273,	251,308,	216,276,	228,288,	
234,234,	252,309,	210,272,	210,272,	
210,272,	210,272,	210,272,	210,272,	
210,272,	210,272,	210,272,	210,272,	
253,310,	217,276,	254,311,	255,312,	
256,313,	257,314,	276,330,	279,224,	
211,214,	216,276,	228,288,	234,234,	
258,266,	260,266,	280,332,	218,276,	
265,266,	281,333,	282,334,	283,335,	
284,224,	285,336,	216,277,	211,215,	
217,276,	216,278,	216,278,	216,278,	
216,278,	216,278,	216,278,	216,278,	
216,278,	216,278,	216,278,	258,266,	
260,266,	217,277,	218,276,	265,266,	
217,278,	217,278,	217,278,	217,278,	
217,278,	217,278,	217,278,	217,278,	
217,278,	217,278,	219,276,	218,277,	
259,266,	286,337,	218,278,	218,278,	
218,278,	218,278,	218,278,	218,278,	
218,278,	218,278,	218,278,	218,278,	
264,266,	263,266,	287,338,	290,157,	
291,342,	292,343,	293,344,	294,345,	
296,346,	219,276,	297,347,	259,266,	
221,276,	266,266,	271,271,	298,348,	
274,274,	262,266,	216,279,	299,349,	
301,350,	302,351,	219,277,	264,266,	
263,266,	219,278,	219,278,	219,278,	
219,278,	219,278,	219,278,	219,278,	
219,278,	219,278,	219,278,	221,276,	
266,266,	271,271,	223,276,	274,274,	
262,266,	260,317,	265,320,	218,281,	
258,315,	217,280,	275,275,	303,352,	
221,277,	288,288,	308,353,	221,278,	
221,278,	221,278,	221,278,	221,278,	
221,278,	221,278,	221,278,	221,278,	
221,278,	223,276,	310,354,	312,355,	
224,276,	261,266,	268,266,	267,266,	
313,356,	275,275,	269,266,	314,357,	
288,288,	315,266,	223,277,	229,229,	
316,358,	223,278,	223,278,	223,278,	
223,278,	223,278,	223,278,	223,278,	
223,278,	223,278,	223,278,	224,276,	
261,266,	268,266,	267,266,	219,282,	
264,266,	269,266,	317,359,	318,360,	
259,316,	319,361,	229,229,	320,266,	
224,277,	321,362,	322,363,	224,278,	
224,278,	224,278,	224,278,	224,278,	
224,278,	224,278,	224,278,	224,278,	
224,278,	263,266,	229,289,	229,289,	
229,289,	229,289,	229,289,	229,289,	
229,289,	229,289,	229,289,	229,289,	
221,224,	262,319,	323,364,	328,368,	
223,284,	247,304,	247,304,	247,304,	
247,304,	247,304,	247,304,	247,304,	
247,304,	247,304,	247,304,	248,305,	
248,305,	248,305,	248,305,	248,305,	
248,305,	248,305,	248,305,	248,305,	
248,305,	249,306,	249,306,	249,306,	
249,306,	249,306,	249,306,	249,306,	
249,306,	249,306,	249,306,	267,321,	
329,369,	330,370,	332,224,	333,373,	
334,374,	335,375,	336,376,	337,377,	
268,322,	338,378,	261,318,	341,340,	
342,380,	343,381,	344,234,	273,326,	
325,325,	269,323,	270,324,	270,324,	
270,324,	270,324,	270,324,	270,324,	
270,324,	270,324,	270,324,	270,324,	
272,325,	272,325,	272,325,	272,325,	
272,325,	272,325,	272,325,	272,325,	
272,325,	272,325,	273,326,	325,325,	
345,157,	277,277,	278,331,	278,331,	
278,331,	278,331,	278,331,	278,331,	
278,331,	278,331,	278,331,	278,331,	
324,365,	339,339,	273,327,	273,327,	
273,327,	273,327,	273,327,	273,327,	
273,327,	273,327,	273,327,	273,327,	
277,277,	346,382,	347,157,	289,339,	
348,383,	349,384,	350,385,	352,386,	
353,250,	354,387,	355,388,	324,365,	
339,339,	357,389,	358,266,	359,390,	
277,278,	277,278,	277,278,	277,278,	
277,278,	277,278,	277,278,	277,278,	
277,278,	277,278,	289,339,	324,366,	
324,366,	324,366,	324,366,	324,366,	
324,366,	324,366,	324,366,	324,366,	
324,366,	326,326,	289,340,	273,328,	
327,326,	331,371,	289,341,	289,341,	
289,341,	289,341,	289,341,	289,341,	
289,341,	289,341,	289,341,	289,341,	
340,379,	360,391,	273,329,	361,392,	
362,393,	363,394,	364,395,	367,396,	
326,326,	373,399,	374,400,	327,326,	
331,371,	375,224,	376,401,	365,365,	
377,224,	378,402,	384,404,	386,405,	
389,406,	390,407,	391,408,	340,379,	
392,266,	326,367,	368,368,	369,369,	
331,372,	331,372,	331,372,	331,372,	
331,372,	331,372,	331,372,	331,372,	
331,372,	331,372,	365,365,	366,365,	
366,365,	366,365,	366,365,	366,365,	
366,365,	366,365,	366,365,	366,365,	
366,365,	368,368,	369,369,	370,370,	
371,371,	372,398,	372,398,	372,398,	
372,398,	372,398,	372,398,	372,398,	
372,398,	372,398,	372,398,	379,379,	
393,409,	394,266,	395,410,	396,411,	
396,411,	396,411,	396,411,	397,412,	
398,371,	326,328,	370,370,	371,371,	
327,328,	402,413,	410,415,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	379,379,	0,0,	
326,329,	0,0,	0,0,	327,329,	
0,0,	0,0,	0,0,	398,371,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	379,403,	379,403,	
379,403,	379,403,	379,403,	379,403,	
379,403,	379,403,	379,403,	379,403,	
403,414,	403,414,	403,414,	403,414,	
403,414,	403,414,	403,414,	403,414,	
403,414,	403,414,	411,416,	411,416,	
411,416,	411,416,	411,416,	411,416,	
411,416,	411,416,	411,416,	411,416,	
412,412,	414,417,	417,417,	0,0,	
0,0,	0,0,	0,0,	0,0,	
371,397,	418,417,	418,417,	418,417,	
418,417,	418,417,	418,417,	418,417,	
418,417,	418,417,	418,417,	0,0,	
0,0,	0,0,	0,0,	412,412,	
414,417,	417,417,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
414,418,	414,418,	414,418,	414,418,	
414,418,	414,418,	414,418,	414,418,	
414,418,	414,418,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+27,	0,		0,	
yycrank+0,	yysvec+3,	0,	
yycrank+29,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+47,	0,		0,	
yycrank+141,	0,		0,	
yycrank+28,	yysvec+8,	0,	
yycrank+38,	yysvec+8,	0,	
yycrank+40,	0,		0,	
yycrank+50,	0,		0,	
yycrank+53,	0,		0,	
yycrank+58,	0,		0,	
yycrank+61,	0,		0,	
yycrank+42,	0,		0,	
yycrank+60,	0,		0,	
yycrank+63,	0,		0,	
yycrank+57,	0,		0,	
yycrank+64,	0,		0,	
yycrank+168,	0,		yyvstop+5,
yycrank+48,	0,		0,	
yycrank+136,	0,		0,	
yycrank+114,	0,		yyvstop+7,
yycrank+53,	0,		yyvstop+9,
yycrank+87,	0,		yyvstop+11,
yycrank+0,	yysvec+12,	yyvstop+13,
yycrank+112,	0,		yyvstop+15,
yycrank+0,	yysvec+13,	yyvstop+17,
yycrank+60,	0,		yyvstop+19,
yycrank+113,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+23,
yycrank+158,	0,		0,	
yycrank+0,	0,		yyvstop+25,
yycrank+163,	0,		yyvstop+27,
yycrank+67,	0,		yyvstop+29,
yycrank+0,	yysvec+17,	yyvstop+31,
yycrank+115,	0,		yyvstop+33,
yycrank+0,	0,		yyvstop+35,
yycrank+0,	yysvec+18,	yyvstop+37,
yycrank+0,	yysvec+19,	yyvstop+39,
yycrank+54,	0,		yyvstop+41,
yycrank+0,	yysvec+20,	yyvstop+43,
yycrank+144,	0,		yyvstop+45,
yycrank+57,	0,		0,	
yycrank+65,	0,		0,	
yycrank+84,	0,		0,	
yycrank+132,	0,		0,	
yycrank+78,	0,		0,	
yycrank+245,	0,		0,	
yycrank+261,	0,		0,	
yycrank+231,	0,		0,	
yycrank+246,	yysvec+8,	0,	
yycrank+271,	0,		0,	
yycrank+91,	0,		0,	
yycrank+82,	0,		0,	
yycrank+103,	0,		0,	
yycrank+172,	0,		0,	
yycrank+108,	0,		0,	
yycrank+95,	0,		0,	
yycrank+108,	0,		0,	
yycrank+108,	0,		0,	
yycrank+281,	yysvec+8,	0,	
yycrank+330,	0,		0,	
yycrank+96,	0,		0,	
yycrank+108,	0,		0,	
yycrank+133,	0,		0,	
yycrank+163,	0,		0,	
yycrank+157,	0,		0,	
yycrank+154,	0,		0,	
yycrank+157,	0,		0,	
yycrank+227,	0,		0,	
yycrank+156,	0,		0,	
yycrank+150,	0,		0,	
yycrank+155,	0,		0,	
yycrank+156,	0,		0,	
yycrank+164,	0,		0,	
yycrank+181,	0,		0,	
yycrank+175,	0,		0,	
yycrank+203,	0,		0,	
yycrank+205,	0,		0,	
yycrank+330,	0,		0,	
yycrank+341,	0,		0,	
yycrank+351,	0,		0,	
yycrank+244,	0,		0,	
yycrank+0,	yysvec+25,	0,	
yycrank+0,	yysvec+26,	0,	
yycrank+0,	yysvec+28,	0,	
yycrank+0,	yysvec+30,	0,	
yycrank+0,	yysvec+31,	0,	
yycrank+249,	0,		0,	
yycrank+250,	0,		0,	
yycrank+191,	0,		0,	
yycrank+0,	yysvec+38,	0,	
yycrank+0,	yysvec+42,	0,	
yycrank+0,	yysvec+44,	0,	
yycrank+191,	0,		0,	
yycrank+192,	0,		0,	
yycrank+224,	0,		0,	
yycrank+227,	0,		0,	
yycrank+230,	0,		0,	
yycrank+236,	0,		0,	
yycrank+237,	0,		0,	
yycrank+241,	0,		0,	
yycrank+250,	0,		0,	
yycrank+252,	0,		0,	
yycrank+253,	0,		0,	
yycrank+257,	0,		0,	
yycrank+258,	0,		0,	
yycrank+293,	0,		0,	
yycrank+294,	0,		0,	
yycrank+295,	0,		0,	
yycrank+296,	0,		0,	
yycrank+0,	0,		yyvstop+47,
yycrank+297,	0,		0,	
yycrank+298,	0,		0,	
yycrank+310,	0,		0,	
yycrank+306,	0,		0,	
yycrank+301,	0,		0,	
yycrank+308,	0,		0,	
yycrank+302,	0,		0,	
yycrank+319,	0,		0,	
yycrank+321,	0,		0,	
yycrank+414,	0,		0,	
yycrank+312,	0,		0,	
yycrank+321,	0,		0,	
yycrank+324,	0,		0,	
yycrank+331,	0,		0,	
yycrank+329,	0,		0,	
yycrank+320,	0,		0,	
yycrank+334,	0,		0,	
yycrank+333,	0,		0,	
yycrank+426,	0,		yyvstop+49,
yycrank+438,	0,		yyvstop+51,
yycrank+411,	0,		0,	
yycrank+487,	0,		yyvstop+53,
yycrank+323,	0,		0,	
yycrank+335,	0,		0,	
yycrank+343,	0,		0,	
yycrank+345,	0,		0,	
yycrank+334,	0,		0,	
yycrank+341,	0,		0,	
yycrank+336,	0,		0,	
yycrank+334,	0,		0,	
yycrank+337,	0,		0,	
yycrank+342,	0,		0,	
yycrank+449,	0,		0,	
yycrank+475,	0,		0,	
yycrank+499,	0,		0,	
yycrank+500,	0,		0,	
yycrank+501,	0,		0,	
yycrank+517,	0,		yyvstop+55,
yycrank+338,	yysvec+149,	0,	
yycrank+518,	0,		0,	
yycrank+355,	yysvec+150,	0,	
yycrank+519,	0,		0,	
yycrank+521,	0,		0,	
yycrank+369,	yysvec+152,	yyvstop+57,
yycrank+371,	yysvec+150,	0,	
yycrank+362,	yysvec+157,	0,	
yycrank+525,	0,		yyvstop+59,
yycrank+396,	yysvec+157,	0,	
yycrank+413,	yysvec+152,	yyvstop+61,
yycrank+538,	0,		yyvstop+63,
yycrank+539,	0,		yyvstop+65,
yycrank+543,	0,		yyvstop+67,
yycrank+540,	0,		0,	
yycrank+554,	0,		0,	
yycrank+571,	0,		0,	
yycrank+0,	0,		yyvstop+69,
yycrank+0,	0,		yyvstop+71,
yycrank+0,	0,		yyvstop+73,
yycrank+0,	0,		yyvstop+75,
yycrank+0,	0,		yyvstop+77,
yycrank+0,	0,		yyvstop+79,
yycrank+0,	0,		yyvstop+81,
yycrank+0,	0,		yyvstop+83,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+89,
yycrank+0,	0,		yyvstop+91,
yycrank+0,	0,		yyvstop+93,
yycrank+0,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+103,
yycrank+0,	0,		yyvstop+105,
yycrank+474,	0,		0,	
yycrank+417,	yysvec+189,	0,	
yycrank+481,	0,		0,	
yycrank+418,	yysvec+189,	0,	
yycrank+515,	0,		0,	
yycrank+517,	0,		0,	
yycrank+521,	0,		0,	
yycrank+407,	0,		0,	
yycrank+443,	0,		0,	
yycrank+455,	0,		0,	
yycrank+457,	0,		0,	
yycrank+449,	0,		0,	
yycrank+455,	0,		0,	
yycrank+446,	0,		0,	
yycrank+446,	0,		0,	
yycrank+450,	0,		0,	
yycrank+456,	0,		0,	
yycrank+568,	0,		yyvstop+107,
yycrank+607,	0,		0,	
yycrank+527,	yysvec+206,	yyvstop+109,
yycrank+526,	yysvec+206,	yyvstop+111,
yycrank+634,	0,		yyvstop+113,
yycrank+603,	0,		yyvstop+115,
yycrank+518,	yysvec+211,	yyvstop+117,
yycrank+619,	0,		0,	
yycrank+469,	0,		0,	
yycrank+470,	0,		0,	
yycrank+669,	0,		yyvstop+119,
yycrank+684,	0,		yyvstop+121,
yycrank+698,	0,		yyvstop+123,
yycrank+733,	0,		yyvstop+125,
yycrank+464,	yysvec+217,	yyvstop+127,
yycrank+759,	0,		yyvstop+129,
yycrank+484,	yysvec+218,	yyvstop+131,
yycrank+785,	0,		yyvstop+133,
yycrank+811,	0,		yyvstop+135,
yycrank+485,	yysvec+218,	yyvstop+137,
yycrank+502,	yysvec+224,	yyvstop+139,
yycrank+498,	yysvec+224,	yyvstop+141,
yycrank+670,	yysvec+210,	yyvstop+143,
yycrank+822,	0,		0,	
yycrank+522,	0,		0,	
yycrank+518,	0,		0,	
yycrank+525,	0,		0,	
yycrank+519,	0,		0,	
yycrank+671,	0,		yyvstop+146,
yycrank+540,	0,		0,	
yycrank+541,	0,		0,	
yycrank+536,	0,		0,	
yycrank+544,	0,		0,	
yycrank+535,	0,		0,	
yycrank+547,	0,		0,	
yycrank+532,	0,		0,	
yycrank+546,	0,		0,	
yycrank+551,	0,		0,	
yycrank+534,	0,		0,	
yycrank+550,	0,		0,	
yycrank+550,	0,		0,	
yycrank+837,	0,		0,	
yycrank+847,	0,		0,	
yycrank+857,	0,		0,	
yycrank+621,	0,		yyvstop+148,
yycrank+580,	0,		0,	
yycrank+584,	0,		0,	
yycrank+578,	0,		0,	
yycrank+597,	0,		0,	
yycrank+580,	0,		0,	
yycrank+596,	0,		0,	
yycrank+596,	0,		0,	
yycrank+695,	yysvec+216,	0,	
yycrank+735,	yysvec+217,	0,	
yycrank+696,	yysvec+218,	0,	
yycrank+812,	yysvec+219,	0,	
yycrank+764,	yysvec+217,	0,	
yycrank+748,	yysvec+221,	0,	
yycrank+747,	yysvec+218,	0,	
yycrank+699,	yysvec+223,	0,	
yycrank+760,	yysvec+224,	0,	
yycrank+814,	yysvec+218,	0,	
yycrank+813,	yysvec+224,	0,	
yycrank+817,	yysvec+224,	0,	
yycrank+886,	0,		0,	
yycrank+761,	0,		yyvstop+150,
yycrank+896,	0,		0,	
yycrank+922,	0,		yyvstop+152,
yycrank+763,	0,		yyvstop+154,
yycrank+793,	0,		yyvstop+156,
yycrank+601,	yysvec+224,	yyvstop+158,
yycrank+948,	0,		0,	
yycrank+910,	0,		0,	
yycrank+591,	0,		0,	
yycrank+591,	0,		0,	
yycrank+600,	0,		0,	
yycrank+593,	0,		0,	
yycrank+614,	0,		0,	
yycrank+608,	0,		0,	
yycrank+604,	0,		0,	
yycrank+647,	0,		0,	
yycrank+657,	0,		0,	
yycrank+796,	0,		yyvstop+160,
yycrank+974,	0,		yyvstop+163,
yycrank+643,	0,		0,	
yycrank+662,	0,		0,	
yycrank+664,	0,		0,	
yycrank+641,	0,		0,	
yycrank+649,	0,		0,	
yycrank+0,	yysvec+293,	0,	
yycrank+666,	0,		0,	
yycrank+665,	0,		0,	
yycrank+671,	0,		0,	
yycrank+666,	0,		0,	
yycrank+0,	yysvec+293,	0,	
yycrank+676,	0,		0,	
yycrank+680,	0,		0,	
yycrank+688,	0,		0,	
yycrank+0,	0,		yyvstop+165,
yycrank+0,	0,		yyvstop+167,
yycrank+0,	0,		yyvstop+169,
yycrank+0,	0,		yyvstop+171,
yycrank+685,	0,		0,	
yycrank+0,	yysvec+308,	0,	
yycrank+718,	0,		0,	
yycrank+0,	yysvec+308,	0,	
yycrank+719,	0,		0,	
yycrank+727,	0,		0,	
yycrank+712,	0,		0,	
yycrank+721,	0,		0,	
yycrank+717,	0,		0,	
yycrank+741,	0,		0,	
yycrank+734,	0,		0,	
yycrank+756,	0,		0,	
yycrank+751,	0,		0,	
yycrank+748,	0,		0,	
yycrank+760,	0,		0,	
yycrank+781,	0,		0,	
yycrank+959,	0,		yyvstop+173,
yycrank+923,	0,		yyvstop+175,
yycrank+1008,	0,		yyvstop+177,
yycrank+1011,	0,		yyvstop+179,
yycrank+774,	0,		0,	
yycrank+807,	0,		0,	
yycrank+801,	0,		0,	
yycrank+1012,	0,		yyvstop+181,
yycrank+802,	0,		0,	
yycrank+821,	0,		0,	
yycrank+823,	0,		0,	
yycrank+807,	0,		0,	
yycrank+824,	0,		0,	
yycrank+822,	0,		0,	
yycrank+816,	0,		0,	
yycrank+960,	0,		yyvstop+183,
yycrank+1023,	0,		0,	
yycrank+883,	yysvec+339,	yyvstop+185,
yycrank+827,	0,		0,	
yycrank+815,	0,		0,	
yycrank+886,	yysvec+234,	yyvstop+187,
yycrank+835,	0,		0,	
yycrank+880,	0,		0,	
yycrank+868,	0,		0,	
yycrank+887,	0,		0,	
yycrank+887,	0,		0,	
yycrank+889,	0,		0,	
yycrank+0,	yysvec+293,	0,	
yycrank+887,	0,		0,	
yycrank+947,	0,		0,	
yycrank+892,	0,		0,	
yycrank+893,	0,		0,	
yycrank+0,	yysvec+308,	0,	
yycrank+893,	0,		0,	
yycrank+878,	0,		0,	
yycrank+897,	0,		0,	
yycrank+936,	0,		0,	
yycrank+921,	0,		0,	
yycrank+938,	0,		0,	
yycrank+936,	0,		0,	
yycrank+929,	0,		0,	
yycrank+1038,	0,		yyvstop+189,
yycrank+1023,	yysvec+324,	yyvstop+191,
yycrank+982,	0,		0,	
yycrank+1049,	0,		yyvstop+193,
yycrank+1050,	0,		yyvstop+195,
yycrank+1074,	0,		yyvstop+197,
yycrank+1075,	0,		yyvstop+199,
yycrank+1037,	yysvec+331,	yyvstop+201,
yycrank+940,	0,		0,	
yycrank+928,	0,		0,	
yycrank+924,	0,		0,	
yycrank+945,	0,		0,	
yycrank+934,	0,		0,	
yycrank+951,	0,		0,	
yycrank+1086,	0,		0,	
yycrank+0,	yysvec+347,	0,	
yycrank+0,	yysvec+345,	0,	
yycrank+0,	yysvec+347,	0,	
yycrank+0,	yysvec+293,	0,	
yycrank+949,	0,		0,	
yycrank+0,	yysvec+293,	0,	
yycrank+954,	0,		0,	
yycrank+0,	yysvec+308,	0,	
yycrank+0,	yysvec+308,	0,	
yycrank+955,	0,		0,	
yycrank+952,	0,		0,	
yycrank+940,	0,		0,	
yycrank+935,	0,		0,	
yycrank+995,	0,		0,	
yycrank+983,	0,		0,	
yycrank+1000,	0,		0,	
yycrank+1045,	0,		0,	
yycrank+987,	0,		0,	
yycrank+1095,	0,		yyvstop+203,
yycrank+0,	yysvec+377,	0,	
yycrank+0,	yysvec+375,	0,	
yycrank+0,	yysvec+377,	0,	
yycrank+1008,	0,		0,	
yycrank+1096,	0,		0,	
yycrank+0,	yysvec+347,	0,	
yycrank+0,	yysvec+293,	0,	
yycrank+0,	yysvec+308,	0,	
yycrank+0,	yysvec+394,	0,	
yycrank+0,	yysvec+392,	0,	
yycrank+0,	yysvec+394,	0,	
yycrank+1009,	0,		0,	
yycrank+1106,	0,		0,	
yycrank+1155,	0,		yyvstop+205,
yycrank+0,	yysvec+377,	0,	
yycrank+1156,	0,		yyvstop+207,
yycrank+0,	yysvec+394,	0,	
yycrank+0,	0,		yyvstop+209,
yycrank+1157,	0,		yyvstop+211,
yycrank+1125,	yysvec+414,	yyvstop+213,
0,	0,	0};
struct yywork *yytop = yycrank+1213;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'2' ,'3' ,'3' ,'3' ,'6' ,'6' ,
'6' ,'6' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'a' ,'a' ,'a' ,'a' ,'a' ,'a' ,'a' ,
'a' ,'a' ,01  ,'k' ,'k' ,'k' ,'n' ,'n' ,
'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,
'n' ,'n' ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

