# This is the file that gets loaded into the unrestricted interpreter in the Safe-Tcl process

#This procedure keeps a window always visible on the screen
proc keepitup {win what} {
    if {$what == "VisibilityFullyObscured" || $what == "VisibilityPartiallyObscured"} {
        wm withdraw $win ; wm deiconify $win
    } 
}

# The following contains any initialization that must wait until EVERYTHING is loaded
proc init_safe_tcl {}  {
    global configdata env tk_library
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    if {[lsearch $style Tk3.*] >= 0} {
        wm withdraw .
        set lib [restrictedeval set tk_library]
        set configdata(public-library) $lib
    }
    initconfig
    set configdata(external-site) thumper.bellcore.com
    set configdata(external-library) pub/nsb/stlib
    set configdata(private-library) /
    catch "set configdata(private-library) $env(HOME)/.stlib"
# Pick up the user's extensions
    if {[file exists ~/.safetclrc]} {
        uplevel #0 source ~/.safetclrc
    }
    if {[lsearch $style Tk3.*] >= 0} {
        toplevel .guarantee
        button .guarantee.butt -text "Safe-Tcl is Running" -command "safehelp invokemaster"
        pack append .guarantee .guarantee.butt ""
        bind .guarantee <Visibility> "keepitup  .guarantee %s"
    }
}

# The following initializes the "getconfigdata" state.
set configfile "~/.safetcl.conf"
set configtime -1
proc initconfig {} {
    global configfile configdata configtime
    set configdata(initialized) yes
    if { [file readable $configfile] } {
        set ctm [file mtime $configfile]
    } else {
        set ctm -1
    }
    if {$ctm != $configtime} {
        source $configfile
        set configtime $ctm
    }
}

# The following demonstrates how a harmless program defined in full Tcl 
# can be installed in the restricted interpreter
#
#proc foobar {} {puts stdout FOOBAR; echo FOOBAR > /dev/console}
#declareharmless foobar

set WinCtr 0

proc mkwindow {} {
    set wc [expr 1+[restrictedeval set WinCtr]]
    restrictedeval "global WinCtr; incr WinCtr"
    set winname .window$wc
    toplevel $winname
    wm title $winname "Safe-Tcl window $wc"
    button $winname.sAFEBUTT   \
	-command "safehelp invoke" \
	-text {>>> Untrusted program running in Safe-Tcl Interpreter <<<}  
    catch "$winname.sAFEBUTT configure -bg red -fg yellow -activebackground yellow -activeforground red"
     frame $winname.f
    pack append $winname $winname.sAFEBUTT {top} $winname.f {top expand fill}
    return $winname.f
}

proc biglabel {n t ht} {
    if {[string length $t] < 80} {
        return [label $n -text $t]
    }  else {
        frame $n
        text $n.t -wrap word -border 2 -relief raised -height $ht 
        splitlines $t $n.t
        set lines [expr 1+[lindex [split [$n.t index end] .] 0]]
        if {$lines < $ht} {
            $n.t configure -height $lines
            pack append $n $n.t {left expand fill} 
        } else {
            $n.t configure -yscrollcommand "$n.s set"
            scrollbar $n.s -command "$n.t yview"  -relief raised
            pack append $n $n.t {left expand fill} $n.s {right expand filly}
        }
        return $n
    }
}

proc splitlines {t tx} {
    set lastspace 79
    set idx 0
    set start 0
    set len [string length $t]
    while {$idx < $len} {
        set this [string index $t $idx]
        if {$this == "\n"} {
            $tx insert end [string range $t $start $idx]
            set start [expr $idx+1]
            set lastspace [expr $start+79]
        } else {
            if {[expr $idx-$start] > 79} {
                $tx insert end [string range $t $start $lastspace]
                $tx insert end "\n"
                set start $lastspace
                set  lastspace [expr $start+79]
            } else {
                if {$this == " "} {
                    set lastspace $idx
                }
            }
        }
         incr idx
    }
    $tx insert end [string range $t $start $len]
}

proc safehelp {cmd args} {
    if {$cmd == "invoke" || $cmd == "invokemaster"} {
    set w [mkwindow]
    set wpar [string range $w 0 [expr [string length $w]-3]]
    text $w.t -height 12
    if {$cmd == "invokemaster"} {
        $w.t configure -height 16
        $w.t insert 0.0 {The particular window you have clicked on is the MASTER Safe-Tcl window.  
It always keeps itself visible on your screen, to always give you a way to kill 
the Safe-Tcl process if it tries to freeze your screen.}
    }
    $w.t insert 0.0 {The window you have clicked on is executing a program in the 
"Safe-Tcl" programming language.  This language and its interpreter 
have been specially designed to allow the execution of programs from 
untrusted sources, such as program received through electronic mail.
It should not be possible for such programs to do you any harm.  
However, you are advised to be alert to the fact that they might be 
trying to trick you into subverting your system's security, 
for example by asking you for your password and then mailing it 
back to an unfriendly remote user.

In other words, trust this program a little bit less than most.

}
    button $w.b -text "OK" -command "destroy $wpar"
    button $w.b2 -text "Exit Safe-Tcl Interpreter NOW" -command "exit"
    pack append $w $w.t {top} $w.b2 {right} $w.b {top}
}
}
declareharmless safehelp

#DO NOT DELETE THIS LINE BOGON2

proc SafeTcl_displaytext {t} {
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    if {[lsearch $style Tk3.*] >= 0} {
        set n [mkwindow]
        set npar [string range $n 0 [expr [string length $n]-3]]
        text $n.t  -yscrollcommand "$n.s set" -height 12 -relief raised -border 2
        scrollbar $n.s -command "$n.t yview"  -relief raised
        button $n.butt -text {OK}  -command "destroy $npar"
        pack append $n $n.butt bottom $n.t left $n.s {right expand filly}
        $n.t insert 0.0 $t
#        grab $n
#        grab $npar
        focus $n.t
        bind $n.t <Return> "destroy $npar"
        tkwait window $npar
    } else {
        set shown 0
        set chunks [split $t "\n"]
        foreach i $chunks {
            while {[string length $i] > 78} {
                set prt [string range $i 0 77]
                set i [string range $i 78 end]
                puts stdout "$prt"
                incr shown
                if {$shown >20} {
                    if {[pause] == "1"} {return}
                    set shown 0
                }
            }
            puts stdout "$i"
            incr shown
            if {$shown >20} {
                if {[pause] == "1"} {return}
                set shown 0
            }
        }
    }
}
declareharmless SafeTcl_displaytext
proc pause {} {
    puts stdout "-- Press RETURN to see more, or 'q' to skip the remaining output --"
    set foo [string tolower [gets stdin]]
    if {[string index $foo 0] == "q"} {return 1}
    return 0
}
declareharmless pause

proc SafeTcl_displayline {t} {
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    if {[lsearch $style Tk3.*] >= 0} {
        set n [mkwindow]
        set npar [string range $n 0 [expr [string length $n]-3]]
        biglabel $n.bar $t 10
        button $n.butt -text {OK}  -command "destroy $npar"
        pack append $n $n.bar {} $n.butt {}
#        grab $n
        focus $n.bar
        bind $n.bar <Return> "destroy $npar"
        tkwait window $npar
    } else {
        puts stdout $t
    }
}
declareharmless SafeTcl_displayline

proc SafeTcl_getline {prompt args} {
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    set def ""
    if {[llength $args] > 1} {error "Too many arguments to SafeTcl_getline"}
    if {[llength $args] == 1} {set def [lindex $args 0]}
    if {[lsearch $style Tk3.*] >= 0} {
        set n [mkwindow]
        set npar [string range $n 0 [expr [string length $n]-3]]
        biglabel $n.bar $prompt 10
        entry $n.ent -border 2 -relief raised
        $n.ent insert 0 $def
        button $n.butt -text {OK}  -command "destroy $n.butt"
        pack append $n $n.bar {} $n.ent {} $n.butt {}
        focus $n.ent
#        grab $n
        tkwait window $n.butt
        set ANS [$n.ent get]
        destroy $npar
        return $ANS
    } else {
        puts stdout "(The following question is from an untrusted program.)"
        puts stdout $prompt
        if {$def != ""} {puts stdout "Enter a blank line to use the default answer, $def"}
        set f [open /dev/tty]
        gets $f ANS
        if {$ANS == ""} {set ANS $def}
        return $ANS
    }
}
declareharmless SafeTcl_getline

proc SafeTcl_gettext {prompt args} {
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    set def ""
    if {[llength $args] > 1} {error "Too many arguments to SafeTcl_gettext"}
    if {[llength $args] == 1} {set def [lindex $args 0]}
    if {[lsearch $style Tk3.*] >= 0} {
        set n [mkwindow]
        set npar [string range $n 0 [expr [string length $n]-3]]
        biglabel $n.bar $prompt 10
        text $n.txt -border 2 -relief raised
        $n.txt insert 0.0 $def
        button $n.butt -text {OK}  -command "destroy $n.butt"
        pack append $n $n.bar {} $n.txt {} $n.butt {}
        focus $n.txt
#        grab $n
        tkwait window $n.butt
        set ANS [$n.txt get 0.0 end]
        destroy $npar
        return $ANS
    } else {
        puts stdout "(The following question is from an untrusted program.)"
        puts stdout $prompt
        puts stdout "(Enter your answer and then type CONTROL-D)"
        if {$def != ""} {puts stdout "Type CONTROL-D immediately to use the default answer, $def"}
        set f [open /dev/tty]
        set ANS [read $f]
        if {$ANS == ""} {set ANS $def}
        return $ANS
    }
}
declareharmless SafeTcl_gettext

#DO NOT DELETE THIS LINE BOGON3

proc MIME_ConfirmAction {prompt yesstr nostr inspectstr inspectdata} {
    global ANS
    set ANS -1
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    if {[lsearch $style Tk3.*] >= 0} {
        set n [mkwindow]
        set npar [string range $n 0 [expr [string length $n]-3]]
        biglabel $n.label  $prompt 10
        button $n.yes -text $yesstr  -command "global ANS; set ANS 1; destroy $n.label"
        button $n.no -text $nostr  -command "global ANS; set ANS 0; destroy $n.label"
        text $n.t  -yscrollcommand "$n.s set" -height 12 -relief raised -border 2
        $n.t insert 0.0 $inspectdata
        scrollbar $n.s -command "$n.t yview"  -relief raised
        pack append $n $n.label {} $n.no {bottom} $n.yes {bottom} $n.t left $n.s {right expand filly}  
#        grab $n
        tkwait window $n.label
        destroy $npar
        return $ANS
    } else {
        while {1 == 1} {
        puts stdout "(An untrusted program wants to take an action that requires your confirmation.)"
        puts stdout $prompt
        puts stdout "1 -- $yesstr"
        puts stdout "2 -- $nostr"
        puts stdout "3 -- $inspectstr"
        puts stdout "Enter a number from one to 3"
        set f [open /dev/tty]
        gets $f ANS
        if {$ANS == "1"} {return 1}
        if {$ANS == "2"} {return 0}
        if {$ANS == "3"} {
            SafeTcl_displaytext $inspectdata
        } else {
            puts stdout "Unrecognized answer, please try again"
        }
        }
    }
}

# The following is a SafeTcl interface to MIME_sendmessage, which parses 
# the arguments and obtains user confirmation.
# Arguments: -to recipients ?-cc recipients? -subject string  
#		?-auxheader headerName headerValue...? -body bodyPart

proc SafeTcl_sendmessage {args} {
    set lim [llength $args]
    set i 0
    set prev ""
    set to ""
    set cc ""
    set subject ""
    set body ""
    set auxes ""
    set auxgoing 0
    while {$i < $lim} {
        if {$prev == "-to"} {set to  [lindex $args $i]}
        if {$prev == "-cc"} {set cc  [lindex $args $i]}
        if {$prev == "-subject"} {set subject  [lindex $args $i]}
        if {$prev == "-body"} {set body  [lindex $args $i]}
        if {$prev == "-auxheader"} {
            if {$auxgoing == 0} {
                set auxes "${auxes}[lindex $args $i]:"
                set auxgoing 1
            } else {
                set auxes "$auxes [lindex $args $i]\n"
                set auxgoing 0
                set prev ""
            }
        } else {
            set prev [lindex $args $i]
        }
        incr i
    }
    if {$subject == ""} {error "You must supply a -subject argument"}
    if {$to == ""} {error "You must supply a -to argument"}
    if {$body == ""} {error "You must supply a -body argument"}
    if {$cc != ""} {set to "$to, $cc"}
    set autoconf [AutoConfirmMail $to $subject $auxes $body]
    set style [restrictedeval set SafeTcl_InterfaceStyle]
# Check to see if we have a user interface before attempting to get user confirmation
    if {[lindex $style 0] != "" && $autoconf != 1} {
        set autoconf [MIME_ConfirmAction  \
              "This program is attempting to send mail regarding '$subject' to: $to" \
	"Go ahead and send the mail" "Do NOT send the mail"  \
	"Inspect the mail to see what it is"  "To: $to\nSubject: $subject\n$auxes\n$body"]
    }
    if {$autoconf == 1} {
        return [eval MIME_sendmessage $args]
    } else {
        return -1
    }
}

declareharmless SafeTcl_sendmessage

proc AutoConfirmMail {to subject auxes body} {
    set originator ""
    catch {set originator [restrictedeval set SafeTcl_Originator]}
    set style [restrictedeval set SafeTcl_InterfaceStyle]
    if {[lindex $style 0] == ""} {
        if {[info exists originator] && $to == $originator} {
            return 1
        }
    }
    return [AutoConfirmMailHook $to $subject $auxes $body]
}

proc SafeTcl_printtext {txt} {
    set autoconf [AutoConfirmPrint $txt]
    set style [restrictedeval set SafeTcl_InterfaceStyle]
# Check to see if we have a user interface before attempting to get user confirmation
    if {[lindex $style 0] != "" && $autoconf != 1} {
        set autoconf [MIME_ConfirmAction \
              "This program is attempting to send data to the printer." \
	"Go ahead and print the data" "Do NOT print the data"  \
	"Inspect the data to see what it is"  $txt]
    }
    if {$autoconf == 1} {
        return [MIME_printtext $txt]
    } else {
        return -1
    }
}
declareharmless SafeTcl_printtext

proc AutoConfirmPrint {txt} {
    return [AutoConfirmPrintHook $txt]
}

proc SafeTcl_savemessage {destinationtype args} {
    if {[llength $args] > 1} {error "Too many arguments to SafeTcl_savemessage"}
    if {[llength $args] == 1} {
        set dest "The message would be stored in the ${destinationtype} named [lindex $args 0]"
    } else {
        set dest "The message would be stored in your default ${destinationtype}"
    }
    set autoconf [AutoConfirmSave $destinationtype $args]
    set style [restrictedeval set SafeTcl_InterfaceStyle]
# Check to see if we have a user interface before attempting to get user confirmation
    if {[lindex $style 0] != "" && $autoconf != 1} {
        set autoconf [MIME_ConfirmAction \
              "This program is attempting to save the current message in your message store." \
	"Go ahead and save the message" "Do NOT save the message"  \
	"See the details of where it wants to store the message"  $dest]
    }
    if {$autoconf == 1} {
        return [eval MIME_savemessage ${destinationtype} $args]
    } else {
        return -1
    }
}
declareharmless SafeTcl_savemessage
proc AutoConfirmSave {destinationtype args} {
    return [AutoConfirmSaveHook $destinationtype $args]
}

proc writeconfig {} {
    global configdata configfile configtime
    set fid [open $configfile w]
    puts $fid "# AUTOMATICALLY GENERATED -- DO NOT EDIT WHILE SAFE-TCL IS RUNNING"
    set sid [array startsearch configdata]
    set this [array nextelement configdata $sid] 
    while {$this != ""} {
        puts $fid "SafeTcl_setconfigdata \"$this\" \"[set configdata($this)]\""
        set this [array nextelement configdata $sid] 
    }
    array donesearch configdata $sid
    close $fid
    set configtime [file mtime $configfile]
}

proc SafeTcl_getconfigdata {key args} {
    global configdata 
    initconfig
    set evaltime [restrictedeval set SafeTcl_evaluation_time]
    if {[llength $args] > 2} {error "Too many arguments to SafeTcl_getconfigdata"}
    if {[llength $args] == 2} {
        set prompt [lindex $args 1]
    } else {
        set prompt "Enter a configuration value for \"$key\": "
    }
    if {[llength $args] > 0} {
        set def [lindex $args 0]
    } else {
        set def ""
    }
    if {[lsearch [array names configdata] $key] >= 0} {
        if {$evaltime != "activation"} {return $configdata($key)}
        set def $configdata($key)
    }
    if {$evaltime != "activation"} {error "Undefined configdata key: $key"}
    SafeTcl_setconfigdata $key [SafeTcl_gettext $prompt $def]
    writeconfig
    return $configdata($key)
}
declareharmless SafeTcl_getconfigdata

proc SafeTcl_setconfigdata {key val} {
    global configdata
    set configdata($key) $val
    SafeTclP_configdata $key $val
}
declareharmless SafeTcl_setconfigdata

proc SafeTcl_displaybody {ent} {
  MIME_displaybody $ent
}
declareharmless SafeTcl_displaybody

#Default values for "hook" functions that users may override in .safetclrcc
proc AutoConfirmMailHook {to subject auxes body} {
    return 0
# return 1 to automatically confirm mail
}

proc AutoConfirmPrintHook {txt} {
    return 0
# return 1 to automatically confirm printing
}

proc AutoConfirmSaveHook {destinationtype args} {
    return 0
# return 1 to automatically confirm printing
}


