#!/bin/sh
# the next line restarts using the interpreter \
exec tclsh "$0" "$@"

# $Id: instapkg.tcl,v 1.4 1997/06/05 12:11:44 jfontain Exp $

if {[llength $argv]!=1} {
    puts stderr "usage: $argv0 directory"
    exit 1
}

set directory [lindex $argv 0]

if {![file exists $directory]} {
    # make directory
    if {[catch {file mkdir $directory} message]} {
        puts stderr $message
        exit 1
    }
} elseif {[string compare [file type $directory] directory]!=0} {
    puts stderr "file \"$directory\" type is \"[file type $directory]\", not \"directory\""
    exit 1
}

if {[catch {package require stooop 3.0} message]} {
    puts stderr "stooop package must be installed first: $message"
    exit 1
}

if {[catch {eval file copy -force {pkgIndex.tcl scwoop.tcl arrowbut.tcl combobut.tcl comboent.tcl scrolist.tcl scroller.tcl notebook.tcl bindings.tcl labelfra.tcl confint.tcl panner.tcl spinent.tcl widgetip.tcl optimenu.tcl} {$directory}} message]} {
    puts stderr $message
    exit 1
}
