set rcsId {$Id: safeemul.tcl,v 1.11 1996/12/22 13:10:50 jfontain Exp $}

global embed_args
if {[info exists embed_args]} {

# running in the plug-in environment
# transform a toplevel into a safe frame manageable through a safe wm command

proc checkTopLevelDirectDescendant {path} {
    if {([string compare $path .]!=0)&&([string compare [winfo parent $path] [winfo toplevel $path]]!=0)} {
        error "window \"$path\" must be a direct descendant of toplevel \"[winfo toplevel $path]\""
    }
    return $path
}

proc toplevel {args} {
    return [checkTopLevelDirectDescendant [eval frame $args]]
}

proc wm {args} {
    set path [checkTopLevelDirectDescendant [lindex $args 1]]
    switch [lindex $args 0] {
        deiconify {
            # do nothing if already managed
            if {[llength [place info $path]]==0} {
                place $path -width {} -height {}
            }
        }
        geometry {
            set geometry [string trimleft [lindex $args 2] =]
            if {[scan $geometry %dx%d width height]==2} {
                place $path -width $width -height $height
                # remove size header
                regsub {^[0-9]+x[0-9]+} $geometry {} geometry
            }
            if {[scan $geometry %d%d x y]==2} {
                incr x -[winfo rootx [winfo parent $path]]
                incr y -[winfo rooty [winfo parent $path]]
                place $path -bordermode ignore -x $x -y $y
            }
        }
        withdraw {
            place forget $path
        }
    }
}

set grabWindow {}
set grabEvents {
    <ButtonPress> <ButtonPress-1> <ButtonPress-2> <ButtonPress-3> <ButtonRelease> <ButtonRelease-1> <ButtonRelease-2>
    <ButtonRelease-3> <KeyPress> <KeyRelease>
}

proc grab {args} {
    global grabWindow grabEvents

    switch -- [lindex $args 0] {
        current - status {}
        release {
            if {[string compare [lindex $args end] $grabWindow]==0} {
                foreach event $grabEvents {
                    bind all $event {}
                }
                set grabWindow {}
            }
        }
        default {
            # the bindings must exist before the grab for this to work
            set grabWindow [lindex $args end]
            # redirect all input bindings on other windows to grab window
            foreach event $grabEvents {
                set sequence [bind $grabWindow $event]
                if {[string length $sequence]>0} {
                    bind all $event "if {\[string compare %W $grabWindow\]!=0} {eval $sequence}"
                }
            }
        }
    }
}

}
