set rcsId {$Id: scroller.tcl,v 1.19 1997/07/13 12:32:30 jfontain Exp $}

proc minimum {a b} {return [expr {$a<$b?$a:$b}]}

class scroller {}

proc scroller::scroller {this parentPath args} composite {[new frame $parentPath] $args} {
    set path $widget::($this,path)
    composite::manage $this\
        [new canvas $path] canvas [new scrollbar $path -orient horizontal] horizontal [new scrollbar $path] vertical\
        [new frame $path] filler
    widget::configure $composite::($this,canvas)\
        -xscrollcommand "scroller::horizontalScroll $this" -yscrollcommand "scroller::verticalScroll $this"
    widget::configure $composite::($this,horizontal) -command "$composite::($this,canvas,path) xview"
    widget::configure $composite::($this,vertical) -command "$composite::($this,canvas,path) yview"

    grid $composite::($this,canvas,path) -sticky nsew
    grid rowconfigure $path 0 -weight 1
    grid columnconfigure $path 0 -weight 1

    composite::complete $this
}

# displayed widget must be destroyed by user as it may be the path of a scwoop widget, which could be deleted elsewhere
proc scroller::~scroller {this} {}

proc scroller::options {this} {
    return [list\
        [list -height height Height 0 0]\
        [list -width width Width 0 0]\
        [list\
            -xscrollincrement xScrollIncrement ScrollIncrement\
            $widget::(default,CanvasXScrollIncrement) $widget::(default,CanvasXScrollIncrement)\
        ]\
        [list\
            -yscrollincrement yScrollIncrement ScrollIncrement\
            $widget::(default,CanvasYScrollIncrement) $widget::(default,CanvasYScrollIncrement)\
        ]\
    ]
}

proc scroller::display {this path} {
    if {[string length $path]==0} {                                                           ;# undisplay, remove related resources
        $composite::($this,canvas,path) delete all
        catch {unset scroller::($this,displayed) scroller::($this,viewWidth) scroller::($this,viewHeight)}
        return
    }
    if {[info exists scroller::($this,displayed)]} {
        error "scroller \"$this\" already displays widget \"$scroller::($this,displayed)\""
    }
    if {[string compare $widget::($this,path) [winfo parent $path]]!=0} {
        error "displayed widget \"$path\" must be a child of scroller \"$this\" path"
    }
    set scroller::($this,displayed) $path
    raise $path $composite::($this,canvas,path)                  ;# place widget between canvas and scrollbars in the stacking order
    lower $path $composite::($this,horizontal,path)
    $composite::($this,canvas,path) create window 0 0 -window $path -anchor nw
    bind $path <Configure> "scroller::resize $this %w %h"                            ;# handle displayed widget dynamic size changes
    set scroller::($this,viewWidth) 0                                                    ;# make sure sizes are properly initialized
    set scroller::($this,viewHeight) 0
    resize $this [winfo reqwidth $path] [winfo reqheight $path]
}

# if there is a displayed widget, called whenever a scrollbar is moved, so sizes are cached for speed
proc scroller::resize {this width height} {
    if {($width==$scroller::($this,viewWidth))&&($height==$scroller::($this,viewHeight))} {
        return
    }
    set canvas $composite::($this,canvas)
    set scroller::($this,viewWidth) $width
    set scroller::($this,viewHeight) $height
    widget::configure $canvas -scrollregion "0 0 $width $height"
    if {$composite::($this,-width)==0} {                                 ;# adapt to displayed widget width but no wider than screen
        widget::configure $canvas -width [minimum $width [winfo screenwidth $widget::($this,path)]]
    }
    if {$composite::($this,-height)==0} {                              ;# adapt to displayed widget height but no taller than screen
        widget::configure $canvas -height [minimum $height [winfo screenheight $widget::($this,path)]]
    }
}

proc scroller::horizontalScroll {this first last} {
    if {($last-$first)<1} {
        if {[llength [grid info $composite::($this,horizontal,path)]]==0} {
            grid $composite::($this,horizontal,path) -row 1 -sticky nsew
            if {[llength [grid info $composite::($this,vertical,path)]]>0} {   ;# filler is needed since both scrollbars are visible
                grid $composite::($this,filler,path) -sticky nsew -column 1 -row 1
            }
        }
        $composite::($this,horizontal,path) set $first $last
    } else {
        grid forget $composite::($this,horizontal,path)                 ;# no need for a scrollbar since whole dimension can be seen
        grid forget $composite::($this,filler,path)                        ;# filler is only needed when both scrollbars are visible
    }
}

proc scroller::verticalScroll {this first last} {
    if {($last-$first)<1} {
        if {[llength [grid info $composite::($this,vertical,path)]]==0} {
            grid $composite::($this,vertical,path) -column 1 -row 0 -sticky nsew
            if {[llength [grid info $composite::($this,horizontal,path)]]>0} { ;# filler is needed since both scrollbars are visible
                grid $composite::($this,filler,path) -sticky nsew -column 1 -row 1
            }
        }
        $composite::($this,vertical,path) set $first $last
    } else {
        grid forget $composite::($this,vertical,path)                   ;# no need for a scrollbar since whole dimension can be seen
        grid forget $composite::($this,filler,path)                        ;# filler is only needed when both scrollbars are visible
    }
}

proc scroller::set-width {this value} {
    if {[winfo fpixels $widget::($this,path) $value]==0} {
        if {[info exists scroller::($this,displayed)]} {                 ;# adapt to displayed widget width but no wider than screen
            widget::configure $composite::($this,canvas) -width\
                [minimum $scroller::($this,viewWidth) [winfo screenwidth $widget::($this,path)]]
        }
    } else {
        widget::configure $composite::($this,canvas) -width $value
    }
}

proc scroller::set-height {this value} {
    if {[winfo fpixels $widget::($this,path) $value]==0} {
        if {[info exists scroller::($this,displayed)]} {               ;# adapt to displayed widget height but no taller than screen
            widget::configure $composite::($this,canvas) -height\
                [minimum $scroller::($this,viewHeight) [winfo screenheight $widget::($this,path)]]
        }
    } else {
        widget::configure $composite::($this,canvas) -height $value
    }
}

proc scroller::set-xscrollincrement {this value} {
    widget::configure $composite::($this,canvas) -xscrollincrement $value
}

proc scroller::set-yscrollincrement {this value} {
    widget::configure $composite::($this,canvas) -yscrollincrement $value
}
