#!/bin/sh
# the next line restarts using the interpreter \
exec tclsh "$0" "$@"

set rcsId {$Id: depend.tcl,v 1.3 1996/11/10 20:11:35 jfontain Exp $}

proc sourcedFrom {fileName} {
    global env sourced

    if {[info exists sourced($fileName)]} {
        # do not process the same file more than once
        return {}
    }
    set files {}
    set sourced($fileName) {}
    set file [open $fileName]
    set skip 0
    while {[gets $file line]>=0} {
        if {[regexp {^[ 	]*#} $line]||$skip} {
            # skip comments and eventually following line
            set skip [string match {*\\} $line]
            continue
        }
        if {[scan $line { source %s} name]>0} {
            set name [subst $name]
            lappend files $name
            set files [concat $files [sourcedFrom $name]]
        }
    }
    close $file
    return $files
}

if {[llength $argv]==0} {
    puts stderr "usage: $argv0 fileName"
} else {
    puts [sourcedFrom [lindex $argv 0]]
}
