#!/bin/sh
# the next line restarts using the interpreter \
exec tclsh "$0" "$@"

# $Id: instapkg.tcl,v 1.3 1997/10/25 19:47:03 jfontain Exp $

if {[llength $argv]!=1} {
    puts stderr "usage: $argv0 directory"
    exit 1
}

set directory [lindex $argv 0]

if {![file exists $directory]} {
    # make directory
    if {[catch {file mkdir $directory} message]} {
        puts stderr $message
        exit 1
    }
} elseif {[string compare [file type $directory] directory]!=0} {
    puts stderr "file \"$directory\" type is \"[file type $directory]\", not \"directory\""
    exit 1
}

if {[catch {package require stooop 3.0} message]} {
    puts stderr "stooop package must be installed first: $message"
    exit 1
}

if {[catch {eval file copy -force {pkgIndex.tcl util.tcl pielabel.tcl perilabel.tcl boxlabel.tcl canlabel.tcl labarray.tcl slice.tcl pie.tcl} {$directory}} message]} {
    puts stderr $message
    exit 1
}
