# Webster (tkgoodstuff client)

proc WebsterDeclare {} {
    set Prefs_taborder(:Clients,Webster) "Misc Button"
    TKGDeclare Webster(server) citi.umich.edu \
	-typelist [list Clients Webster Misc] \
	-label "Server hostname"
    TKGDeclare Webster(port) 2627 \
	-typelist [list Clients Webster Misc] \
	-label "Server port number"
    TKGDeclare Webster(imagefile) {%webster} \
	-typelist [list Clients Webster Button] \
	-label "Icon file"
    TKGDeclare Webster(label) "Webster" \
	-typelist [list Clients Webster Button]
    TKGDeclare Webster(nolabel) 0 \
	-typelist [list Clients Webster Button]\
	-label "Omit the text label"\
	-vartype boolean
    TKGDeclare Webster(noicon) 0 -typelist [list Clients Webster Button]\
	-label "Omit the icon"\
	-vartype boolean
    TKGDeclare Webster(iconside) ""\
	-label "Side of icon on button" -vartype radio\
	-radioside left\
	-radiolist {{left left} {right right} {top top} 
	    {bottom bottom} {background background}} \
	-typelist [list Clients Webster Button]
    TKGDeclare Webster(internal) 1 -typelist [list Clients Webster Misc] \
	-vartype boolean\
	-label "Use internal webster client" \
	-help "Use our internal webster client code?  (If no, use the unix command.)"
    TKGDeclare Webster(makebutton) 1 \
	-typelist [list Clients Webster Button] -vartype boolean\
	-label "Make a button" \
	-help "Produce a button?  (If no, the command WebsterDefine is available as
a tcl command for the Menu client.)"
}

proc WebsterCreateWindow {} {
    global Webster
    if [TKGReGrid Webster] return
    if $Webster(makebutton) {
	lappend c TKGMakeButton Webster -command WebsterDefine\
	    -balloon "Get dictionary definition" -iconside $Webster(iconside)
	if !$Webster(nolabel) {
	    lappend c -text $Webster(label)
	}
	if !$Webster(noicon) {
	    SetImage Webster(image) $Webster(imagefile)
	    lappend c -image Webster(image)
	}
	eval $c
	unset c
    }
}

proc WebsterDefine {{word ""}} {
    after 0 "WebsterDefineBG $word"
}

proc WebsterDefineBG {{word ""}} {
    global Webster
    if {$word ==""} {
	if {[catch {set word [string trim [selection get]]}] || \
		([llength [split $word]] != 1)} {
	    TKGError "Webster will work only if the selection contains a single word."
	    return
	}
    }
    if $Webster(internal) {
	WebsterBG1 $word
    } else {
	set Webster(def) [exec webster $word]
	WebsterDisplay $word 
    }
}

proc WebsterBG1 {word} {
    global Webster
    if [catch {set id [socket $Webster(server) 2627]} err] {
	TKGError $err
	return
    }
    fconfigure $id -buffering none -blocking 0
    after 200 "WebsterBG2 $word $id"
}

proc WebsterBG2 {word id {getting 0}} {
    global Webster
    switch $getting \
	0 {
	    puts $id "DEFINE $word"
	    WebsterBG2 $word $id 1
	} 1 {
	    if {[append Webster(def) [read $id]] == ""} {
		after 100 "WebsterBG2 $word $id 1"
	    } else {
		after 500 "WebsterBG2 $word $id 2"
	    }
	} 2 {
	    append def [read $id]
	    catch {close $id}
	    WebsterDisplay $word
	}
}

proc WebsterDisplay {word} {
    global Webster
    TKGDialog webster-notice -title "Lookup: $word" -text $Webster(def)
    unset Webster(def)
}

DEBUG "Loaded Webster.tcl"
