#manager.tcl

namespace eval EditManager {
    variable _progress 0
    variable _afterid  ""
    variable _status "Compute in progress..."
    variable _homogeneous 0
    variable _newPageCounter 0
}

namespace import editorWindows::*

proc EditManager::_show_progress { } {
    variable _progress
    variable _afterid
    variable _status

    if { $_progress } {
        MainFrame::configure $Demo::mainframe -textvariable DemoManager::_status
        MainFrame::showstatusbar $Demo::mainframe progression
        if { $_afterid == "" } {
            set _afterid [after 30 DemoManager::_update_progress 0]
        }
    } else {
        MainFrame::configure $Demo::mainframe -textvariable Demo::status
        MainFrame::showstatusbar $Demo::mainframe status
        set _afterid ""
    }
}


proc EditManager::_update_progress { num } {
    variable _progress
    variable _afterid

    if { $_progress } {
        set Demo::prgindic [expr {$num+5}]
        set _afterid [after 30 DemoManager::_update_progress [expr {($num+5)%100}]]
    } else {
        set _afterid ""
    }
}


proc EditManager::focus_text {nb pagename} {
    global EditorData
    variable TxtWidget
    
    set text_page [$nb getframe $pagename]
#save values of last active textWindow
    if {[info exists Editor::current(text)]} {\
        set f0 $Editor::current(text)
        set p0 $Editor::current(pagename)
        if {[info exists Editor::index($f0)]} {\
            set idx $Editor::index($f0)
            set Editor::text_win($idx,hasChanged) $Editor::current(hasChanged)
            set Editor::text_win($idx,file) $Editor::current(file)
            set Editor::text_win($idx,slave) $Editor::current(slave)
#            set Editor::text_win($idx,marks) $Editor::current(marks)      
            set Editor::text_win($idx,project) $Editor::current(project)
            set Editor::text_win($idx,history) $Editor::current(procListHistory)
        }
    }  
    set Editor::current(text) $text_page.sw.textWindow
    #    tk_messageBox -message "$text_page\n $Editor::current(text) \n $pagename" -type ok
    set Editor::current(page) $text_page
    set Editor::current(pagename) $pagename
    set idx $Editor::index($Editor::current(text))
    set Editor::current(undo_id)  $Editor::text_win($idx,undo_id)
    set Editor::current(hasChanged) $Editor::text_win($idx,hasChanged)
    set Editor::current(file) $Editor::text_win($idx,file)
    set Editor::current(pagename) $Editor::text_win($idx,pagename)
    set Editor::current(slave) $Editor::text_win($idx,slave)
#    set Editor::current(marks) $Editor::text_win($idx,marks)
    set Editor::current(project) $Editor::text_win($idx,project)
    set Editor::current(procListHistory) $Editor::text_win($idx,history)
    #restore Cursor position
    set Editor::last(index) $idx
    focus -force $Editor::current(text)
    NoteBook::see $nb $pagename
    set editorWindows::TxtWidget $Editor::current(text)
    set EditorData(curFile) $Editor::current(file)
    
    Editor::updateProcs
    Editor::checkProcs
    $Editor::current(text) see insert
    editorWindows::ReadCursor 0
    editorWindows::flashLine
}

proc EditManager::create_text {nb file} {
    global EditorData
    variable TxtWidget
    variable _newPageCounter
    
    incr _newPageCounter
    set pageName "Page$_newPageCounter"   
    set filename [file tail $file]
    set prjFile [file join [file dirname $file] [lindex [split $filename .] 0]].prj
    set frame [$nb insert end $pageName -text $filename -raisecmd "EditManager::focus_text $nb $pageName"]
    set sw [ScrolledWindow::create $frame.sw -auto none]
    set text [text $sw.textWindow -bg white -wrap none \
             -font $EditorData(options,fonts,editorFont) -height 20 -width 80]
    pack $text -fill both -expand yes
    ScrolledWindow::setwidget $sw $text 
    pack $sw -fill both -expand yes
    set editorWindows::TxtWidget $text
    editorWindows::setBindings 
    bind $text <Control-L> "repeat_last_search $text"
    bind $text <Control-l> "repeat_last_search $text"

    incr Editor::index_counter
    set Editor::index($text) $Editor::index_counter
    set Editor::text_win($Editor::index_counter,page) $frame
    set Editor::text_win($Editor::index_counter,path) $text
#    set Editor::text_win($Editor::index_counter,undo_id) [new textUndoer $text]
    set Editor::text_win($Editor::index_counter,hasChanged) 0
    set Editor::text_win($Editor::index_counter,file) $file
    set Editor::text_win($Editor::index_counter,pagename) $pageName
    set Editor::text_win($Editor::index_counter,slave) "none"
#    set Editor::text_win($Editor::index_counter,marks) {}
    set Editor::text_win($Editor::index_counter,history) [list "mark1"]
    if {[file exists $prjFile]} {
        set fd [open $prjFile r]
        set Editor::text_win($Editor::index_counter,project) [read $fd]
        close $fd
    } else  {
        set Editor::text_win($Editor::index_counter,project) $EditorData(options,defaultProjectFile)
    } 
           
    return [list $frame $pageName $text]
}



proc EditManager::create_procWindow {nb } {
    variable TxtWidget
    
#    set frame [NoteBook::insert $nbp end -text "Procs"]
    set pagename Proclist
    set frame [$nb insert end $pagename -text "Procs"]

    set sw [ScrolledWindow::create $frame.sw -auto both]
    set procList [listbox $sw.proc -bg white]
    $procList configure -exportselection false
    set item "<none>"
    $procList insert end $item
    pack $procList -fill both -expand yes
    ScrolledWindow::setwidget $sw $procList 
    pack $sw -fill both -expand yes
    set buttonFrame [frame $frame.buttonFrame -relief sunken -borderwidth 2]
#    set button_prev [ArrowButton::create $frame.bp -dir left \
#                                                 -height 21\
#                                                 -width 21\
#                                                 -helptype balloon\
#                                                 -helptext "Goto previous Position"\
#                                                 -command {Editor::procList_history_get_prev}]
    set button_prev [Button::create $buttonFrame.bp \
            -image [Bitmap::get left] \
            -relief raised\
            -helptext "Goto previous Position"\
            -command {Editor::procList_history_get_prev}]
#    set button_next [ArrowButton::create $frame.bn -dir right \
#                                                 -height 21\
#                                                 -width 21\
#                                                 -helptype balloon\
#                                                 -helptext "Goto next Position"\
#                                                 -command {Editor::procList_history_get_next}]
    set button_next [Button::create $buttonFrame.bn\
            -image [Bitmap::get right] \
            -relief raised\
            -helptext "Goto next Position"\
            -command {Editor::procList_history_get_next}]
    set entryFrame [frame $frame.entryFrame -relief sunken -borderwidth 2]
    
    set Editor::lineEntryCombo [ComboBox::create $entryFrame.combo -label "" -labelwidth 0 -labelanchor w \
                   -textvariable Editor::lineNo\
                   -values {""} \
                   -helptext "Enter Linenumber" \
                   -entrybg white\
                   -width 6]
    set button_go [Button::create $entryFrame.go\
            -image [Bitmap::get go] \
            -relief raised\
            -helptext "Goto Line"\
            -command {Editor::lineNo_history_add ; Editor::gotoLine $Editor::lineNo}]
    pack $button_prev -side left -expand yes -padx 2 -pady 5
    pack $button_next -side left -expand yes -padx 2 -pady 5
    pack $Editor::lineEntryCombo -side left -fill both -expand yes -pady 0 -ipady 0
    pack $button_go -side left -expand yes
    pack $buttonFrame -side left -fill both -expand yes -ipadx 2 -padx 1
    pack $entryFrame -side left -fill both -expand yes -ipadx 2 -padx 1
    set childList [winfo children $Editor::lineEntryCombo]
    foreach w $childList {if {[winfo class $w] == "Entry"} { set lineEntry $w ; break}}
    bind $lineEntry <KeyRelease-Return> {Editor::lineNo_history_add ; Editor::gotoLine $Editor::lineNo}
    return $frame
}

################################################################################
# proc EditManager::create_markWindow {nb } {    
# 
#     set pagename Marklist
#     set frame [$nb insert end $pagename -text "Marks"]
#     set sw [ScrolledWindow::create $frame.sw -auto both]
#     set markList [listbox $sw.mark ]
#     set item "<Top of File>"
#     $markList insert end $item
#     set item "<End of File>"
#     $markList insert end $item
#     pack $markList -fill both -expand yes
#     ScrolledWindow::setwidget $sw $markList 
#     pack $sw -fill both -expand yes
#     return $frame
# }
# 
################################################################################
proc EditManager::create_conWindow {nb } {
    global conWindow
    
    set pagename asedCon
    set frame [$nb insert end $pagename -text "Console"]

    set sw [ScrolledWindow::create $frame.sw -auto both]
    set conWindow [consoleInit $sw]
    ScrolledWindow::setwidget $sw $conWindow
    pack $sw -fill both -expand yes

    return $frame
}