#!/bin/sh
#\
exec wish "$0" ${1+"$@"}

##############################################################################
# ased.tcl -
#
# This is the startfile for
#
# ASED Tcl/Tk IDE
#
# Copyright (C) 1999-2000  Andreas Sievers andreas.sievers@t-online.de
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################


global ASEDsRootDir
global search_var_string search_option_icase search_option_area search_option_match search_option_blink
global EditorData
global clock_var
global textChanged
global conWindow

if { [file type $argv0] == "link" } {
    set ASEDsRootDir [file dirname [file readlink $argv0]]
} else {
    set ASEDsRootDir [file dirname $argv0]
}


set path_to_BWidget [file join $ASEDsRootDir BWidget-1.2.1]
lappend auto_path $path_to_BWidget

package require BWidget 1.2
Bitmap::get cut
# this used for loading Bitmap namespace into the interpetator
namespace eval Bitmap {
    lappend path [file join $ASEDsRootDir images]
}

source [file join $ASEDsRootDir asedmain.tcl]
source [file join $ASEDsRootDir editor.tcl]
source [file join $ASEDsRootDir find.tcl]
source [file join $ASEDsRootDir repl.tcl]
source [file join $ASEDsRootDir undo.tcl]
source [file join $ASEDsRootDir asedcon.tcl]
source [file join $ASEDsRootDir manager.tcl]
source [file join $ASEDsRootDir tclparser.tcl]
source [file join $ASEDsRootDir fifDialog.tcl]

proc initASED {argc argv} {
    global tcl_platform
    global auto_path
    global EditorData
    
    lappend auto_path ..
    
    package require Tk 8.0
    
    option add *TitleFrame.font {helvetica 11 bold italic}
    if {"$tcl_platform(platform)" != "windows"} {
        option add *background grey userDefault
    }
    
    wm withdraw .
    wm title . "ASED Tcl/Tk-IDE"
    
    Editor::create
    BWidget::place . 0 0 center
    
    update idletasks
    if {[info exists EditorData(options,mainWinSize)]} {
        wm geom . $EditorData(options,mainWinSize)
        update
    }
    
    after idle {
        wm deiconify .
        raise .
        focus .
        set Editor::initDone 1
    }
    if {$argc >= 1} {
        set cursor [. cget -cursor]
        . configure -cursor watch
        update
        foreach filename $argv {
            if {[file exists $filename]} {
                Editor::openFile $filename
            } elseif {[file exists [file join $EditorData(options,workingDir) $filename]]} {
                Editor::openFile [file join $EditorData(options,workingDir) $filename]
            }
        }
        . configure -cursor $cursor
        update
    }
    
}

initASED $argc $argv
