#!/bin/sh
#\
exec wish "$0" ${1+"$@"}
#########################################
# evalServer --
# (c) 2000 by Andreas Sievers
# executes each sock in its own interpreter
#########################################


package require Tk

proc initServer {port {putsEcho 1}} {
    if {[catch {socket -server [list EvalAccept $putsEcho] $port } info]} {
        exit
    }
}

proc EvalAccept {echoOn newsock addr port} {
    global eval
    set eval(cmdbuf,$newsock) {}
    set eval(run,$newsock) 0
    set eval(interp,$newsock) [interp create]
    interp eval $eval(interp,$newsock) set sock $newsock
    interp eval $eval(interp,$newsock) set echoOn $echoOn
    interp eval $eval(interp,$newsock) set interp $eval(interp,$newsock)
    $eval(interp,$newsock) alias ExitApp exitApp
    if {$echoOn} {
        $eval(interp,$newsock) alias ASEDServerEcho asedServerEcho
    }
    fileevent $newsock readable [list EvalRead $newsock $eval(interp,$newsock)]
    fconfigure $newsock -blocking 0
    if [catch {
        interp eval $eval(interp,$newsock) {
            proc exitProc {} {
                global interp sock
                ExitApp $interp $sock
            }
            proc echoPuts {args} {
                global sock
                ASEDServerEcho $sock $args
            }
            interp alias {} exit {} exitProc
            # interp alias {} puts {} echoPuts 
            proc Interp {args} {
                global sock
                set subCmd [lindex $args 0]
                if {$subCmd == "create"} {
                    set newInterp [eval origInterp $args]
                    # here we will do some aliases in the future
                    # like puts alias
                } else  {
                    eval origInterp $args
                }
            }
            
            load {} Tk
            if {$echoOn} {
                interp alias {} puts {} echoPuts
                rename interp origInterp
                origInterp alias {} interp {} Interp
            }
            
            # wm withdraw .
            wm protocol . WM_DELETE_WINDOW {exit}
        }
    } info] {
        tk_messageBox -message "Connection rejected:\n$info"
        close $newsock
    }
}



proc exitApp {interp sock} {
    global eval
    interp eval $interp {
        set taskList [after info]
        foreach id $taskList {
            after cancel $id
        }
    }
    puts $sock "exitASEDServer"
    catch {close $sock}
    interp delete $interp
    unset eval(cmdbuf,$sock)
    return
}

proc asedServerEcho {sock args} {
    global errorInfo
    
    set argcounter [llength $args]
    switch $argcounter {
        1 {eval [list puts $sock $args]}
        2 {
            if {[lindex $args 0] == "-nonewline"} {
                eval [list puts -nonewline $sock [lindex $args 1]]
            } else {
                set code [catch {eval puts $args} info]
                if {$code} {
                    eval [list puts $sock $errorInfo]
                } else {
                    eval [list puts $sock [lindex $args 1]]
                }
            }
        }
        
        default {
            set code [catch {eval puts $args} info]
            if {$code} {eval [list puts $sock $errorInfo]}
        }
    }
}

proc getFirstChar {line} {
    
    set char [string index $line 0]
    for {set i 0} {$char == " " || $char == "\t"} {incr i} {
        if {$i > [string length $line]} {
            set char ""
            break
        }
        set char [string index $line $i]
    }
    return $char
}

# EvalRead  -- read commands from the sock and executes them
proc EvalRead {sock interp} {
    fconfigure $sock -blocking 1
    global eval errorInfo errorCode
    global tcl_platform env
    
    if [eof $sock] {
        exitApp $interp $sock
    } else {
        if {[gets $sock line] < 0} {
            fconfigure $sock -blocking 0
            return
        }
        if {$line == {} && $eval(cmdbuf,$sock) == {}} {
            fconfigure $sock -blocking 0
            return
        } elseif {[getFirstChar $line] == "#"} {
            # skip comments
            # fconfigure $sock -blocking 0
            # return
        }
        append eval(cmdbuf,$sock) $line\n
        if {[string length $eval(cmdbuf,$sock)] && [info complete $eval(cmdbuf,$sock)]} {
            switch -- $eval(cmdbuf,$sock) {
                "resetServer\n" {
                    #abort current command
                    set eval(cmdbuf,$sock) {}
                    fconfigure $sock -blocking 0
                    return
                }
                "exit\n" {
                    # we probably do not want to exit the server but the application
                    exitApp $interp $sock
                    return
                }
                "exitASEDServer\n" {
                    # this should be clear
                    exit
                }
            }
            set evaldata $eval(cmdbuf,$sock)
            set eval(cmdbuf,$sock) {}
            set code [catch {
                if {[string length $interp] == 0} {
                    uplevel #0 eval $evaldata
                } else {
                    interp eval $interp $evaldata
                }
            } result]
            if {$code != 0} {
                set reply [list Code:$code\nResult:$result\nErrorinfo:$errorInfo\nErrorcode:$errorCode\n]
                eval puts -nonewline $sock $reply
                flush $sock
                fconfigure $sock -blocking 0
                return
            } else  {
                puts $sock $result
                flush $sock
                fconfigure $sock -blocking 0
            }
        }
    }
    return
}

if {[string compare [info script] $argv0] == 0} {
    
    switch -- $argc {
        0    {
            set port 9001
            set putsEcho 1
        }
        1    {
            set port [lindex $argv 0]
            set putsEcho 1
        }
        2    {
            set port [lindex $argv 0]
            set putsEcho [lindex $argv 1]
        }
        
        default {
            # port is portnumber as integer
            # putsEcho is boolean, if !=0 normal put commands are echoed back
            puts "usage: evalServer.tcl ?port? ?putsEcho?"
            exit
        }
    }
    
    initServer $port $putsEcho
    update
    catch {wm iconify .}
    wm protocol . WM_DELETE_WINDOW {exit}
}

