# evalClient --
# starts the evalServer and set up connection to it
# provides a execution terminal which shows the output of the commands
# its also possible to execute commands via this terminal

package require Tk

namespace eval Client {
    variable terminal
    variable port
    variable shutdown 0
    variable serverInitDone 0
}

proc Client::sockHandler {sock handleProc} {
    variable serverInitDone
    
    eval $handleProc $sock
    set serverInitDone 1
}

proc Client::showResult {sock} {
    variable terminal
    
    if [eof $sock] {
        catch {close $sock}
        exit
    }
    if {[gets $sock result] < 0 } {
        catch {close $sock}
        exit
    } elseif {$result != ""} {
        $terminal(win) insert insert $result\n result
        $terminal(win) see insert
    }
    
    return
}

proc Client::exitExecutionServer {{serverPort {}} {host localhost}} {
    variable port
    variable shutdown
    global waitforexit
    
    if {$serverPort != {}} {
        set port $serverPort
    }
    # setup client sock
    if {[catch {
            set sock [eval [list socket $host $port]]
        } errorInfo ]} {
        return
    }
    # send exit command
    puts $sock "exitASEDServer"
    catch {close $sock}
    set shutdown "done"
    return
}

proc Client::initExecutionClient {{host localhost} {port 9001} {sockHandleProc Client::showResult} {serverName "./evalServer.tcl"} {serverWish {}} {timeout 10}} {
        
    global serverUp
    variable serverInitDone
    
    if {$serverWish == {}} {
        set serverWish [info nameofexecutable]
    }
    # setup client sock
    if {[catch {
            set sock [eval [list socket $host $port]]
        }]} {
        # start execution server
        if {[file exists $serverName]} {
            eval [list Client::initExecutionServer $port $serverName $serverWish]
            # and try again
            after 10000 {set Client::serverInitDone timeout}
            while {[catch {set sock [eval [list socket $host $port]]}]} {
                if {$Client::serverInitDone == "timeout"} {
                    break
                }
                after 200
            }
            if {$Client::serverInitDone == "timeout"} {
                tk_messageBox -message "Couldnt connect to evalServer!" -icon error -title "server error"
                return
            }
        } else  {
            tk_messageBox -message "Server $serverName not found!" -icon error -title "server error"
            return
        }
    }
    fileevent $sock readable [list Client::sockHandler $sock $sockHandleProc]
    fconfigure $sock -buffering none
    fconfigure $sock -blocking 0
    set serverUp 1
    return $sock
}

proc Client::initExecutionServer {{port 9001} {serverName "./evalServer.tcl"} {serverWish {}} } {
    global env
    global tcl_platform
    global serverUp
    
    if {$serverUp} {
        return
    }
    if {$serverWish == {}} {
        set serverWish [info nameofexecutable]
    }
    # start execution server
    set command [list $serverWish $serverName $port]
    
    eval exec $command &
    set serverUp 1
}

proc Client::remoteExecute {sock command} {
    
    puts $sock $command
    
}

proc Client::initClientTerminal { \
        {host localhost} \
        {port 9001} \
        {serverName "./evalServer.tcl"} \
        {sockHandleProc Client::showResult}} {
            
    variable terminal 
    
    set terminal(win) [text .clientTerminal]
    $terminal(win) tag configure result -foreground blue
    $terminal(win) tag configure error -foreground red
    
    # setup client sock
    set terminal(sock) [eval [list Client::initExecutionClient $host $port $sockHandleProc $serverName]]
    if {$terminal(sock) == {}} {
        return {}
    }
    
    pack $terminal(win)
    bind $terminal(win) <Return> {
        #get command and execute it
        set command [$Client::terminal(win) get "insert linestart" "insert lineend"]
        eval [list puts $Client::terminal(sock) $command]
    }
    wm title . "ASED Execution Terminal"
    wm protocol . WM_DELETE_WINDOW {Client::exitExecutionServer}
    return $terminal(sock)
}

global serverUp
set serverUp 0

if {[string compare [info script] $argv0] == 0} {
    
    switch -- $argc {
        0    {
            set Client::port 9001
            set serverName "./evalServer.tcl"
            set sockHandleProc "Client::showResult"
        }
        1    {
            set Client::port [lindex $argv 0]
            set serverName "./evalServer.tcl"
            set sockHandleProc "Client::showResult"
        }
        2    {
            set Client::port [lindex $argv 0]
            set serverName [lindex $argv 1]
            set sockHandleProc "Client::showResult"
        }
        3    {
            set Client::port [lindex $argv 0]
            set serverName [lindex $argv 1]
            set sockHandleProc [lindex $argv 2]
        }
        default {
            # sockHandleProc has to be the the name of the sockHandler proc
            eval [list puts "usage: evalClient.tcl ?port? ?serverName? ?sockHandleProc?"]
            exit
        }
    }
    eval [list Client::initClientTerminal localhost $Client::port $serverName $sockHandleProc]
}
