# -*- tcl -*-
# Automatically generated from file 'class.cls'.
# Date: Mon Feb 15 19:28:21 MET 1999
# -------------------------------
# ** Do NOT edit manually **
#
# ** Provided class       **     >> classDescription <<
# -------------------------------

package require Pool_Base

# -------------------------------
# Namespace describing the class
namespace eval ::pool::oo::class::classDescription {
    variable  _superclasses    {azIndexEntry problemsAndIndex}
    variable  _scChainForward  classDescription
    variable  _scChainBackward classDescription
    variable  _classVariables  {}
    variable  _methods         {DependencyList GetInheritedEntities GetPartRecord OptionDescriptionList OptionList PostProcessInformation ScanMethods SetupAnchors SuperclassList VarDescriptionList VarList WriteHeading WriteMethods author authorSet clear completeKwIndex constructor dependencies getMRef getORef getOvDescription getPage getVRef keywords mref oref refError scan vref write writeProblemPage}

    variable  _variables
    array set _variables  {keywords {classDescription {isArray 0 initialValue {}}} variables {classDescription {isArray 0 initialValue {}}} ivariables {classDescription {isArray 0 initialValue {}}} anchor {classDescription {isArray 1 initialValue {}}} comment {classDescription {isArray 0 initialValue {}}} seeAlso {classDescription {isArray 0 initialValue {}}} options {classDescription {isArray 0 initialValue {}}} ioptions {classDescription {isArray 0 initialValue {}}} superclasses {classDescription {isArray 0 initialValue {}}} note {classDescription {isArray 0 initialValue {}}} ovComment {classDescription {isArray 1 initialValue {}}} authorAddress {classDescription {isArray 0 initialValue {}}} danger {classDescription {isArray 0 initialValue {}}} mref {classDescription {isArray 1 initialValue {}}} vref {classDescription {isArray 1 initialValue {}}} partInfo {classDescription {isArray 1 initialValue {}}} oref {classDescription {isArray 1 initialValue {}}} authorName {classDescription {isArray 0 initialValue {}}} methods {classDescription {isArray 0 initialValue {}}} imethods {classDescription {isArray 0 initialValue {}}} dependencies {classDescription {isArray 0 initialValue {}}}}

    variable  _options
    array set _options  {ptable {classDescription {-default {} -type ::pool::getopt::notype -action {} -class Ptable}} psort {classDescription {-default 1 -type ::pool::getopt::notype -action {} -class Psort}} file {classDescription {-default {} -type ::pool::getopt::notype -action {} -class File}} log {classDescription {-default {} -type ::pool::getopt::notype -action {} -class Log}} inline {classDescription {-default 0 -type ::pool::getopt::notype -action {} -class Inline}} spec {classDescription {-default {} -type ::pool::getopt::notype -action {} -class Spec}}}

    variable  _optionAliases
    array set _optionAliases {_ _}
    unset     _optionAliases(_)

    variable  _methodTable
    array set _methodTable  {keywords . writeProblemPage . VarDescriptionList . getOvDescription . GetInheritedEntities . getMRef . PostProcessInformation . getVRef . author . DependencyList . getORef . scan . VarList . constructor . GetPartRecord . SetupAnchors . SuperclassList . ScanMethods . OptionDescriptionList . mref . completeKwIndex . WriteHeading . write . vref . oref . OptionList . getPage . WriteMethods . authorSet . refError . dependencies . clear .}

    # Export every method
    namespace export -clear *
}

# -------------------------------


proc ::pool::oo::class::classDescription::DependencyList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a string containing references to the
	# @c packages required by the class.
	#
	# @r A string containing a comma separated list of package names, each
	# @r a hyperlink to a location describing the it.

	set text ""

	foreach d $dependencies {
	    append text "[$dist depRef $d], "
	}
	
	return [string trimright $text ", "]
}



proc ::pool::oo::class::classDescription::GetInheritedEntities {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Used during the writing of the class description to obtain the
	# @c information about all inherited variables, options and methods.
}



proc ::pool::oo::class::classDescription::GetPartRecord {code name} {
    ::pool::oo::support::SetupVars classDescription
    # @r class and method object of the method <a name>, or an empty list.
	# @a code: Internal type code of the part. These are [strong m]ethod,
	# @a code: [strong o]ption and [strong v]ariable.
	# @a name: The name of the method to search for.

	if {![::info exists partInfo($code,$name)]} {

	    foreach sc $superclasses {
		set sco [$opt(-index) itemByName $sc]
		set record [$sco GetPartRecord $code $name]

		if {[llength $record] != 0} {
		    set partInfo($code,$name) $record
		    return $record
		}
	    }

	    set partInfo($code,$name) {}
	    return {}
	} else {
	    return $partInfo($code,$name)
	}
}



proc ::pool::oo::class::classDescription::OptionDescriptionList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a definition list containing the
	# @c descriptions of all defined options.

	if {[llength $options] != 0} {
	    $fmt hrule
	    $fmt definitionList {
		foreach o [lsort $options] {
		    $fmt setAnchor $anchor(o,$o)
		    $fmt defterm "-$o" [getOvDescription o $o]
		}
	    }
	}

	return
}



proc ::pool::oo::class::classDescription::OptionList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a string containing references to the
	# @c option descriptions.
	#
	# @r A string containing a comma separated list of option names, each
	# @r a hyperlink to the associated description.

	set text ""
	foreach o [lsort $options] {
	    append text "[$fmt link $o "#$anchor(o,$o)"], "
	}

	return [string trimright $text ", "]
}



proc ::pool::oo::class::classDescription::PostProcessInformation {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Called to streamline the extracted embedded documentation.
	# @c This mainly consists of removing superfluous whitespace.
	# @c Additionally converts a comma separated list of index
	# @c phrases into a real tcl list.

	foreach i {comment danger note seeAlso} {
	    set text [::pool::string::removeWhitespace [set $i]]
	    set $i [string trim [::pool::string::oneLine $text]]
	}

	set keywords [::pool::string::removeWhitespace $keywords]
	set keywords [split [string trim $keywords ", \t"] ,]
	while {[::pool::list::delete keywords {}]} {}
	return
}



proc ::pool::oo::class::classDescription::ScanMethods {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method. Called to scan the definitions of all methods
	# @c of this class.

	foreach p $methods {
	    $p scan
	}
	return
}



proc ::pool::oo::class::classDescription::SetupAnchors {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method. Initializes the anchor array for all options
	# @c and variables.

	set n 1
	foreach o $options {
	    set anchor(o,$o) o$n
	    set partInfo(o,$o) [list $this "[page]#o$n"]
	    incr n
	}

	set n 1
	foreach v $variables {
	    set anchor(v,$v) v$n
	    set partInfo(v,$v) [list $this "[page]#v$n"]
	    incr n
	}

	return
}



proc ::pool::oo::class::classDescription::SuperclassList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a string containing references to the
	# @c superclass descriptions.
	#
	# @r A string containing a comma separated list of superclass names,
	# @r each a hyperlink to the associated description.

	set text ""

	foreach c $superclasses {
	    append text "[$opt(-index) ref $c], "
	}
	
	return [string trimright $text ", "]
}



proc ::pool::oo::class::classDescription::VarDescriptionList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a definition list containing the
	# @c descriptions of all defined variables.

	if {[llength $variables] != 0} {
	    $fmt hrule
	    $fmt definitionList {
		foreach v [lsort $variables] {
		    $fmt setAnchor $anchor(v,$v)
		    $fmt defterm $v [getOvDescription v $v]
		}
	    }
	}

	return
}



proc ::pool::oo::class::classDescription::VarList {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method, generates a string containing references to the
	# @c variable descriptions.
	#
	# @r A string containing a comma separated list of variable names, each
	# @r a hyperlink to the associated description.

	set text ""
	foreach v [lsort $variables] {
	    append text "[$fmt link $v "#$anchor(v,$v)"], "
	}

	return [string trimright $text ", "]
}



proc ::pool::oo::class::classDescription::WriteHeading {mlist} {
    ::pool::oo::support::SetupVars classDescription
    # @c Generates the header part of a class description.
	#
	# @a mlist: The list of method objects. Used to create
	# @a mlist: a comma separated list of method names referencing
	# @a mlist: their descriptions later on the page

	$fmt definitionList {
	    if {
		!$opt(-inline) ||
		([string compare $authorName [$opt(-file) author]] != 0)
	    } {
		$fmt mailToDefterm "Written by" authorName authorAddress
	    }

	    if {!$opt(-inline) && ([llength $dependencies] != 0)} {
		$fmt defterm "Depends on" [DependencyList]
	    }

	    $fmt formattedTermVar Description comment
	    $fmt formattedTermVar Danger      danger
	    $fmt formattedTermVar Notes       note

	    if {[llength $superclasses] != 0} {
		$fmt defterm Superclasses [SuperclassList]
	    }

	    $fmt formattedTermVar "See also" seeAlso

	    if {[llength $options] != 0} {
		$fmt defterm Options [OptionList]
	    }

	    if {[llength $ioptions] != 0} {
		$fmt defterm {Inherited options} [IOptionList]
	    }

	    if {[llength $variables] != 0} {
		$fmt defterm Membervariables [VarList]
	    }

	    if {[llength $ivariables] != 0} {
		$fmt defterm {Inherited membervariables} [VarList]
	    }

	    if {[llength $mlist] != 0} {
		$fmt defterm Methods [$fmt linkCommaList $mlist]
	    }

	    if {[llength $imethods] != 0} {
		$fmt defterm {Inherited methods} [$fmt linkCommaList $imethods]
	    }

	    if {! $opt(-inline)} {
		$fmt defterm "Defined in" [$opt(-file) link]
	    }
	}
	return
}



proc ::pool::oo::class::classDescription::WriteMethods {mList} {
    ::pool::oo::support::SetupVars classDescription
    # @c Internal method used by the page generator routine (<m write>) to
	# @c produce the output for all methods. Uses different separator
	# @c rules dependent on the setting of <o ptable>.
	#
	# @a mList: The list of method objects to call.

	if {$opt(-ptable)} {
	    $fmt hrule
	    foreach p $mList {
		# no explicit visual separator required for table formatting
		$p write
	    }
	} else {
	    foreach p $mList {
		$fmt hrule
		$p write
	    }
	}
}



proc ::pool::oo::class::classDescription::author {} {
    ::pool::oo::support::SetupVars classDescription
    # @r The author of the class
	return $authorName
}



proc ::pool::oo::class::classDescription::authorSet {author} {
    ::pool::oo::support::SetupVars classDescription
    # @c Called by the containing file to propagate its author information.
	# @a author: Author of containing file.

	if {[string length $authorName] == 0} {
	    set authorName $author
	}

	set currentAddr   [::pool::misc::currentAddress]
	set authorAddress [::pool::mail::addressB $authorName $currentAddr]

	foreach p $methods {
	    $p authorSet $authorName
	}
	return
}



proc ::pool::oo::class::classDescription::clear {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Resets state information.

	azIndexEntry_clear
	problemsAndIndex_clear
	return
}



proc ::pool::oo::class::classDescription::completeKwIndex {phrases} {
    ::pool::oo::support::SetupVars classDescription
    # @c Called by the containing file to propagate
	# @c its indexing information.
	# @c Completes the indexing of key phrases, propagates class
	# @c information down to all methods without index phrases, then
	# @c uses the union of all index phrases for the whole class.
	#
	# @a phrases: List of index phrases used by the containing file.

	# no propogation if we have our own keywords.
	if {[llength $keywords] != 0} {
	    return
	}

	set keywords $phrases
	set kwi     [$dist getIndex keywords]

	foreach m $methods {
	    append keywords " [$m keywords]"
	}

	set keywords [::pool::list::uniq [lsort $keywords]]

	# and use union to index the class itself

	foreach phrase $keywords {
	    $kwi addItem $phrase $this
	}

	return
}



proc ::pool::oo::class::classDescription::constructor {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Constructor. Initializes the parser functionality in
	# @c <f lib/classParse.tcl>.

	class_util_init
	return
}



proc ::pool::oo::class::classDescription::dependencies {internal} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines all dependencies of this class.
	# @a internal: list of packages distributed here,
	# @a internal: to be removed from all dependency lists.
	# @r List containing all dependencies of this class.

	# i.  delete internal from current dependency list.
	# there is no need to merge method information,
	# this was done already, by <p cd_extract_definitions>.

	foreach d $internal {
	    while {[::pool::list::delete dependencies $d]} {}
	}

	return $dependencies
}



proc ::pool::oo::class::classDescription::getMRef {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is a method of the class or not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	set mr [GetPartRecord m $name]

	if {[llength $mr] == 0} {
	    return [list 0 [refError method $name]]
	}

	return [list 1 [[lindex $mr 1] link]]
}



proc ::pool::oo::class::classDescription::getORef {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is an option of the class or not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	set or [GetPartRecord o $name]

	if {[llength $or] == 0} {
	    return [list 0 [refError option $name]]
	}

	return [list 1 "[$fmt link $name [lindex $or 1]]"]
}



proc ::pool::oo::class::classDescription::getOvDescription {which name} {
    ::pool::oo::support::SetupVars classDescription
    # @r The description of the specified option or variable.
	#
	# @a which: A code indicating the type of <a name>. 'v' for variable,
	# @a which: 'o' for option.
	# @a name:  The name of the option/variable to look up.

	if {! [::info exists ovComment($which,$name)]} {
	    set text [$fmt missingDescError "No description for '$name'"]
	    # -W- problem
	} elseif {[string length $ovComment($which,$name)] == 0} {
	    set text [$fmt missingDescError "Empty description for '$name'"]
	    # -W- problem
	} else {
	    set text [$dist crResolve $ovComment($which,$name)]
	}

	return $text
}



proc ::pool::oo::class::classDescription::getPage {} {
    ::pool::oo::support::SetupVars classDescription
    # @r The url of the page containing the class description.

	if {$opt(-inline)} {
	    return [$opt(-file) page]
	}

	return [$fmt pageFile c[::pool::serial::new]]
}



proc ::pool::oo::class::classDescription::getVRef {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is a member variable of the class or
	# @c not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	set vr [GetPartRecord v $name]

	if {[llength $vr] == 0} {
	    return [list 0 [refError variable $name]]
	}

	return [list 1 "[$fmt link $name [lindex $vr 1]]"]
}



proc ::pool::oo::class::classDescription::keywords {} {
    ::pool::oo::support::SetupVars classDescription
    # @r The list of kywords the class is indexed under.
	return $keywords
}



proc ::pool::oo::class::classDescription::mref {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is a method of the class or not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	if {![::info exists mref($name)]} {
	    set mref($name) [getMRef $name]
	}

	set ok [lindex $mref($name) 0]

	if {! $ok} {
	    refError method $name
	}

	return [lindex $mref($name) 1]
}



proc ::pool::oo::class::classDescription::oref {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is an option of the class or not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	if {![::info exists oref($name)]} {
	    set oref($name) [getORef $name]
	}

	set ok [lindex $oref($name) 0]

	if {! $ok} {
	    refError option $name
	}

	return [lindex $oref($name) 1]
}



proc ::pool::oo::class::classDescription::refError {what name} {
    ::pool::oo::support::SetupVars classDescription
    # @r A string formatted as error for cross references to unknown
	# @r methods or options. Additionally adds the error to the list
	# @r of problems associated to the entity containing the bogus
	# @r cross reference.
	#
	# @a what: The type of the referenced entity.
	# @a name: The name of the unknown entity.

	return [$fmt crError $name "Reference to unknown $what '$name'"]
}



proc ::pool::oo::class::classDescription::scan {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Scans the specification of the class for embedded
	# @c documentation and definitions (members, methods and options)

	# i. extract class description

	set ignoreDesc 0
	set spec [split $opt(-spec) \n]

	# skip the first line, it just contains the tail of the class
	# intro (supperclasses).

	::pool::list::shift spec

	while {[llength $spec] > 0} {
	    set line [::pool::list::shift spec]
	    set line [string trim $line]
	    if {[string length $line] == 0} {continue}
	    if {![regexp ^# $line]} {
		# Ignore @index, @see, @comment, @author, @danger, @note
		# and any shortcuts of these from now on.

		set ignoreDesc 1
		continue
	    }
	    set line [string trimleft $line "#\t "]
	    if {![regexp ^@ $line]} {continue}
	    set line [string trimleft $line "@"]

	    regexp -indices "^(\[^ \t\]*)" $line dummy word
	    set start [lindex $word 0]
	    set end   [lindex $word 1]

	    set cmd  [string range $line $start $end]
	    set line [string range $line [incr end] end]

	    if {[llength [::info command cd_$cmd]] == 0} {
		continue
	    }

	    cd_$cmd [string trim $line]
	}

	unset spec
	PostProcessInformation

	# ii. now get the members, ...
	set def   [cd_extract_definitions $opt(-name) $opt(-log) $opt(-spec)]

	set procs         [lindex $def 0]
	set options       [lindex $def 1]
	set variables     [lindex $def 2]
	set superclasses  [lindex $def 3]
	set dependencies  [lindex $def 4]

	foreach {pname pspec} $procs {
	    set procId ${this}::Method[::pool::serial::new]

	    procDescription $procId            -name   $pname             -parent $this              -args   [lindex $pspec 0]  -body   [lindex $pspec 1]  -dist   $opt(-dist)        -formatter $fmt  -table  $opt(-ptable)


	    lappend methods $procId
	    set partInfo(m,$pname) [list $this $procId]
	}

	SetupAnchors
	ScanMethods
	return
}



proc ::pool::oo::class::classDescription::vref {name} {
    ::pool::oo::support::SetupVars classDescription
    # @c Determines wether <a name> is a member variable of the class or
	# @c not.
	# @a name: The name to look for.
	# @r A link to the page containing the definition,
	# @r or the name marked as error.

	if {![::info exists vref($name)]} {
	    set vref($name) [getVRef $name]
	}

	set ok [lindex $vref($name) 0]

	if {! $ok} {
	    refError variable $name
	}

	return [lindex $vref($name) 1]
}



proc ::pool::oo::class::classDescription::write {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Generates the formatted text describing the class.

	GetInheritedEntities

	$dist pushContext $this

	if {$opt(-inline)} {
	    $fmt chapter "Class '$opt(-name)'"
	} else {
	    $fmt  newPage [page] "Class '$opt(-name)'"
	    $dist writeJumpbar
	}

	set mlist [$fmt sortByName $methods]

	WriteHeading $mlist
	OptionDescriptionList
	VarDescriptionList
	WriteMethods $mlist

	if {! $opt(-inline)} {
	    $fmt closePage
	}

	$dist popContext
	return
}



proc ::pool::oo::class::classDescription::writeProblemPage {} {
    ::pool::oo::support::SetupVars classDescription
    # @c Writes a page containing the detailed problem description of
	# @c this class.

	$fmt  newPage [pPage] "Problems of class '[name]'"
	$dist writeJumpbar

	if {[numProblems] > 0} {
	    writeProblems
	}

	if {[numProblemObjects] > 0} {
	    $fmt section Methods

	    $fmt itemize {
		foreach p [$fmt sortByName $problemObjects] {
		    $fmt item [$fmt getString {
			$p writeProblems
		    }] ;#{}
		}
	    }
	}

	$fmt closePage
	return
}



# -------------------------------
# Entrypoint for autoloader
proc ::pool::oo::class::classDescription::loadClass {} {}

# Request information about all superclasses
::pool::oo::class::azIndexEntry::loadClass
::pool::oo::class::problemsAndIndex::loadClass

# Integrate superclasses into definition
::pool::oo::support::FixReferences classDescription

# Create object instantiation procedure
interp alias {} classDescription {} ::pool::oo::support::New classDescription

# -------------------------------

