# -*- tcl -*-
# Automatically generated from file 'genericFormatter.cls'.
# Date: Mon Feb 15 19:28:22 MET 1999
# -------------------------------
# ** Do NOT edit manually **
#
# ** Provided class       **     >> genericFormatter <<
# -------------------------------

package require Pool_Base

# -------------------------------
# Namespace describing the class
namespace eval ::pool::oo::class::genericFormatter {
    variable  _superclasses    distInterface
    variable  _scChainForward  genericFormatter
    variable  _scChainBackward genericFormatter
    variable  _classVariables  {}
    variable  _methods         {MakeError ampersand caption chapter clear closePage commaList crError definitionList defterm defterm2 enumerate formattedRow formattedRowVar formattedTerm formattedTermVar getAnchor getString hrule imgDef imgRef item itemize link linkCommaList linkDef linkMail linkRef mailToDefterm markError missingDescError newPage pageFile par parbreak prepareForOutput quote section setAnchor sortByName sortedObjectList strong table table_data table_head table_row termVar write}

    variable  _variables
    array set _variables  {currentPage {genericFormatter {isArray 0 initialValue {}}} extension {genericFormatter {isArray 0 initialValue .}}}

    variable  _options
    array set _options  {outputdir {genericFormatter {-default {} -type ::pool::getopt::notype -action {} -class Outputdir}} ip {genericFormatter {-default {} -type ::pool::getopt::notype -action {} -class Ip}} adlocation {genericFormatter {-default {} -type ::pool::getopt::notype -action {} -class Adlocation}} replyaddr {genericFormatter {-default {} -type ::pool::getopt::notype -action {} -class Replyaddr}}}

    variable  _optionAliases
    array set _optionAliases {_ _}
    unset     _optionAliases(_)

    variable  _methodTable
    array set _methodTable  {hrule . MakeError . linkRef . sortByName . pageFile . definitionList . table_data . table_head . termVar . par . caption . enumerate . link . parbreak . commaList . imgRef . linkDef . section . quote . formattedTermVar . table_row . prepareForOutput . newPage . defterm2 . missingDescError . getAnchor . sortedObjectList . formattedRowVar . clear . table . linkMail . ampersand . closePage . imgDef . mailToDefterm . strong . crError . setAnchor . write . markError . linkCommaList . item . defterm . formattedTerm . getString . formattedRow . itemize . chapter .}

    # Export every method
    namespace export -clear *
}

# -------------------------------


proc ::pool::oo::class::genericFormatter::MakeError {category output error} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Internal method to generate a problem report. The report is added
	# @c to the object currently writing its documentation linking it to
	# @c the place of the problem.
	#
	# @a category: Category of the problem, either [strong desc] or
	# @a category: [strong crossref]
	# @a output: The text to print at the place of the problem.
	# @a error: The text to use in the problem report to describe it.
	#
	# @r a string containing the <a output> formatted as problem and having
	# @r an anchor the report can link to.

	set anchor xr[::pool::serial::new]

	[$dist theContext] addProblem desc $error "${currentPage}#${anchor}"
	$dist log error "${currentPage}#${anchor}: $error"

	# fake out the -ip mechanism, enforce evaluation here !

	set ipSave   $opt(-ip)
	set opt(-ip) {}

	set     result [$this getAnchor $anchor]
	append  result [$this markError $output]

	set opt(-ip) $ipSave

	return $result
}



proc ::pool::oo::class::genericFormatter::ampersand {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Writes an ampersand ([ampersand]) into the current page.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::caption {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table caption. The arguments before the script are
	# @c interpreted as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::chapter {title} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Adds a chapter <a title> to the current page.
	# @a title: The text of the title.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::clear {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Clear internal state, prepare for new scan.
	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::closePage {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Completes the generation of the current page

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::commaList {textList} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Takes the specified list of strings and converts it into a comma
	# @c separated list.
	# @a textList: List of strings.
	# @r a string separating the incoming texts by commas.

	return [join $textList ", "]
}



proc ::pool::oo::class::genericFormatter::crError {outputText errorText} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates a crossreference problem at the place of its calling.
	# @c Uses <m MakeError> as workhorse.
	#
	# @a outputText: The text to print at the place of the problem.
	# @a errorText:  The text to use in the problem report to describe it.

	return [MakeError crossref $outputText $errorText]
}



proc ::pool::oo::class::genericFormatter::definitionList {script} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as definition list.
	#
	# @a script: The tcl code to execute in the calling context.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::defterm {term text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates an item in a definition list.
	# @a term: The name of the thing to explain.
	# @a text: The text explaining the <a term>.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::defterm2 {term} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates an item in a definition list.
	# @a term: The name of the thing to explain. But without explanation.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::enumerate {script} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as enumerated list.
	#
	# @a script: The tcl code to execute in the calling context.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::formattedRow {term text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c See <m formattedTerm>, but writes out a table row, not a term of
	# @c a definition list.
	# @a term: The name of the thing to explain.
	# @a text: The text explaining the <a term>.

	$this table_row {
	    $this table_data colspan=3 {
		$this write "${term}: $text"
	    }
	}
	return
}



proc ::pool::oo::class::genericFormatter::formattedRowVar {term var} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Same as <m formattedRow>, but the explanation is specified as
	# @c name of a variable. An empty explanation causes the system to
	# @c ignore the call. Crossreferences are resolved too.
	#
	# @a term: The name of the thing to explain.
	# @a var:  The name of the variable containing the epxlanatory text.

	upvar $var v

	if {[string length $v] != 0} {
	    formattedRow $term [$dist crResolve $v]
	}

	return
}



proc ::pool::oo::class::genericFormatter::formattedTerm {term text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Like <m defterm>, but crossreferences in <a text> are resolved.
	# @a term: The name of the thing to explain.
	# @a text: The text explaining the <a term>.

	$this defterm $term [string trim [$dist crResolve $text]]
	return
}



proc ::pool::oo::class::genericFormatter::formattedTermVar {term var} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Same as <m formattedTerm>, but the explanation is specified as
	# @c name of a variable. An empty explanation causes the system to
	# @c ignore the call.
	#
	# @a term: The name of the thing to explain.
	# @a var:  The name of the variable containing the epxlanatory text.

	upvar $var v

	if {[string length $v] != 0} {
	    formattedTerm $term $v
	}

	return
}



proc ::pool::oo::class::genericFormatter::getAnchor {name} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates a <a name>d anchor and returns the HTML to the caller.
	# @a name: The name of the generated anchor.
	# @r the HTML string defining the <a name>d anchor.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::getString {script} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then returned
	# @c as the result of the call.
	#
	# @a script: The tcl code to execute in the calling context.
	# @r a string containing all output produced by the <a script>

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::hrule {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Writes a horizontal rule into the current page.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::imgDef {code text geometry imgfile} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Stores an hyperlink to an image under <a code>, allowing later
	# @c retrieval via <m imgRef>.
	#
	# @a code:     The identifier for storage and retrieval of the image
	# @a code:     link.
	# @a geometry: A list containing the width and height of the image, in
	# @a geometry: this order. Can be empty. Used to insert geometry
	# @a geometry: information into the link, for better display even if
	# @a geometry: the image is not loaded.
	# @a text:     Alternative text describing the contents of the picture.
	# @a imgfile:  The location to point at, i.e. the image file.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::imgRef {code} {
    ::pool::oo::support::SetupVars genericFormatter
    # @r the image link generated by <m imgDef> and then stored under
	# @r <a code>.
	#
	# @a code: The identifier for storage and retrieval of the image link.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::item {text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates an item in an itemized list.
	# @a text: The paragraph to format as item in the list.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::itemize {script} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as itemized list.
	#
	# @a script: The tcl code to execute in the calling context.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::link {text url} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Combines its arguments into a hyperlink having the <a text> and
	# @c pointing to the location specified via <a url>
	#
	# @a text: The string to use as textual part of the hyperlink.
	# @a url:  The location to point at.
	# @r the formatted hyperlink.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::linkCommaList {objList} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Takes the specified list of objects and converts it into a comma
	# @c separated list of hyperlinks to the pages describing them.
	# @a objList: List of object handles. The objects in it have to
	# @a objList: understand the [strong link] method.
	# @r a string containing several hyperlinks.

	set text ""

	foreach o $objList {
	    append text "[$o link], "
	}

	return [string trimright $text ", "]
}



proc ::pool::oo::class::genericFormatter::linkDef {code text url} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c The same as in <m link>, but the result is stored internally
	# @c instead, using <a code> as reference.
	#
	# @a code: The identifier for storage and retrieval of the hyperlink.
	# @a text: The string to use as textual part of the hyperlink.
	# @a url:  The location to point at.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::linkMail {prefix nameVar addrVar} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates hyperlink for name (in attr)
	#
	# @a prefix: String to write before the actual hyperlink
	# @a nameVar: Name of the variable containing the name to write.
	# @a addrVar: Name of the variable containing the address.
	# @r A string containing a hyperlink to the given mail address.


	upvar $nameVar nvar
	upvar $addrVar avar

	set name $nvar
	set addr $avar

	# remove address from name, no need for duplication
	regsub -- "$addr" $name {} name
	regsub -- {<>}    $name {} name
	set name [string trim $name]

	if {[string length $addr] != 0} {
	    return "$prefix [$this link $name "mailto:$addr"]"
	} else {
	    # no address available, therefore no hyperlink
	    return "$prefix [$this strong $name]"
	}

	return
}



proc ::pool::oo::class::genericFormatter::linkRef {code} {
    ::pool::oo::support::SetupVars genericFormatter
    # @r the hyperlink generated by <m linkDef> and then stored under
	# @r <a code>.
	#
	# @a code: The identifier for storage and retrieval of the hyperlink.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::mailToDefterm {prefix nameVar addrVar} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Writes hyperlink for a person and its mail address.
	#
	# @a prefix: String to write before the actual hyperlink
	# @a nameVar: Name of the variable containing the name to write.
	# @a addrVar: Name of the variable containing the address.

	upvar $nameVar nvar
	upvar $addrVar avar

	set name $nvar
	set addr $avar

	# remove address from name, no need for duplication
	regsub -- "$addr" $name {} name
	regsub -- {<>}    $name {} name
	set name [string trim $name]

	if {[string length $addr] != 0} {
	    $this defterm $prefix [$this link $name "mailto:$addr"]
	} else {
	    # no address available, therefore no hyperlink

	    $this defterm $prefix [$this strong $name]
	}

	return
}



proc ::pool::oo::class::genericFormatter::markError {text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Formats the incoming <a text> as error and returns the modified
	# @c information.
	#
	# @a text: The text to reformat.
	# @r a string containing the given <a text> formatted as error.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::missingDescError {errorText} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates a documention missing problem at the place of its
	# @c calling. Uses <m MakeError> as workhorse.
	#
	# @a errorText: The text to use in the problem report to describe it.

	return [MakeError desc {not documented} $errorText]
}



proc ::pool::oo::class::genericFormatter::newPage {file title {firstheading {}}} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Start a new page, implicitly completes the current page.
	# @a file:  name of file to contain the generated page
	# @a title: string to be used as title of the page
	# @a firstheading: string to use in toplevel heading. Defaults
	# @a firstheading: to <a title>. Required to allow hyperlinks
	# @a firstheading: in toplevel headings without violating
	# @a firstheading: HTML syntax in the title.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::pageFile {pageName} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Converts the name of page into the name of the file containing it.
	# @a pageName: Guess what :-)
	# @r the name of the file containing the specified page.

	return ${pageName}${extension}
}



proc ::pool::oo::class::genericFormatter::par {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Writes a paragraph into the current page, uses all arguments as
	# @c one string.
	#
	# @a args: The text to format and write as paragraph. Actually a list
	# @a args: of arguments put together into one string

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::parbreak {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Writes a paragraph break into the current page.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::prepareForOutput {} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Called just before the generation of output starts. Checks for the
	# @c existence of a target directory and creates it, if necessary.

	if {[string length $opt(-outputdir)] == 0} {
	    error "no target directory given"
	}

	if {! [file exists $opt(-outputdir)]} {
	    file mkdir $opt(-outputdir)
	}
}



proc ::pool::oo::class::genericFormatter::quote {string} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Takes the specified <a string>, add protective signs to all
	# @c character (sequences) having special meaning for the formatter
	# @c and returns the so enhanced text.
	#
	# @a string: The string to protect against interpretation by the
	# @a string: formatter.
	# @r a string containing no unprotected special character (sequences).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::section {title} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Adds a section <a title> to the current page.
	# @a title: The text of the title.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::setAnchor {name} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Generates a <a name>d anchor at the current location in the
	# @c current page.
	# @a name: The name of the generated anchor.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::sortByName {objList} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Sorts the specified list of objects alphabetically in ascending
	# @c order by the name of the objects.
	# @r the sorted list.
	# @a objList: List of object handles. The objects in it have to
	# @a objList: understand the [strong name] method.

	set olist ""
	foreach o $objList {
	    lappend olist [list [$o name] $o]
	}

	return [::pool::list::projection [lsort -index 0 $olist] 1]
}



proc ::pool::oo::class::genericFormatter::sortedObjectList {objlist} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Takes the specified list of objects, sorts them by name, then
	# @c generates a definition list containing hyperlinks to the object
	# @c pages as terms and their short descriptions as explanation.
	#
	# @a objlist: List of object handles. The objects in it have to
	# @a objlist: understand the methods [strong link] and [strong short].

	$this definitionList {
	    foreach obj [sortByName $objlist] {
		# Get short description from object
		# Use name and page to construct the hyperlink

		set shortDescription [$obj short]

		if {[string length $shortDescription] != 0} {
		    $this defterm [$obj link] [$dist crResolve $shortDescription]
		} else {
		    $this defterm2 [$obj link]
		}
	    }
	}

	return
}



proc ::pool::oo::class::genericFormatter::strong {text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Adds the appropriate formatting to the given <a text> to emphasize
	# @c it as strong, then returns the result.
	#
	# @a text: The string to mark as strong.
	# @r The emphasized <a text>.

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::table {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table. The arguments before the scripts are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::table_data {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table cell. The arguments before the script are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::table_head {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table cell formatted as heading. The arguments before the
	# @c script are interpreted as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::table_row {args} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table row. The arguments before the script are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	error "Abstract method called, was not overidden by subclass"
}



proc ::pool::oo::class::genericFormatter::termVar {term var} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Same as <m formattedTerm>, but the explanation is specified as
	# @c name of a variable. An empty explanation causes the system to
	# @c ignore the call. There is no crossreference resolution.
	#
	# @a term: The name of the thing to explain.
	# @a var:  The name of the variable containing the epxlanatory text.

	# var = member variable

	upvar $var v

	if {[string length $v] != 0} {
	    $this defterm $term $v
	}

	return
}



proc ::pool::oo::class::genericFormatter::write {text} {
    ::pool::oo::support::SetupVars genericFormatter
    # @c Has to write the specified <a text> into the current page.
	# @a text: The string to place into the current page.

	error "Abstract method called, was not overidden by subclass"
}



# -------------------------------
# Entrypoint for autoloader
proc ::pool::oo::class::genericFormatter::loadClass {} {}

# Request information about all superclasses
::pool::oo::class::distInterface::loadClass

# Integrate superclasses into definition
::pool::oo::support::FixReferences genericFormatter

# Create object instantiation procedure
interp alias {} genericFormatter {} ::pool::oo::support::New genericFormatter

# -------------------------------

