# -*- tcl -*-
# Automatically generated from file 'htmlFormatter.cls'.
# Date: Mon Feb 15 19:28:22 MET 1999
# -------------------------------
# ** Do NOT edit manually **
#
# ** Provided class       **     >> htmlFormatter <<
# -------------------------------

package require Pool_Base

# -------------------------------
# Global initialization code
# Hack. Create a dummy 'option' command to suppress the '::option'
	# alias of '::cgi_option', as '::option' is used by the OO kernel as
	# well, and the alias will interfere with that.

	if {[llength [info commands option]] == 0} {
	    proc option {} {}

	    package require cgi

	    # force cgi commands into the interpreter
	    catch {cgi_error_occurred}

	    rename option {}
	} else {
	    # Tk loaded, no need to fake out the cgi library

	    package require cgi
	    # force cgi commands into the interpreter
	    catch {cgi_error_occurred}
	}

# Namespace describing the class
namespace eval ::pool::oo::class::htmlFormatter {
    variable  _superclasses    genericFormatter
    variable  _scChainForward  htmlFormatter
    variable  _scChainBackward htmlFormatter
    variable  _classVariables  {}
    variable  _methods         {RecordPage ampersand caption chapter clear closePage constructor definitionList defterm defterm2 enumerate getAnchor getString hrule imgDef imgRef item itemize link linkDef linkRef markError newPage par parbreak quote section setAnchor strong table table_data table_head table_row write}

    variable  _variables
    array set _variables  {pages {htmlFormatter {isArray 1 initialValue {}}} footer {htmlFormatter {isArray 0 initialValue {}}}}

    variable  _options
    array set _options {_ _}
    unset     _options(_)

    variable  _optionAliases
    array set _optionAliases {_ _}
    unset     _optionAliases(_)

    variable  _methodTable
    array set _methodTable  {table . hrule . parbreak . imgRef . closePage . ampersand . linkRef . imgDef . strong . section . linkDef . definitionList . quote . constructor . getString . setAnchor . newPage . table_row . defterm2 . table_head . table_data . write . getAnchor . par . RecordPage . markError . enumerate . caption . link . chapter . itemize . defterm . item . clear .}

    # Export every method
    namespace export -clear *
}

# -------------------------------


proc ::pool::oo::class::htmlFormatter::RecordPage {pagefile} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Internal method used by <m newPage> to keep track of all generated
	# @c files. Trying to write a file twice causes an exception aborting
	# @c the engine.
	#
	# @a pagefile: The name of the to write.

	if {[::info exists pages($pagefile)]} {
	    error "page $pagefile already written"
	}

	set pages($pagefile) .
	return
}



proc ::pool::oo::class::htmlFormatter::ampersand {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Writes an ampersand ([ampersand]) into the current page.

	return [cgi_amp]
}



proc ::pool::oo::class::htmlFormatter::caption {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table caption. The arguments before the script are
	# @c interpreted as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	set script [::pool::list::pop args]
	if {[string length $opt(-ip)] > 0} {
	    eval cgi_caption $args [list [list $opt(-ip) eval $script]]
	} else {
	    uplevel cgi_caption $args [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::chapter {title} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Adds a chapter <a title> to the current page.
	# @a title: The text of the title.

	cgi_h1 $title
	return
}



proc ::pool::oo::class::htmlFormatter::clear {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Clear internal state, prepare for new scan.
	::pool::array::clear pages
}



proc ::pool::oo::class::htmlFormatter::closePage {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Completes the generation of the current page

	if {[string length $footer] == 0} {
	    set app  "AutoDoc 2.1"
	    set now  [::pool::date::now]
	    set user [cgi_link _ [::pool::misc::currentUser]  "mailto:$opt(-replyaddr)"]

	    if {[string length $opt(-adlocation)] != 0} {
		set app [cgi_link _ $app $opt(-adlocation)]
	    }

	    set footer "Generated by $app at $now, invoked by $user"
	}

	# auto footer (page generated by whom, where, when ?)
	cgi_hr
	cgi_p align=right $footer

	cgi_body_end
	cgi_html_end

	::pool::cgi::closePage

	set currentPage {}
	return
}



proc ::pool::oo::class::htmlFormatter::constructor {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Constructor, initializes the file extension.

	set extension .htm
}



proc ::pool::oo::class::htmlFormatter::definitionList {script} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as definition list.
	#
	# @a script: The tcl code to execute in the calling context.

	if {[string length $opt(-ip)] > 0} {
	    cgi_definition_list {
		$opt(-ip) eval $script
	    }
	} else {
	    uplevel cgi_definition_list [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::defterm {term text} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Generates an item in a definition list.
	# @a term: The name of the thing to explain.
	# @a text: The text explaining the <a term>.

	cgi_term            $term
	cgi_term_definition $text
	return
}



proc ::pool::oo::class::htmlFormatter::defterm2 {term} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Generates an item in a definition list.
	# @a term: The name of the thing to explain. But without explanation.

	cgi_term $term
	return
}



proc ::pool::oo::class::htmlFormatter::enumerate {script} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as itemized list.
	#
	# @a script: The tcl code to execute in the calling context.

	if {[string length $opt(-ip)] > 0} {
	    cgi_number_list {
		$opt(-ip) eval $script
	    }
	} else {
	    uplevel cgi_number_list [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::getAnchor {name} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Generates a <a name>d anchor and returns the HTML to the caller.
	# @a name: The name of the generated anchor.
	# @r the HTML string defining the <a name>d anchor.

	return [cgi_anchor_name $name]
}



proc ::pool::oo::class::htmlFormatter::getString {script} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then returned
	# @c as the result of the call.
	#
	# @a script: The tcl code to execute in the calling context.
	# @r a string containing all output produced by the <a script>

	if {[string length $opt(-ip)] > 0} {
	    return [::pool::cgi::getString {
		$opt(-ip) eval $script
	    }] ;#{}
	} else {
	    return [::pool::cgi::getString {
		uplevel $script
	    }] ;#{}
	}
}



proc ::pool::oo::class::htmlFormatter::hrule {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Writes a horizontal rule into the current page.

	cgi_hr
	return
}



proc ::pool::oo::class::htmlFormatter::imgDef {code text geometry imgfile} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Stores an hyperlink to an image under <a code>, allowing later
	# @c retrieval via <m imgRef>.
	#
	# @a code:     The identifier for storage and retrieval of the image
	# @a code:     link.
	# @a text:     Alternative text describing the contents of the picture.
	# @a geometry: A list containing the width and height of the image, in
	# @a geometry: this order. Can be empty. Used to insert geometry
	# @a geometry: information into the link, for better display even if
	# @a geometry: the image is not loaded.
	# @a imgfile:  The location to point at, i.e. the image file.

	set w [lindex $geometry 0]
	set h [lindex $geometry 1]

	if {([string length $w] == 0) || ([string length $h] == 0)} {
	    cgi_imglink $code $imgfile "alt=$text"
	} else {
	    cgi_imglink $code $imgfile "alt=$text" "width=$w" "height=$h"
	}
	return
}



proc ::pool::oo::class::htmlFormatter::imgRef {code} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @r the image link generated by <m imgDef> and then stored under
	# @r <a code>.
	#
	# @a code: The identifier for storage and retrieval of the image link.

	return [cgi_imglink $code]
}



proc ::pool::oo::class::htmlFormatter::item {text} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Generates an item in an itemized list.
	# @a text: The paragraph to format as item in the list.

	cgi_li $text
	return
}



proc ::pool::oo::class::htmlFormatter::itemize {script} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified <a script> in the calling context and
	# @c captures any generated output in a string, which is then formatted
	# @c as itemized list.
	#
	# @a script: The tcl code to execute in the calling context.

	if {[string length $opt(-ip)] > 0} {
	    cgi_bullet_list {
		::$opt(-ip) eval $script
	    }
	} else {
	    uplevel cgi_bullet_list [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::link {text url} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Combines its arguments into a hyperlink having the <a text> and
	# @c pointing to the location specified via <a url>
	#
	# @a text: The string to use as textual part of the hyperlink.
	# @a url:  The location to point at.
	# @r the formatted hyperlink.

	return [cgi_link _ $text $url]
}



proc ::pool::oo::class::htmlFormatter::linkDef {code text url} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c The same as in <m link>, but the result is stored internally
	# @c instead, using <a code> as reference.
	#
	# @a code: The identifier for storage and retrieval of the hyperlink.
	# @a text: The string to use as textual part of the hyperlink.
	# @a url:  The location to point at.

	cgi_link $code $text $url
	return
}



proc ::pool::oo::class::htmlFormatter::linkRef {code} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @r the hyperlink generated by <m linkDef> and then stored under
	# @r <a code>.
	#
	# @a code: The identifier for storage and retrieval of the hyperlink.

	return [cgi_link $code]
}



proc ::pool::oo::class::htmlFormatter::markError {text} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Formats the incoming <a text> as error and returns the modified
	# @c information.
	#
	# @a text: The text to reformat.
	# @r a string containing the given <a text> formatted as error.

	return [cgi_font color=red $text]
}



proc ::pool::oo::class::htmlFormatter::newPage {file title {firstheading {}}} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Start a new page, implicitly completes the current page.
	# @a file:  name of file to contain the generated page
	# @a title: string to be used as title of the page
	# @a firstheading: string to use in toplevel heading. Defaults
	# @a firstheading: to <a title>. Required to allow hyperlinks
	# @a firstheading: in toplevel headings without violating
	# @a firstheading: HTML syntax in the title.

	RecordPage $file
	set currentPage $file

	if {[string length $firstheading] == 0} {
	    set firstheading $title
	}


	if {[string compare [file extension $file] ".htm"] != 0} {
	    set file ${file}.htm
	}

	::pool::cgi::openPage [file join $opt(-outputdir) $file]

	cgi_html_start
	cgi_title $title
	cgi_body_start

	cgi_h1 $firstheading
	return
}



proc ::pool::oo::class::htmlFormatter::par {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Writes a paragraph into the current page, uses all arguments as
	# @c one string.
	#
	# @a args: The text to format and write as paragraph. Actually a list
	# @a args: of arguments put together into one string

	eval cgi_p $args
	return
}



proc ::pool::oo::class::htmlFormatter::parbreak {} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Writes a paragraph break into the current page.

	cgi_br
	return
}



proc ::pool::oo::class::htmlFormatter::quote {string} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Takes the specified <a string>, add protective signs to all
	# @c character (sequences) having special meaning for the formatter
	# @c and returns the so enhanced text.
	#
	# @a string: The string to protect against interpretation by the
	# @a string: formatter.
	# @r a string containing no unprotected special character (sequences).

	return [cgi_quote_html $string]
}



proc ::pool::oo::class::htmlFormatter::section {title} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Adds a section <a title> to the current page.
	# @a title: The text of the title.

	cgi_h2 $title
	return
}



proc ::pool::oo::class::htmlFormatter::setAnchor {name} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Generates a <a name>d anchor at the current location in the
	# @c current page.
	# @a name: The name of the generated anchor.

	# @d Usable only in conjunction with cgi 0.7,
	# @d and not cgi 0.4, as for earlier versions of autodoc.

	cgi_puts [cgi_anchor_name $name]
	return
}



proc ::pool::oo::class::htmlFormatter::strong {text} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Adds the appropriate formatting to the given <a text> to emphasize
	# @c it as strong, then returns the result.
	#
	# @a text: The string to mark as strong.
	# @r The emphasized <a text>.

	return [cgi_bold $text]
}



proc ::pool::oo::class::htmlFormatter::table {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table. The arguments before the scripts are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	set script [::pool::list::pop args]

	if {[string length $opt(-ip)] > 0} {
	    eval cgi_table $args [list [list $opt(-ip) eval $script]]
	} else {
	    uplevel cgi_table $args [list $script]
	}

	return
}



proc ::pool::oo::class::htmlFormatter::table_data {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table cell. The arguments before the script are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	set script [::pool::list::pop args]
	if {[string length $opt(-ip)] > 0} {
	    eval cgi_table_data $args [list [list $opt(-ip) eval $script]]
	} else {
	    uplevel cgi_table_data $args [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::table_head {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table cell formatted as heading. The arguments before the
	# @c script are interpreted as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	set script [::pool::list::pop args]
	if {[string length $opt(-ip)] > 0} {
	    eval cgi_table_head $args [list [list $opt(-ip) eval $script]]
	} else {
	    uplevel cgi_table_head $args [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::table_row {args} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Executes the specified script (last argument) in the calling
	# @c context, captures the produced formatted text and organizes it
	# @c into a table row. The arguments before the script are interpreted
	# @c as 'name=value'-style parameterization.
	#
	# @a args: A list of 'name=value' parameters and a script to evaluate
	# @a args: in the calling context (last element).

	set script [::pool::list::pop args]
	if {[string length $opt(-ip)] > 0} {
	    eval cgi_table_row $args [list [list $opt(-ip) eval $script]]
	} else {
	    uplevel cgi_table_row $args [list $script]
	}
	return
}



proc ::pool::oo::class::htmlFormatter::write {text} {
    ::pool::oo::support::SetupVars htmlFormatter
    # @c Has to write the specified <a text> into the current page.
	# @a text: The string to place into the current page.

	cgi_puts $text
	return
}



# -------------------------------
# Entrypoint for autoloader
proc ::pool::oo::class::htmlFormatter::loadClass {} {}

# Request information about all superclasses
::pool::oo::class::genericFormatter::loadClass

# Integrate superclasses into definition
::pool::oo::support::FixReferences htmlFormatter

# Create object instantiation procedure
interp alias {} htmlFormatter {} ::pool::oo::support::New htmlFormatter

# -------------------------------

