# -*- tcl -*-
# Automatically generated from file 'proc.cls'.
# Date: Mon Feb 15 19:28:22 MET 1999
# -------------------------------
# ** Do NOT edit manually **
#
# ** Provided class       **     >> procDescription <<
# -------------------------------

package require Pool_Base

# -------------------------------
# Namespace describing the class
namespace eval ::pool::oo::class::procDescription {
    variable  _superclasses    {azIndexEntry problems}
    variable  _scChainForward  procDescription
    variable  _scChainBackward procDescription
    variable  _classVariables  {}
    variable  _methods         {Anchor ArgDescription ArgName PostProcessInformation ProcDescription ReportSpamArguments WriteArgumentsAsList WriteArgumentsAsTable WriteAsTable WriteStandard addProblem authorSet completeKwIndex constructor firstLetter getPage hasArgument keywords pPage scan write}

    variable  _variables
    array set _variables  {keywords {procDescription {isArray 0 initialValue {}}} argDef {procDescription {isArray 1 initialValue {}}} anchor {procDescription {isArray 0 initialValue {}}} comment {procDescription {isArray 0 initialValue {}}} note {procDescription {isArray 0 initialValue {}}} result {procDescription {isArray 0 initialValue {}}} authorAddress {procDescription {isArray 0 initialValue {}}} danger {procDescription {isArray 0 initialValue {}}} authorName {procDescription {isArray 0 initialValue {}}} arglist {procDescription {isArray 0 initialValue {}}}}

    variable  _options
    array set _options  {table {procDescription {-default 0 -type ::pool::getopt::notype -action {} -class Table}} args {procDescription {-default {} -type ::pool::getopt::notype -action {} -class Args}} body {procDescription {-default {} -type ::pool::getopt::notype -action {} -class Body}} parent {procDescription {-default {} -type ::pool::getopt::notype -action {} -class Parent}}}

    variable  _optionAliases
    array set _optionAliases {_ _}
    unset     _optionAliases(_)

    variable  _methodTable
    array set _methodTable  {firstLetter . keywords . ProcDescription . PostProcessInformation . Anchor . ArgName . pPage . scan . constructor . WriteArgumentsAsList . addProblem . write . ReportSpamArguments . completeKwIndex . WriteStandard . getPage . WriteArgumentsAsTable . ArgDescription . authorSet . hasArgument . WriteAsTable .}

    # Export every method
    namespace export -clear *
}

# -------------------------------


proc ::pool::oo::class::procDescription::Anchor {} {
    ::pool::oo::support::SetupVars procDescription
    # @r The name of the anchor at the start of the procedure description.

	if {[string length $anchor] == 0} {
	    set anchor p[::pool::serial::new]
	}

	return $anchor
}



proc ::pool::oo::class::procDescription::ArgDescription {a} {
    ::pool::oo::support::SetupVars procDescription
    # @c Internal method used by all procedures generating a formatted
	# @c procedure description.
	# @r the description of the given <a a>rgument or an error text.
	#
	# @a a: The name of the procedure argument to look at.

	if {[string length $argDef($a,comment)] == 0} {

	    return [$fmt missingDescError  "Argument [$fmt markError $a] not documented"]
	} else {
	    return [$dist crResolve $argDef($a,comment)]
	}
}



proc ::pool::oo::class::procDescription::ArgName {a} {
    ::pool::oo::support::SetupVars procDescription
    # @c Internal method used by all procedures generating a formatted
	# @c procedure description.
	# @r the given <a a>rgument itself, or the argument with its
	# @r defaultvalue attached to it.
	#
	# @a a: The name of the procedure argument to look at.

	if {$argDef($a,default)} {
	    # Argument has default value, add this to the name

	    if {[string length $argDef($a,defaultValue)] == 0} {
		return "$a (= \{\})"
	    } else {
		return "$a (= $argDef($a,defaultValue))"
	    }
	} else {
	    # Simple argument without default

	    return $a
	}
}



proc ::pool::oo::class::procDescription::PostProcessInformation {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Called to streamline the extracted embedded documentation.
	# @c This mainly consists of removing superfluous whitespace.
	# @c Additionally converts a comma separated list of index
	# @c phrases into a real tcl list.

	foreach i {comment danger note result} {
	    set text [::pool::string::removeWhitespace [set $i]]
	    set $i   [string trim [::pool::string::oneLine $text]]
	}

	foreach aName $arglist {
	    set argComment  [::pool::string::removeWhitespace $argDef($aName,comment)]

	    set argDef($aName,comment)  [string trim [::pool::string::oneLine $argComment]]
	}

	set keywords [::pool::string::removeWhitespace $keywords]
	set keywords [split [string trim $keywords ", \t"] ,]

	while {[::pool::list::delete keywords {}]} {}
	return
}



proc ::pool::oo::class::procDescription::ProcDescription {} {
    ::pool::oo::support::SetupVars procDescription
    # @r a string containing the documentation of this procedure or an
	# @r error text.

	if {[string length $comment] == 0} {
	    return [$fmt missingDescError "Documentation missing"]
	} else {
	    return [$dist crResolve $comment]
	}
}



proc ::pool::oo::class::procDescription::ReportSpamArguments {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Report all arguments which were documented, but are
	# @c no arguments of the procedure.

	foreach key [array names argDef *,comment] {
	    set arg [lindex [split $key ,] 0]

	    if {[lsearch -exact $arglist $arg] < 0} {
		addProblem crossref  "Documented undefined argument [$fmt markError $arg]"  "[page]"
	    }
	}
	return
}



proc ::pool::oo::class::procDescription::WriteArgumentsAsList {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Generates a definition list describing the arguments of this
	# @c procedure.

	if {[llength $arglist] != 0} {
	    $fmt defterm Arguments [$fmt getString {
		$fmt definitionList {
		    foreach a $arglist {
			$fmt defterm [ArgName $a] [ArgDescription $a]
		    }
		}
	    }] ;#{}
	}
	return
}



proc ::pool::oo::class::procDescription::WriteArgumentsAsTable {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Generates a table describing the arguments of this procedure.

	if {[llength $arglist] != 0} {
	    foreach a $arglist {
		$fmt table_row {
		    $fmt table_data {
			$fmt write "[$fmt strong Argument]: [ArgName $a]"
		    }
		    $fmt table_data colspan=2 {
			$fmt write [ArgDescription $a]
		    }
		}
	    }
	}
	return
}



proc ::pool::oo::class::procDescription::WriteAsTable {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Generates the formatted text describing the procedure. This
	# @c method generates a tabular formatting.

	$fmt par [$fmt getString {
	    $fmt table border width=100% {
		# name
		$fmt table_row {
		    $fmt table_data colspan=3 {
			$fmt section "[name] ($arglist)"
		    }
		}

		# author reference
		if {[string compare $authorName [$opt(-parent) author]] != 0} {
		    $fmt table_row {
			$fmt table_data colspan=3 {
			    $fmt write  [$fmt linkMail [$fmt strong by]  authorName authorAddress]
			}
		    }
		}

		# description sections
		if {
		    ([string length $comment]  != 0) ||
		    (([string length $comment] == 0) &&
		     ([string length $result]  == 0))
		} {
		    # write comment section if text present or neither
		    # description nor description of result in existence.
		    # Result: A missing description is tolerated if a
		    # return value was described. It is assumed that this
		    # description is sufficient.
		    
		    $fmt table_row {
			$fmt table_data colspan=3 {
			    $fmt write [ProcDescription]
			}
		    }
		}

		$fmt formattedRowVar [$fmt strong Dangers] danger
		$fmt formattedRowVar [$fmt strong Notes]   note

		WriteArgumentsAsTable

		$fmt formattedRowVar [$fmt strong Returns] result
	    }
	}] ;#{}

	return
}



proc ::pool::oo::class::procDescription::WriteStandard {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Generates the formatted text describing the procedure. This
	# @c method generates a definition list.

	$fmt definitionList {
	    $fmt defterm [$fmt strong "[name] ($arglist)"] [$fmt getString {
		$fmt definitionList {
		    if {
			([string length $comment]  != 0) ||
			(([string length $comment] == 0) &&
			 ([string length $result]  == 0))
		    } {
			# write comment section if text present or neither
			# description nor description of result in existence.
			# Result: A missing description is tolerated if a
			# return value was described. It is assumed that this
			# description is sufficient.

			$fmt defterm Description [ProcDescription]
		    }

		    $fmt formattedTermVar Dangers danger
		    $fmt formattedTermVar Notes   note
		    
		    WriteArgumentsAsList

		    $fmt formattedTermVar Result  result

		    if {[string compare $authorName [$opt(-parent) author]] != 0} {
			$fmt mailToDefterm "Written by"  authorName authorAddress
		    }
		}
	    }] ;#{}
	}
	return
}



proc ::pool::oo::class::procDescription::addProblem {category errortext url} {
    ::pool::oo::support::SetupVars procDescription
    # @c Overides the baseclass functionality (<m problems:addProblem>) to
	# @c allow the procedure to signal itself as problematic to its parent
	# @c (file or class).
	#
	# @a category:  Either [strong crossref] or [strong desc].
	# @a errortext: A description of the problem.
	# @a url:       Reference to the place of the problem.

	if {[numProblems] == 0} {
	    $opt(-parent) addProblemObject $this
	}

	problems_addProblem $category $errortext $url
	return
}



proc ::pool::oo::class::procDescription::authorSet {author} {
    ::pool::oo::support::SetupVars procDescription
    # @c Called by the containing file or class to propagate its author
	# @c information.
	#
	# @a author:  Author of containing file.

	if {[string length $authorName] == 0} {
	    set authorName $author
	}

	set currentAddr   [::pool::misc::currentAddress]
	set authorAddress [::pool::mail::addressB $authorName $currentAddr]
	return
}



proc ::pool::oo::class::procDescription::completeKwIndex {phrases} {
    ::pool::oo::support::SetupVars procDescription
    # @c Called by the containing file (or class) to propagate its
	# @c indexing information.
	#
	# @a phrases: List of index phrases used by the containing file
	# @a phrases: or class.

	# no propogation if we have our own keywords.

	if {[llength $keywords] != 0} {
	    return
	}

	set keywords $phrases
	return
}



proc ::pool::oo::class::procDescription::constructor {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Constructor. Initializes the parser functionality in
	# @c <f lib/procParse.tcl>.

	pd_util_init
	return
}



proc ::pool::oo::class::procDescription::firstLetter {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Overides base classs functionality (<m azIndexEntry:firstLetter>)
	# @c to use the first letter of the actual procedure as indexing
	# @c criterium, [strong not] the first letter of the namespace path.

	set pname [lindex [split $opt(-name) :] end]

	regexp -- {^[^a-zA-Z]*([a-zA-Z])} $pname dummy letter
	return $letter
}



proc ::pool::oo::class::procDescription::getPage {} {
    ::pool::oo::support::SetupVars procDescription
    # @r The url of the page containing the procedure description.

	return [$opt(-parent) page]#[Anchor]
}



proc ::pool::oo::class::procDescription::hasArgument {a} {
    ::pool::oo::support::SetupVars procDescription
    # @c Checks wether the procedure has an argument named <a a>.
	# @a a: The name of the possible argument to this procedure.
	# @r A boolean value. True if <a a> is an argument of this procedure,
	# @r or else False.

	return [::info exists argDef($a,default)]
}



proc ::pool::oo::class::procDescription::keywords {} {
    ::pool::oo::support::SetupVars procDescription
    # @r The list of keywords this procedure is indexed under.
	return $keywords
}



proc ::pool::oo::class::procDescription::pPage {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Special part of the problem reporting facility. Used by the
	# @c procedures parent to get a handle on the exact location of the
	# @c detailed problem description.
	# @r a reference to the exact location of the detailed problem
	# @r description for this procedure.

	return [$opt(-parent) pPage]#$this
}



proc ::pool::oo::class::procDescription::scan {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Scans the procedure body for embedded documentation.

	# i. argument list
	foreach a $opt(-args) {
	    if {[llength $a] == 2} {
		set aname [lindex $a 0]
		set argDef($aname,default) 1
		set argDef($aname,defaultValue) [lindex $a 1]
	    } else {
		set aname $a
		set argDef($aname,default) 0
	    }

	    lappend arglist $aname
	    set argDef($aname,comment) ""
	}

	# ii. now get the information contained in comments
	#     inside the procedure body, just like for files

	set opt(-body) [split $opt(-body) \n]
	while {[llength $opt(-body)] > 0} {
	    set line [::pool::list::shift opt(-body)]
	    set line [string trim $line]
	    if {![regexp ^# $line]} {continue}
	    set line [string trimleft $line "#\t "]
	    if {![regexp ^@ $line]} {continue}
	    set line [string trimleft $line "@"]

	    regexp -indices "^(\[^ \t\]*)" $line dummy word
	    set start [lindex $word 0]
	    set end   [lindex $word 1]

	    set cmd  [string range $line $start $end]
	    set line [string range $line [incr end] end]

	    if {[llength [::info command pd_$cmd]] == 0} {
		continue
	    }

	    pd_$cmd [string trim $line]
	}

	PostProcessInformation
	return
}



proc ::pool::oo::class::procDescription::write {} {
    ::pool::oo::support::SetupVars procDescription
    # @c Generates the formatted text describing this procedure.
	# @c In contrast to files, packages and classes no separate page is
	# @c written. As this method is called from inside
	# @c <m fileDescription:write> (or <m classDescription:write>) the
	# @c description will go into this page. This is reflected by
	# @c <m pPage> too!

	# @n Dependent on the configuration either <m WriteStandard> or
	# @n <m WriteAsTable> is called to do the real work.

	#puts "$this writing html"

	$dist pushContext $this
	$fmt setAnchor [Anchor]

	if {$opt(-table)} {
	    WriteAsTable
	} else {
	    WriteStandard
	}

	ReportSpamArguments

	$dist popContext
	return
}



# -------------------------------
# Entrypoint for autoloader
proc ::pool::oo::class::procDescription::loadClass {} {}

# Request information about all superclasses
::pool::oo::class::azIndexEntry::loadClass
::pool::oo::class::problems::loadClass

# Integrate superclasses into definition
::pool::oo::support::FixReferences procDescription

# Create object instantiation procedure
interp alias {} procDescription {} ::pool::oo::support::New procDescription

# -------------------------------

