# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: engine.tcl,v 1.6 1998/06/04 20:10:07 aku Exp $
#
# @c Interface exported to the users of the package.
# @c Contains the glue to read, query, use the defined
# @c retrievers, packers and transports.
# @s Exported interface
# @i interface, initialization, plugin management
# --------------------------------------------------
package require Tcl        8.0
package require Pool_Base

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace export *
}


proc ::makedist::do {args} {
    # @c Main procedure. This one must be called to
    # @c generate a complete distribution.

    # @a args: List of option/value pairs, followed by
    # @a args: the name of the module to work upon.
    # @a args: Recognized options are -version,
    # @a args: -retriever, -packer, -transport and
    # @a args: -builddir.

    global env

    set fDefault [file join $env(HOME) .mkd[pid]]

    ::pool::array::def        oDef
    ::pool::getopt::defOption oDef version
    ::pool::getopt::defOption oDef builddir  -d $fDefault
    ::pool::getopt::defOption oDef retriever -t ::makedist::isRetriever
    ::pool::getopt::defOption oDef packer    -t ::makedist::isPackerList
    ::pool::getopt::defOption oDef transport -t ::makedist::isTransport

    # caller configuration
    ::pool::array::def                             opt
    set args   [::pool::getopt::process oDef $args opt]

    # sanity checks
    if {[llength $args] == 0} {
	error "makedist: no module specified"
    }

    set opt(-module) [lindex $args 0]

    set make_builddir 0

    if {! [file exists $opt(-builddir)]} {
	set make_builddir 1
    } elseif {! [file isdirectory $opt(-builddir)]} {
	error "makedist: $opt(-builddir) is not a directory"
    }

    # prepare environment

    if {[string length $opt(-version)] == 0} {
	Log notice building distribution of $opt(-module)
    } else {
	Log notice building distribution of $opt(-module) $opt(-version)
    }

    if {$make_builddir} {
	file mkdir $opt(-builddir)
    }

    set here [pwd]

    # here comes the action
    set fail [catch {
	cd $opt(-builddir)

	::makedist::retrieve  opt
	::makedist::prepare   opt
	::makedist::pack      opt

	cd $here
	::makedist::transport opt
    } msg]	;#{}

    cd $here
    if {$fail} {
	global errorInfo

	Log error $msg $errorInfo
    }

    # cleanup, if necessary
    if {$make_builddir} {
	file delete -force $opt(-builddir)
    }

    Log notice ...distribution complete
    return
}


proc ::makedist::Log {level args} {
    # @c Internal log facility. Prepends 'makedist' to the incoming message
    # @c before logging it via the standard syslog facility of <d Pool>.
    #
    # @a level: Relative importance of the logged message. Should be one of the
    # @a level: strings returned by '::pool::syslog::levels'.
    #
    # @a args: list containing the texts to log.

    ::pool::syslog::syslog $level makedist $args
    return
}
