# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: pack.tcl,v 1.5 1998/06/04 20:10:08 aku Exp $
#
# @c Packaging of a retrieved and prepared modules.
# @s Executes packing plugins
# @i packer
# --------------------------------------------------

package require Tcl        8.0
package require Pool_Base

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace export *
}


proc ::makedist::pack {opt} {
    # @c Common interface to all packer plugins. Essentially forwards the
    # @c request to the chosen packer procedures. The only exception to this:
    # @c This procedure deletes the packed directory after the calls!
    #
    # @n Assumes that the working directory is set to be the build directory.
    # @n The called packer must not change the working directory.
    #
    # @a opt: Name of the array variable containing the configuration to be
    # @a opt: used. Required entries are packer and module.

    upvar $opt o

    set p $o(-packer)
    set m $o(-module)

    # loop is possible due to the packer not making changes to the
    # working directory. we should play it safe nevertheless!

    foreach pkg $p {
	Log info packing $m with [packerName $pkg]
	::makedist::plugin::packer::$pkg  $m
    }

    # We are about to delete the temp. directory, enforce writability of
    # the complete directory hierarchy.

    # @d The usage of 'chmod' generates a dependency on unix.

    exec chmod -R u+rwx $m
    file delete -force  $m
    return
}
