# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: retrieve.tcl,v 1.6 1998/06/04 20:10:08 aku Exp $
#
# @c Retrieval of modules from a repository.
# @s Executes module retrieval
# @i retrieval, repository
# --------------------------------------------------

package require Tcl        8.0
package require Pool_Base

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace export *
}


proc ::makedist::retrieve {opt} {
    # @c Common interface to all retriever plugins. Essentially forwards the
    # @c request to the chosen retriever procedure. Has to retrieve the
    # @c head-version if the specified version is empty.
    #
    # @n Assumes that the working directory is set to be the build directory.
    # @n The called retriever must not change the working directory.
    #
    # @a opt: Name of the array variable containing the configuration to be
    # @a opt: used. Required entries are retriever, module and version.

    upvar $opt o

    set v $o(-version)
    set r $o(-retriever)
    set m $o(-module)

    if {[string length $v] == 0} {
	Log info retrieve $m    from [retrieverName $r]
    } else {			      
	Log info retrieve $m $v from [retrieverName $r]
    }

    ::makedist::plugin::retriever::$r  $m $v
    return
}
