# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: transport.tcl,v 1.5 1998/06/04 20:10:08 aku Exp $
#
# @c Transport of generated archive(s) to destination.
# @s Executes transport
# @i transport
# --------------------------------------------------

package require Tcl        8.0
package require Pool_Base

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace export *
}


proc ::makedist::transport {opt} {
    # @c Common interface to all transport plugins. Essentially forwards the
    # @c request to the chosen transporter procedure.
    #
    # @n In contrast to <p ::makedist::retrieve>, <p ::makedist::prepare>
    # @n and <p ::makedist::pack> this procedure does not assume to be in the
    # @n build directory. The called transporter must not change the working
    # @n directory.
    #
    # @a opt: Name of the array variable containing the configuration to be
    # @a opt: used. Required entries are transport and module.

    upvar $opt o

    set t $o(-transport)
    set m $o(-module)

    Log info transporting $m via [transportName $t]

    ::makedist::plugin::transport::$t $m $o(-builddir)
    return
}
