# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: announce.tcl,v 1.3 1998/06/02 16:59:17 aku Exp $
#
# @c Generate announcement from description and short changelog.
# @s Generate ANNOUNCE file
# @i prepare support, announce generation
# --------------------------------------------------


proc mGenerateANNOUNCE {} {
    # @c Generates announcement from description and short changelog.

    global mDesc mName mFullVersion mDate

    mLog info creating ANNOUNCEment...


    set   fh [open ANNOUNCE w]
    puts $fh "Hello world,\n"
    puts $fh "I hereby announce $mName $mFullVersion."
    puts $fh "It is $mDesc(description)\n"

    if {[file exists ChangeLog.short]      &&
       ![file isdirectory ChangeLog.short] &&
        [file readable ChangeLog.short]} {
	set f [open ChangeLog.short r]
	set t [read $f]
	close $f

	set start [string first "Changes from" $t]
	set end $start
	incr end
	set offset [string first "Changes from" [string range $t $end end]]

	if {$offset < 0} {
	    set end end
	} else {
	    incr end $offset
	    incr end -1
	}

	puts $fh [string trim [string range $t $start $end]]
	unset t
    }

    puts  $fh "\n"
    puts  $fh [mUrls2Text]
    close $fh
    return
}
