# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: autodoc.tcl,v 1.6 1998/06/04 20:10:11 aku Exp $
#
# @c Uses the <dep AutoDOC> package to generate documentation
# @c out of annotated tcl sources.
# @s Generating documentation with <dep AutoDOC>.
# @i prepare support, autodoc, documentation
# --------------------------------------------------

package require Tcl      8.0
package require AutoDOC
package require Pool_Base


proc mAutodoc {args} {
    # @c Generates documentation with <dep AutoDOC>.
    # @c Configuration of the engine is done via hardwired
    # @c defaults, resource file <f ~/.autodocrc> and the
    # @c options given in <a args>.
    # @a args: List of option/value pairs. Recognized are
    # @a args: -srcdir, -tables, -htmldir and -replyaddr.

    global env

    mLog info generate documentation...
    mLog info args = $args

    ::pool::array::def        oDef
    ::pool::getopt::defOption oDef srcdir     -d [pwd]
    ::pool::getopt::defOption oDef outputdir  -d [file join [pwd] html]
    ::pool::getopt::defOption oDef replyaddr  -d [::pool::misc::currentAddress]
    ::pool::getopt::defOption oDef tables     -d 1 -t ::pool::getopt::boolean
    ::pool::getopt::defOption oDef psort      -d 1 -t ::pool::getopt::boolean
    ::pool::getopt::defOption oDef ptable     -d 1 -t ::pool::getopt::boolean
    ::pool::getopt::defOption oDef up-title   -d ""
    ::pool::getopt::defOption oDef up-link    -d ""
    ::pool::getopt::defOption oDef up-image   -d ""
    ::pool::getopt::defOption oDef up-imglink -d 0

    foreach opt {
	replyaddr tables psort ptable up-title up-image up-link up-imglink
    } {
	proc $opt {v} "upvar oDef oDef; ::pool::getopt::changeDefault oDef $opt \$v"
    }

    # user dependent configuration
    catch {source [file join $env(HOME) .autodocrc]}

    foreach opt {
	replyaddr tables psort ptable up-title up-image up-link up-imglink
    } {
	rename $opt {}
    }

    # caller configuration
    ::pool::array::def                    opt
    ::pool::getopt::initValues oDef       opt
    ::pool::getopt::processOpt oDef $args opt

    # log found arguments
    foreach item [array names opt] {
	mLog info "$item \t= $opt($item)"
    }

    set d dist[::pool::serial::new]

    distribution $d                       \
	    -srcdir     $opt(-srcdir)     \
	    -outputdir  $opt(-outputdir)  \
	    -replyaddr  $opt(-replyaddr)  \
	    -tables     $opt(-tables)     \
	    -psort      $opt(-psort)      \
	    -ptable     $opt(-ptable)     \
	    -up-title   $opt(-up-title)   \
	    -up-image   $opt(-up-image)   \
	    -up-link    $opt(-up-link)    \
	    -up-imglink $opt(-up-imglink)

    $d configure -formatter [htmlFormatter ${d}_HtmlOut]
    $d scan
    $d delete
    return
}
