# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: base.tcl,v 1.3 1998/06/04 20:10:11 aku Exp $
#
# @c Basic supporting commands.
# @s Base commands
# @i support, base support
# --------------------------------------------------

package require Tcl      8.0
package require Pool_Base


proc mExclude {args} {
    # @c Removes the files specified in <a args> from the distribution
    # @c directory. 
    #
    # @a args: List of files and/or directories to remove from the
    # @a args: distribution.
    #
    # @future Should check for paths refering to files outside
    # @future the distribution directory and reject these.

    if {[llength $args] == 0} {
	return
    }

    mLog info Removing files $args

    eval file delete -force $args
    return
}



proc mInsertInfo {args} {
    # @c Inserts the information contained in the array 'mInfo' into the files
    # @c named in <a args>.
    #
    # @a args: list of files to manipulate
    #
    # @future Should check for paths refering to files outside
    # @future the distribution directory and reject these.

    global mInfo

    if {[llength $args] == 0} {
	return
    }

    mLog info Tweaking $args

    foreach file $args {
	::pool::string::multipleReplaceInFile $file mInfo
    }
    return
}



proc mConfigure {args} {
    # @c Executes 'autoconf' in all directories named in the list <a args>.
    # @n Requires existence of 'autoconf' command, must be found in the path.
    # @d Restricted to usage on a unix system, because <f /dev/null> is used
    # @d here.
    # @a args: List of directories to configure.
    #
    # @future Should check for paths refering to directories outside
    # @future the distribution directory and reject these.

    if {[llength $args] == 0} {
	return
    }

    mLog info Generating configure scripts for $args

    set here [pwd]

    foreach dir $args {
	cd $dir
	set fail [catch {exec autoconf 2>/dev/null >/dev/null} msg]
	if {$fail} {
	    mLog warning $msg
	}
	cd $here
    }

    cd $here
    return
}



proc mSupport {args} {
    # @c The files named in the list <a args> are copied to the support folder
    # @c and will be distributed side by side to the complete distribution.
    #
    # @a args: List of files to be marked as supporting data.
    #
    # @future Should check for paths refering to files outside
    # @future the distribution directory and reject these.

    global mName mFullVersion

    if {[llength $args] == 0} {
	return
    }

    mLog info Supporting files $args

    set destination [file join .. sup.${mName}${mFullVersion}]
    foreach file $args {
	file copy $file $destination
    }
    return
}
