# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: doczip.tcl,v 1.2 1998/06/02 16:59:18 aku Exp $
#
# @c Procedures to wrap up documentation into a separate archive
# @s Separate archives for documentation.
# @i documentation
# --------------------------------------------------


proc mDocTGZArchive {directory} {
    # @c Wraps the documentation residing in the <a directory> into a tar.gz
    # @c archive and marks this as supporting file, causing it to be
    # @c distributed side by side with the real distribution archive.
    #
    # @a directory: The path to the directory containing the documentation to
    # @a directory: archive. Relative to the distribution directory.
    #
    # @see <p mDocZIPArchive>.
    #
    # @n Uses an intermediary file [strong doc.tar.gz] in the distribution
    # @n directory. Requires existence of 'tar' command, must be found in the
    # @n path. Requires a version of 'tar' understanding option 'z' (GNU tar
    # @n for example).

    global mDirectory

    mLog info Archiving documentation (tar.gz)

    set here [pwd]
    set fail [catch {
	cd ..
	exec tar cfz \
		[file join $mDirectory doc.tar.gz] \
		[file join $mDirectory $directory]

	cd $here
	mSupport    doc.tar.gz
	file delete doc.tar.gz
    } msg]	;# {}

    if {$fail} {
	mLog warning $msg
    }

    cd $here
    return
}



proc mDocZIPArchive {directory} {
    # @c Wraps the documentation residing in the <a directory> into a zip
    # @c archive and marks this as supporting file, causing it to be
    # @c distributed side by side with the real distribution archive.
    #
    # @a directory: The path to the directory containing the documentation to
    # @a directory: archive. Relative to the distribution directory.
    #
    # @see <p mDocTGZArchive>
    #
    # @n Uses an intermediary file [strong doc.zip] in the distribution directory.
    # @n Requires existence of 'zip' command, must be found in the path.

    global mDirectory

    mLog info Archiving documentation (zip)

    set here [pwd]
    set fail [catch {
	cd ..
	exec zip -r9 \
		[file join $mDirectory doc.zip] \
		[file join $mDirectory $directory]
	cd $here

	mSupport    doc.zip
	file delete doc.zip
    } msg]	;# {}

    if {$fail} {
	mLog warning $msg
    }

    cd $here
    return
}



