# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: lsm.tcl,v 1.3 1998/06/04 20:10:11 aku Exp $
#
# @c Rewrite the DESCRIPTION into a LSM file.
# @s Rewrite the DESCRIPTION into a LSM file.
# @i prepare support, lsm generation
# --------------------------------------------------

package require Tcl        8.0
package require Pool_Base

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace eval support {
	namespace export *
    }
}


proc ::makedist::support::fmtKeyData {fh text key} {
    # @n Internal procedure.
    #
    # @c Formats the data associated to <a key>, then inserts it as LSM entry
    # @c into the file denoted by <a fh>.
    #
    # @a fh:   Handle of the file to write to.
    # @a text: Name of the generated entry, without spaces and :.
    # @a key:  Index into 'mDesc', to get at the data to be written.

    global mDesc

    set n [string length $text]
    set n [expr {15-$n}]

    set text "${text}:[::pool::string::blank $n]"

    set result [::pool::string::removeSpaces  $mDesc($key)]
    set result [::pool::string::oneLine       $result]
    set result "${text}${result}"
    set result [::pool::string::wrap          $result 72]
    set result [::pool::string::hangingIndent $result "\t"]

    puts $fh $result
    return
}


proc ::makedist::support::fmtUrls {fh prefix urls} {
    # @n Internal procedure, currently not used
    #
    # @c Alternative to <p ::makedist::support::fmtForSite>. No acrobatics to
    # @c satisfy the LSM rules, just listing the given urls.
    #
    # @a fh: Handle of the file to write to.
    # @a prefix: Text of the entry to generate, already contains the
    # @a prefix: proper amount of spaces at the end.
    # @a urls: List of urls to place into the entry.

    set u [::pool::list::shift urls]
    puts $fh "$prefix$u"

    if {[llength $u] == 0} {
	return
    }

    set fill [::pool::string::blank [string length $prefix]]

    foreach u $urls {
	puts $fh "$fill$u"
    }
    return
}


proc ::makedist::support::fmtForSite {fh prefix urls} {
    # @c Generates a properly formatted site-entry.
    # @a fh: Handle of the file to write to.
    # @a prefix: Text of the entry to generate, already contains the
    # @a prefix: proper amount of spaces at the end.
    # @a urls: List of urls to place into the entry.
    # @n Internal procedure.

    set fill [::pool::string::blank [string length $prefix]]

    # remove all urls not related to ftp!
    set _    $urls
    set urls ""
    foreach u $_ {
	if {[string match ftp:/* $u]} {
	    lappend urls $u
	}
    }

    if {[llength $urls] == 0} {
	return
    }

    # split single url, then write
    set u [::pool::list::shift urls]
    regexp {^ftp://([^/]*)/(.*)$} $u match host path
    set file [file tail    $path]
    set path [file dirname $path]

    puts $fh "$prefix$host $path"
    puts $fh "$fill$file"

    # split next urls, consider ones with same host and path only
    foreach u $urls {
	regexp {^ftp://([^/]*)/(.*)$} $u match uhost upath

	if {[string compare $host $uhost] != 0} {continue}

	set ufile [file tail    $upath]
	set upath [file dirname $upath]

	if {[string compare $path $upath] != 0} {continue}

	puts $fh "$fill$ufile"
    }
    return
}



proc ::makedist::support::hasValue {key} {
    # @c A shorthand checking wether mDesc(<a key>) contains data or not.
    # @a key: Name of the key to check for.
    # @n Internal procedure

    global mDesc
    return [expr {[info exists mDesc($key)] && ($mDesc($key) != {})}]
}



proc mGenerateLSM {} {
    # @c Takes the information in 'mDesc' and generates
    # @c a LSM file from it. LSM = Linux Software Map.
    # @c Part of the file is automatically filled.

    global mDesc mName mFullVersion mShortDate

    mLog info creating LSM entry...

    # maintenance defaults to author if not set.
    if {![::makedist::support::hasValue maintenance]} {
	set mDesc(maintenance) $mDesc(author)
    }

    set fh [open LSM w]
    puts  $fh "Begin3"
    puts  $fh "Title:          $mName"
    puts  $fh "Version:        $mFullVersion"
    puts  $fh "Entered-date:   $mShortDate"

    ::makedist::support::fmtKeyData $fh Description description

    if {[::makedist::support::hasValue keywords]} {
	::makedist::support::fmtKeyData $fh Keywords keywords
    }

    puts  $fh "Author:         $mDesc(author)"
    puts  $fh "Maintained-by:  $mDesc(maintenance)"

    if {![catch {::makedist::support::GetUrl p s t}]} {
	::makedist::support::fmtForSite $fh "Primary-site:   " $p
	if {[llength $s] > 0} {
	    ::makedist::support::fmtForSite $fh "Alternate-site: " $s
	}
    }

    if {[::makedist::support::hasValue dependencies]}   {
	::makedist::support::fmtKeyData $fh Platforms dependencies
    }
    if {[::makedist::support::hasValue copying-policy]} {
	::makedist::support::fmtKeyData $fh Copying-policy copying-policy
    }

    puts  $fh "End"
    close $fh
    return
}
