# -*- tcl -*-
# --------------------------------------------------
# (C) 1997	Andreas Kupries <a.kupries@westend.com>
#
# CVS:	$Id: perm.tcl,v 1.5 1999/01/20 19:31:51 aku Exp $
#
# @c Procedures to set permissions on files and directories
# @s Permission regulation
# @i permissions, support, base support
# --------------------------------------------------

package require Tcl 8.0

# Create the required namespaces before adding information to them.
# Initialize some info variables.

namespace eval ::makedist {
    variable version @mFullVersion@
    variable asOf    @mDate@

    namespace eval support {
	namespace export *
    }
}



proc ::makedist::support::SetPermissions {path fileperm dirperm} {
    # @c Sets the permissions for the file or directory given as <a path>.
    # @c Uses <a fileperm> for a file or <a dirperm> else. Traves directories
    # @c recursively.
    #
    # @a path:     File or directory to set permissions on.
    # @a fileperm: Permissions to set if <a path> is a file.
    # @a dirperm:  Permissions to set if <a path> is a directory.
    #
    # @n Requires existence of command 'chmod' in the path.
    # @n Future implementations might be build on top of 'file
    # @n attributes' of Tcl 8.

    if {[file isdirectory $path]} {
	cd $path
	set flist [glob -nocomplain .* *]
	regsub -- {. ..} $flist {} flist

	foreach f $flist {
	    SetPermissions $f $fileperm $dirperm
	}
	cd ..
	catch {exec chmod $dirperm $path}
    } else {
	catch {exec chmod $fileperm $path}
    }
    return
}



proc mNormalPermissions {args} {
    # @c Sets the permissions for all files and/or directories to standard
    # @c values (files: 444, directories 754). Traverses directories
    # @c recursively. Actually only a wrapper to
    # @c <p ::makedist::support::SetPermissions>.
    #
    # @a args: List of files and directories to manipulate.
    #
    # @future Should check for paths refering to files outside
    # @future the distribution directory and reject these.

    if {[llength $args] == 0} {
	return
    }

    mLog info Setting permissions for $args

    foreach f $args {
	set here [pwd]
	::makedist::support::SetPermissions $f 444 754
	cd $here
    }

    return
}



proc mSecurePermissions {args} {
    # @c Sets the permissions for all files and/or directories to (relatively)
    # @c secure values (files: 400, directories 500). Traverses directories
    # @c recursively. Actually only a wrapper to
    # @c <p ::makedist::support::SetPermissions>.
    #
    # @a args: List of files and directories to manipulate.
    #
    # @future Should check for paths refering to files outside
    # @future the distribution directory and reject these.

    if {[llength $args] == 0} {
	return
    }

    mLog info Setting secure permissions for $args

    foreach f $args {
	set here [pwd]
	::makedist::support::SetPermissions $f 400 500
	cd $here
    }

    return
}
