wm title . "Weasel Server (HTTPD)"

frame .top -borderwidth 1
frame .bottom -borderwidth 1
pack .top -side top -fill x
pack .bottom -side bottom -fill x

button .top.quit -width 8 -text Quit -command exit
set but [button .top.run -width 8 -text Run -command run]
pack .top.quit .top.run -padx 2 -side right

checkbutton .top.verbose -text Verbose -variable VerboseLoging
pack .top.verbose -side left

label .bottom.l -text "HTTP Home:" -padx 0
set ent [entry .bottom.home -width 20 -relief sunken -textvariable PathName]
label .bottom.hits -text 0 -width 5 -textvariable Hits -padx 2
pack .bottom.l -side left
pack .bottom.home -side left -fill x -expand true
pack .bottom.hits -side left

set PathName "./"
set HomePath [pwd]

frame .t
set log [text .t.log -state disabled -width 80 -height 10 -borderwidth 2 -relief sunken -setgrid true -yscrollcommand {.t.scroll set}]
scrollbar .t.scroll -command {.t.log yview}
pack .t.scroll -side right -fill y
pack .t.log -side left -fill both -expand true
pack .t -side top -fill both -expand true


# An array of mime types
array set HttpdMimeType {
	{}		text/plain
	.txt	text/plain
	.htm	text/html
	.html	text/html
	.gif	image/gif
	.png	image/png
	.jpg	image/jpeg
	.xbm	image/x-xbitmap
}

# An array of http error codes
array set HttpdErrors {
	204 {No Content}
	400 {Bad Request}
	404 {Not Found}
	503 {Service Unavailable}
	504 {Service Temporarily Unavailable}
}

array set ErrorHaiku {
	200 " "
	400 " "
	404 "Seeking in the web<BR>Searching files lost in the static.<BR>Browsers seeking lost thoughts.<BR>"
	503 " "
	504 " "
}

# The main function
proc HTTP_Server {port} {
	global http PathName HomePath

	cd $HomePath
	cd $PathName
	set http(main) [socket -server HTTPAccept $port]
}

# The port listener
proc HTTPAccept {sock addr port} {
	global http
	#Logged "Accept $sock from $addr port $port\n"
	set http(addr,$sock) [list $addr $port]
	fconfigure $sock -buffering line
	fileevent $sock readable [list Http $sock]
}

# The http processing code
proc Http {sock} {
	global http VerboseLoging log Hits

	if {[eof $sock] || [catch {gets $sock line}]} {
		close $sock
		Logged "Close $http(addr,$sock)"
		unset http(addr,$sock)
	} else {
	if {[string compare $line "quit"] == 0} {
		close $http(main)
	}
	
	Logged "$line\nFrom $http(addr,$sock)\n"
	set FileName $line
	set strStart [expr [string first " " $FileName]+1]
	set strEnd [expr [string last " " $FileName]-1]
	set FileName ".[string range $FileName $strStart $strEnd]"	
	if {$FileName=="./"} {set FileName "./index.html"}
	
	if {![catch {open $FileName r 0600} fileINDEX]} {

	fconfigure $fileINDEX -translation binary
	fconfigure $sock -translation binary

	puts $sock "HTTP/1.0 200 Data follows"
	puts $sock "Date: [HttpdDate [clock seconds]]"
	puts $sock "Last-Modified: [HttpdDate [file mtime $FileName]]"
	puts $sock "Content-Type: [HttpdContentType $FileName]"
	puts $sock "Content-Length: [file size $FileName]"
	puts $sock ""

	if {$VerboseLoging} {
	Logged "HTTP/1.0 200 Data follows\n"
	Logged "Date: [HttpdDate [clock seconds]]\n"
	Logged "Last-Modified: [HttpdDate [file mtime $FileName]]\n"
	Logged "Content-Type: [HttpdContentType $FileName]\n"
	Logged "Content-Length: [file size $FileName]\n"
	}

	Logged "Sending $FileName\n"
	while {[gets $fileINDEX line] >= 0} {
	puts $sock $line
	}	
	#copychannel $fileINDEX $sock
	close $sock
	close $fileINDEX
	set Hits [expr $Hits+1]
	Logged "$http(addr,$sock) closed by host.\n\n"
	} else {
	HttpdError $sock 404
	}
	}
}

proc HttpdError {sock code} {
	global HttpdErrors ErrorHaiku http log

	Logged "Error. Sending $code.\n$http(addr,$sock) closed by host.\n\n"
	puts $sock "HTTP/1.0 $code $HttpdErrors($code)"
	puts $sock "Date: [HttpdDate [clock clicks]]"
	puts $sock ""
	puts $sock "<TITLE> Error $code </TITLE>"
	puts $sock "$ErrorHaiku($code)"
	puts $sock "<B>$code $HttpdErrors($code)</B>"
	close $sock
}

# Returns a http formated date
proc HttpdDate {clicks} {
	return [clock format $clicks -format {%a, %d %b %Y %T %Z}]
}

# Returns a mime type based on the requested file
proc HttpdContentType {path} {
	global HttpdMimeType

	set type text/plain
	catch {set type $HttpdMimeType([file extension $path])}
	return $type
}

proc Logged {a} {
	global http log
	$log config -state normal
	$log insert end "$a"
	$log config -state disabled
}

proc run {} {
	global log but ent
	$but config -text Stop -command stop
	Logged "HTTP Server started on [clock format [clock seconds] -format %c]\n\n"
	$ent config -state disabled -bg grey
	HTTP_Server 80
}

proc stop {} {
	global log but ent http
	$but config -text Run -command run
	Logged "HTTP Server stoped on [clock format [clock seconds] -format %c]\n\n"
	$ent config -state normal -bg white
	close $http(main)
}