#!/usr/bin/wish -f

#
#   tkHelp. A simple Open Help App.
#
#   See OHA for ohlp description.
#
#   (C) 1999 Juan J. Martinez Siguenza (reidrac@rocketmail.com)
#   See GPL for distribution and usage details.
#
#   I used TK8.0 (try other previous versions of TK and let me
#   know if it works).
#


#
# title		-> title of help window
# helptext	-> ohlp text
#
proc openHelp {title helptext} {

  set w ".openHelpWin"

  destroy $w if exists

  toplevel $w

  text $w.text -setgrid yes -wrap word \
    -width 55 -relief sunken -border 2 \
    -yscroll "$w.scroll set"

  scrollbar $w.scroll -relief sunken -command "$w.text yview"

  frame $w.f -relief raise -border 2
  pack $w.f -side bottom -fill x 

  button $w.f.close -text "Close" -command { destroy .openHelpWin }
  button $w.f.about -text "OHlp" -command { aboutOpenHelp  }

  pack $w.f.close -side left
  pack $w.f.about -side right
  pack $w.scroll -side right -fill y -padx 2 -pady 2
  pack $w.text -fill both -expand 1 -padx 5

  wm title $w "OpenHelp - $title"
  wm minsize $w 1 1

  outText $w.text $helptext
}


#
#  w 		-> text widget
#  ohlp         -> ohlp text
#
proc outText {w ohlp} {

   # normal
   $w configure -font -*-Helvetica-Medium-R-Normal-*-120-*
   # bold normal
   $w tag configure b -font -*-Helvetica-Bold-R-Normal-*-120-*
   set dtags(b) b
   # italic normal
   $w tag configure i -font -*-Helvetica-Medium-O-Normal-*120-*
   set dtags(i) i
   # underline 
   $w tag configure u -underline 1
   set dtags(u) u
   # header 1
   $w tag configure h1 -font -*-Helvetica-Bold-R-Normal-*-240-*
   set dtags(h1) h1
   # header 2
   $w tag configure h2 -font -*-Helvetica-Bold-R-Normal-*-180-*
   set dtags(h2) h2
   # header 3
   $w tag configure h3 -font -*-Helvetica-Bold-R-Normal-*-140-*
   set dtags(h3) h3

   # justify left -default-
   # justify right
   $w tag configure right -justify right
   set dtags(right) right
   # justify center
   $w tag configure center -justify center
   set dtags(center) center

   # relief 1
   $w tag configure r1 -relief raised -border 1
   set dtags(r1) r1
   # relief 2
   $w tag configure r2 -relief raised -border 2
   set dtags(r2) r2
   # relief 3
   $w tag configure r3 -relief raised -border 3
   set dtags(r3) r3

   # color red
   $w tag configure fgr -foreground red
   set dtags(fgr) fgr
   # color blue
   $w tag configure fgb -foreground blue
   set dtags(fgb) fgb
   # color green
   $w tag configure fgg -foreground green
   set dtags(fgg) fgg
   # color white
   $w tag configure fgw -foreground white
   set dtags(fgw) fgw
   # color yellow
   $w tag configure fgy -foreground yellow
   set dtags(fgy) fgy
   # color black -default-
   $w configure -foreground black

   # bgcolor red
   $w tag configure bgr -background red
   set dtags(bgr) bgr
   # bgcolor blue
   $w tag configure bgb -background blue
   set dtags(bgb) bgb
   # bgcolor green
   $w tag configure bgg -background green
   set dtags(bgg) bgg
   # bgcolor yellow
   $w tag configure bgy -background yellow
   set dtags(bgy) bgy
   # bgcolor black
   $w tag configure bgk -background black
   set dtags(bgk) bgk
   # bgcolor white -default-
   $w configure -background white

   $w mark set insert 0.0

   # main loop
   set t $ohlp

   while {[regexp -indices {<([^@>]*)>} $t match inds] == 1} {
	set start [lindex $inds 0]
	set end [lindex $inds 1]
	set keyword [string range $t $start $end]

        set oldend [$w index end]

        if {[string range $keyword 0 0] != "/"} {
		# if is not a tag -> is a link
		if {[info exists dtags($keyword)] != 1} {
		   # links
   			set selected "$w tag configure $keyword -relief raise -border 1\
 			-background lightgrey"
   			set unselected "$w tag configure $keyword -relief flat -background white"
	   		$w tag configure "$keyword" -foreground blue -underline 1
 			$w tag bind "$keyword" <Button-1> $keyword
   			$w tag bind "$keyword" <Any-Enter> $selected
   			$w tag bind "$keyword" <Any-Leave> $unselected
			set dtags($keyword) $keyword
		}
	}

        $w insert end [string range $t 0 [expr $start - 2]]

	quitTags $w $oldend insert

        if {[string range $keyword 0 0] == "/"} {
		set keyword [string trimleft $keyword "/"]
		if {[info exists tags($keyword)] == 0} {
			error "\nError al cerrar el marcado: Tag not found\n"
		}
		$w tag add $keyword $tags($keyword) insert
		unset tags($keyword)
	} else {
		if {[info exists tags($keyword)] == 1} {
			error "\nError al abrir marcado: Tag found twice\n"
		}
		set tags($keyword) [$w index insert]
	}
	set t [string range $t [expr $end + 2] end]
   }
   set oldend [$w index end]
   $w insert end $t
   quitTags $w $oldend insert

   $w configure -state disabled
}

proc quitTags {w start end} {
	foreach tag [$w tag names $start] {
		w$ tag remove $tag $start $end
	}
}

proc aboutOpenHelp {} {

  openHelp "About OpenHelp" {

<h1><fgb>Open Help v1.0</fgb></h1>

  Open help es un sencillo script en <i>Tcl/Tk</i> que permite incluir modulos de ayuda con texto enriquecido y enlaces hipertexto en sistemas con soporte <i>Tcl/Tk</i> sin necesidad de recurrir al formato <i>Html</i>.
  Ha sido desarrollado empleando <b>TK8.0</b> -y no ha sido probado con otras versiones-.

 <h3>Contenidos</h3>

      1.<ohlpInfo>Introduccion a ohlp</ohlpInfo>
      2.<gplInfo>Distribucion</gplInfo>
      3.<contactInfo>Contactos y errores</contactInfo>
      4.<futureInfo>Futuras versiones</futureInfo>
 




<i><fgb>tkOhlp and his help (C) 1999 Juan J. Martinez (reidrac@rocketmail.com). See Distribution details.</fgb></i>
}
}

proc ohlpInfo {} {

  openHelp "Introduction to ohlp" {

<h2><fgb>Introduccion a ohlp</fgb></h2>

  <b>ohlp</b> Funciona de forma similar a <i>Html</i>. Se situan <i>tags</i> que aplican propiedades al texto. Los <i>tags</i> se aplican:
  <i>tag</i> texto con propiedades /<i>tag</i> situando el <i>tag</i> entre los simbolos <i>menor que</i> y <i>mayor que</i>.
  Ademas es posible anidar <i>tags</i> para producir combinaciones de efectos:

  Los <i>tags</i> soportados en <fgb><b>Open Help v1.0</b></fgb> son:

         <u><i>tag</i></u>        <u><b>Descripcion</b></u>

         <i>h1</i>        Encabezado Grande
         <i>h2</i>        Encabezado Medio
         <i>h3</i>        Encabezado Pequeo

         <i>right</i>     Justifica a la Derecha
         <i>center</i>    Texto Centrado

                     <u>Incompatibles con <i>h1 h2 h3</i></u>
         <i>b</i>          Texto en Negrita
         <i>i</i>           Texto en Cursiva
         <i>u</i>          Texto Subrayado

                     <u>Color en Primer Plano</u>
         <i>fgb</i>       Azul
         <i>fgr</i>        Rojo
         <i>fgg</i>       Verde
         <i>fgy</i>       Amarillo
         <i>fgw</i>       Blanco

                     <u>Color de Fondo</u>
         <i>bgb</i>       Azul
         <i>bgr</i>        Rojo
         <i>bgg</i>       Verde
         <i>bgy</i>       Amarillo
         <i>bgk</i>       Negro

         <i>r1</i>         Resaltado Grande
         <i>r2</i>         Resaltado Medio
         <i>r3</i>         Resaltado Pequeo


  Las propiedades hipertexto se consiguen utilizando <i>tags</i> no definidos que <b>ohlp</b> inerpretara como enlaces, ejecutando el comando cuando se pulse el texto.
  El <i>tag</i> del enlace es el mismo comando a ejecutar. Asi un <i>tag</i> que sea <i>openInfo</i> hara que al pulsar el texto se ejecute el procedimiento <i>openInfo</i>.

  Es importante tener en cuenta que tanto para los enlaces como para los <i>tags</i> definidos, debe ser igual el <i>tag</i> de apertura que el de cerrado -salvo por el <i>/</i>-.


  En el directorio donde se encuentre la informacion sobre <b>ohlp</b> hay
ficheros de ejemplo que emplean <b><fgb>Open Help v1.0</fgb></b>.


<aboutOpenHelp>Contenidos</aboutOpenHelp>

}
}

proc gplInfo {} {

  openHelp "Distribution Details" {

<h2><fgb>Distribucion</fgb></h2>

   <b><fgb>Open Help v1.0</fgb></b> se distribuye bajo los terminos de la <b>GPL</b>. No obstante se agradeceria que se enviara un <i>mail</i> al <contactInfo>autor</contactInfo> con comentarios acerca de <b>ohlp</b>.

Copyright (C)1999 Juan J. Martinez.

This program is free software; you may redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2, or (at your option) any later version.

This is distributed in the hope that it will be useful, but without any warranty; without even the implied warranty of merchantability or fitness for a particular purpose. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License with your copy of Open Help. If not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



<aboutOpenHelp>Contenidos</aboutOpenHelp>

}
}

proc contactInfo {} {

  openHelp "Contacts and Bugs" {

<h2><fgb>Contactos y errores</fgb></h2>

   <b><fgb>Open Help v1.0</fgb></b> no esta libre de errores, se me puede haber escapado algo, pero es lo suficiente fiable como para utilizarlo. No obstante si encuentra un error que le parece molesto, o cree que <b>ohlp</b> se puede mejorar, no dude en ponerse en contacto conmigo en:

    <i><fgr>reidrac@rocketmail.com</fgr></i>

  O de forma tradicional:

    <i>Juan Jose Martinez Siguenza</i>

   <i>C/ Fda. Sta. Maria 67 4p 4pl 
   03204 Elche (Alicante) SPAIN</i>

  Tambien busco trabajo. Si cree que me puede interesar algun proyecto que usted tenga en mente, comuniquemelo.

   <i>Elche, 13 de Febrero de 1999</i> 


<aboutOpenHelp>Contenidos</aboutOpenHelp>

}
}

proc futureInfo {} {

  openHelp "Future Versions" {

<h2><fgb>Futuras versiones</fgb></h2>

   <b><fgb>Open Help v1.0</fgb></b> es un producto inacabado segun el proyecto original. Se suponia que soportaria imagenes y caracteristicas que lo acercaran cada vez mas a <i>Html</i> hasta que fuera relativamente sencillo que soportara tambien este ultimo formato. Pero las cosas no han ido como se esperaba.

   No obstante se aceptan colaboraciones. Si usted quiere colaborar puede enviar un mail al <contactInfo>autor</contactInfo> explicando que puede hacer por el proyecto.

   Se esta estudiando realizar herramientas de conversion de <i>Html</i> y <i>Sgml</i> a <b>ohlp</b>, pero como lo que se queria conseguir era un modulo para proporcionar ayuda en mis programas -y eso esta conseguido con mas o menos pericia-, no puedo prometer que se concluyan.

   Por ultimo, las contribuciones -y quizas algun euro- ayudarian mucho a la continuidad del proyecto.

<aboutOpenHelp>Contenidos</aboutOpenHelp>

}
}

proc error { text } {

  destroy if exists .error

  toplevel .error

  frame .error.f0 -relief raised -border 2
  pack .error.f0 -side top -fill both -expand yes

  label .error.f0.mess -text $text
  pack .error.f0.mess

  frame .error.f1 -relief groove -border 2
  pack .error.f1 -side top -fill both -expand yes

  button .error.f1.ok -text Ok -command { destroy .error }
  pack .error.f1.ok

  wm title .error "Open Help Error"
}

