# OpenVerse Avatar Functions Module
# 
# This module includes all the functions related
# to avatars and avatar movement.
#
# Module Name		- Avatar Functions
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMainWindow
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

proc AnimateAvatar {} {
	global MV

	if {$MV(anim.current) == -1} {
		ChangeAvatar $MV(anim.0)
		set MV(anim.stop) 1
		set MV(anim.running) 0
		return
	}
	set delay 0
	if {$MV(anim.current) == 1 && !$MV(anim.new)} {
		set delay $MV(anim.final_delay)
	}
	if {$MV(anim.running) && $MV(anim.new)} {
		ChangeAvatar "$MV(anim.0)"
		set MV(anim.new) 0
		incr MV(anim.current)
		if {$MV(anim.current) > $MV(anim.frames)} {set MV(anim.current) 1}
		return
	}
	set MV(anim.new) 0
	if $MV(anim.stop) {
		ChangeAvatar "$MV(anim.0)"
		set MV(anim.running) 0
		return
	}
	ChangeAvatar "$MV(anim.[expr $MV(anim.current) -1])"
	set MV(anim.running) 1
	incr MV(anim.current)
	if {$MV(anim.current) > $MV(anim.frames)} {
		set MV(anim.current) 1
	}
	set do_delay [expr $MV(anim.delay) + $delay]
	after $do_delay AnimateAvatar
}

proc AnimateMe {what which} {
	global MV

	
	switch $which {
		1 {
			set file "$MV(avatar_files.$what)"
		}
		2 {
			set file "$MV(avatar_setup.$what)"
		}
		3 {
			if ![file exists "$MV(anims)/$what"] {return}
			set file "$what"
		}
		default {
			set file "default.av"
		}
	}

	if [winfo exists .setup.na.l.b.avatars.entry] {
		.setup.na.l.b.avatars.entry delete 0 end
		.setup.na.l.b.avatars.entry insert end "$file"
	}
	catch {source "$MV(anims)/$file"}
	AnimateAvatar
}

proc ShowNames {} {
	global MV

	if $MV(names) {
		ShowName $MV(nick)
		#
		# Process Plugins!
		#
		foreach plugin $MV(plugin.traps.ShowNames) {
			if ![$MV(plugin.traps.ShowNames.$plugin) $MV(nick)] {return}
		}
		foreach who $MV(people) {
			ShowName $who
			#
			# Process Plugins!
			#
			foreach plugin $MV(plugin.traps.ShowNames) {
				if ![$MV(plugin.traps.ShowNames.$plugin) $who] {return}
			}
		}
	} else {
		KillName $MV(nick)
		#
		# Process Plugins!
		#
		foreach plugin $MV(plugin.traps.KillNames) {
			if ![$MV(plugin.traps.KillNames.$plugin) $MV(nick)] {return}
		}
		foreach who $MV(people) {
			KillName $who
			#
			# Process Plugins!
			#
			foreach plugin $MV(plugin.traps.KillNames) {
				if ![$MV(plugin.traps.KillNames.$plugin) $who] {return}
			}
		}
	}
}

proc KillName {who} {
	global MV

	catch {
		.top.c delete $MV($who.nametext)
		.top.c delete $MV($who.nameplate)
	}
}

proc ShowName {who} {
	global MV


	if {$who == $MV(nick)} {
		set MV($MV(nick).x) $MV(x)
		set MV($MV(nick).y) $MV(y)
		set MV($MV(nick).name_x_offset) $MV(anim.x_off)
		set MV($MV(nick).name_y_offset) $MV(anim.y_off)
	}
	set width [expr [string length $who] * 8]
	#
	# Set so that a plugin can access this information.
	#
	set MV($who.name_tl_x) [expr ($MV($who.x) + $MV($who.name_x_offset)) - ($width / 2)]
	set MV($who.name_tl_y) [expr ($MV($who.y) + $MV($who.name_y_offset)) - 8]
	set MV($who.name_br_x) [expr ($MV($who.x) + $MV($who.name_x_offset)) + ($width / 2)]
	set MV($who.name_br_y) [expr ($MV($who.y) + $MV($who.name_y_offset)) + 8]
	#
	set MV($who.nameplate) [.top.c create rectangle \
		[expr ($MV($who.x) + $MV($who.name_x_offset)) - ($width / 2)] \
		[expr ($MV($who.y) + $MV($who.name_y_offset)) - 8] \
		[expr ($MV($who.x) + $MV($who.name_x_offset)) + ($width / 2)] \
		[expr ($MV($who.y) + $MV($who.name_y_offset)) + 8] -fill black]
	set MV($who.nametext) [.top.c create text \
		[expr ($MV($who.x) + $MV($who.name_x_offset))] \
		[expr ($MV($who.y) + $MV($who.name_y_offset))] \
		-text $who -fill white]

}

proc ChangeAvatar {what} {
	global MV

	if ![file exists "$MV(images)/$what"] {
		image create photo pic -file "$MV(images)/default.gif"
		return
	}
	image create photo pic -file "$MV(images)/$what"
	set MV(avatar) $what
	SendToServer "AVATAR $what $MV(anim.x_off) $MV(anim.y_off) [file size "$MV(images)/$what"] $MV(anim.baloon_x) $MV(anim.baloon_y)"
	if $MV(names) {
		KillName $MV(nick)
		ShowName $MV(nick)
	}

	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.ChangeAvatar) {
		if ![$MV(plugin.traps.ChangeAvatar.$plugin) $what] {return}
	}
}

proc DoAvatars {} {
	global MV

	set anims 0
	set MV(avatars.depth) 0

	destroy $MV(avatar_menu).m

	if $MV(use_windowmanager_colors) {
		menu $MV(avatar_menu).m
	} else {
		menu $MV(avatar_menu).m -bg $MV(colors.av.bg) \
			-fg $MV(colors.av.fg) -activeforeground $MV(colors.av.afg) \
			-activebackground $MV(colors.av.abg)
	}

	set MV(avatar_files.0) "default.av"
	set count 1
	foreach file [List_Avatars] {
		if !$MV(avatars.depth) {
			incr MV(avatars.depth)
			$MV(avatar_menu).m add cascade -menu \
				$MV(avatar_menu).m.m$MV(avatars.depth) -label "Avatars $MV(avatars.depth)"
			if $MV(use_windowmanager_colors) {
				menu $MV(avatar_menu).m.m$MV(avatars.depth) 
			} else {
				menu $MV(avatar_menu).m.m$MV(avatars.depth) -bg $MV(colors.av.bg) \
					-fg $MV(colors.av.fg) -activeforeground $MV(colors.av.afg) \
					-activebackground $MV(colors.av.abg)
			}

		}
		set MV(avatar_files.$count) "[file tail $file]"
		if {[file tail $file] == "default.av"} {
			set MV(default_avatar_number) $count
		}
		$MV(avatar_menu).m.m$MV(avatars.depth) add command -label [file tail $file] \
			-command "AnimateMe $count 1"
		incr anims
		incr count
		if {$anims > 19} {
			incr MV(avatars.depth)
			$MV(avatar_menu).m add cascade -menu \
				$MV(avatar_menu).m.m$MV(avatars.depth) -label "Avatars $MV(avatars.depth)"
			if $MV(use_windowmanager_colors) {
				menu $MV(avatar_menu).m.m$MV(avatars.depth)
			} else {
				menu $MV(avatar_menu).m.m$MV(avatars.depth) -bg $MV(colors.av.bg) \
					-fg $MV(colors.av.fg) -activeforeground $MV(colors.av.afg) \
					-activebackground $MV(colors.av.abg)
			}
			set anims 0
		}
	}
}

proc MoveTo {x y} {
	global MV
	
	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.MoveTo.Pre) {
		if ![$MV(plugin.traps.MoveTo.Pre.$plugin) $x $y] {return}
	}

	if {$x >= 0 && $y >= 0} {
		lappend MV(moves) "$x $y"
	}

	if $MV(moving) {return}

	set MV(moving) 1
	set xy [split [lindex $MV(moves) 0] " "]
	set x [lindex $xy 0]
	set y [lindex $xy 1]

	SendToServer "MOVE $MV(nick) $x $y $MV(movespeed)"
	while {$MV(x) != $x || $MV(y) != $y} {
		if {[expr $x - $MV(x)] > 0} {set xdir 1} else {set xdir -1}
		if {[expr $y - $MV(y)] > 0} {set ydir 1} else {set ydir -1}
		if {[expr $y - $MV(y)] == 0} {set ydir 0}
		if {[expr $x - $MV(x)] == 0} {set xdir 0}
		set xinc $xdir
		set yinc $ydir
		if {$xdir && $MV(movespeed) != 2} {
			set xinc [expr $xdir * 1]
			set xx $MV(x)
			while { $xx != $x && $xinc != [expr $MV(movespeed) * $xdir]} {
				set xx $MV(x)
				incr xinc [expr $xdir * 1]
				incr xx $xinc
			}
		}
		if {$ydir && $MV(movespeed) != 2} {
			set yinc [expr $ydir * 1]
			set yy $MV(y)
			while { $yy != $y && $yinc != [expr $MV(movespeed) * $ydir]} {
				set yy $MV(y)
				incr yinc [expr $ydir * 1]
				incr yy $yinc
			}
		}
		.top.c move $MV(img) $xinc $yinc
		incr MV(x) $xinc
		incr MV(y) $yinc
		update idletasks
		update
	}
	
	set MV(moves) [lreplace $MV(moves) 0 0]
	set MV(moving) 0
	if [llength $MV(moves)] {
		MoveTo -1 -1
	}
	if $MV(names) {
		KillName $MV(nick)
		ShowName $MV(nick)
	}

	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.MoveTo.Post) {
		if ![$MV(plugin.traps.MoveTo.Post.$plugin) $x $y] {return}
	}
}

proc MoveImage {image x y xx yy speed} {
	global MV

	while {$xx != $x || $yy != $y} {
		if {[expr $x - $xx] > 0} {set xdir 1} else {set xdir -1}
		if {[expr $y - $yy] > 0} {set ydir 1} else {set ydir -1}
		if {[expr $y - $yy] == 0} {set ydir 0}
		if {[expr $x - $xx] == 0} {set xdir 0}
		set xinc $xdir
		set yinc $ydir
		if $xdir {
			set xinc [expr $xdir * 1]
			set xxx $xx
			while { $xxx != $x && $xinc != [expr $speed * $xdir]} {
				set xxx $xx
				incr xinc [expr $xdir * 1]
				incr xxx $xinc
			}
		}
		if $ydir {
			set yinc [expr $ydir * 1]
			set yyy $yy
			while { $yyy != $y && $yinc != [expr $speed * $ydir]} {
				set yyy $yy
				incr yinc [expr $ydir * 1]
				incr yyy $yinc
			}
		}
		.top.c move $image $xinc $yinc
		incr xx $xinc
		incr yy $yinc
		update idletasks
		update
	}
}

proc Move {direction} {
	global MV
	.top.c move $MV(img) 3 0
	incr MV(x)
}	


proc ChangeUserAvatar {who what x y size bx by} {
	global MV

	if {[lsearch -exact $MV(people) $who] == -1} {return}
	set MV($who.avatar) $what
	set MV($who.name_x_offset) $x
	set MV($who.name_y_offset) $y
	set MV($who.baloon_x) $bx
	set MV($who.baloon_y) $by
	if $MV(names) {
		KillName $who
		ShowName $who
	}
	if {$what == "default.gif"} {
		image create photo $who -file "$MV(images)/default.gif"
		return
	}
	if ![file exists "$MV(rem_images)/$what"] {
		if {[lsearch -exact $MV(downloads) $what] == -1} {
			if $MV(debug) {puts "I do not have $what ([file exists \"$MV(rem_images)/$what\"])"}
			if $MV(download_avatars) {SendToServer "DCCSENDAV $what"}
		}
	} else {
		if {[file size "$MV(rem_images)/$what"] != $size} {
			if {[lsearch -exact $MV(downloads) $what] == -1} {
				if $MV(debug) {puts "size mismatch for $what"}
				catch {file delete "$MV(rem_images)/$what"}
				if $MV(download_avatars) {SendToServer "DCCSENDAV $what"}
			}
		} else {
			catch {image create photo $who -file "$MV(rem_images)/$what"} err
			if {$err != $who} {
				image create photo $who -file "$MV(images)/default.gif"
			}
		}
	}

	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.ChangeUserAvatar) {
		if ![$MV(plugin.traps.ChangeUserAvatar.$plugin) $who $what $x $y $size $bx $by] {return}
	}	
}

proc MoveUser {who x y speed} {
	global MV
	
	if {$who == $MV(nick)} {return}
	if {[lsearch -exact $MV(people) $who] == -1} {return}
	if $MV($who.nomoremove) {return}

	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.MoveUser.Pre) {
		if ![$MV(plugin.traps.MoveUser.Pre.$plugin) $who $x $y $speed] {return}
	}	
	if {$speed == ""} {set speed 1}

	while {$MV($who.x) != $x || $MV($who.y) != $y} {
		if {[expr $x - $MV($who.x)] > 0} {set xdir 1} else {set xdir -1}
		if {[expr $y - $MV($who.y)] > 0} {set ydir 1} else {set ydir -1}
		if {[expr $y - $MV($who.y)] == 0} {set ydir 0}
		if {[expr $x - $MV($who.x)] == 0} {set xdir 0}
		set xinc $xdir
		set yinc $ydir
		if {$xdir && $speed != 2} {
			set xinc [expr $xdir * 1]
			set xx $MV($who.x)
			while { $xx != $x && $xinc != [expr $speed * $xdir]} {
				set xx $MV($who.x)
				incr xinc [expr $xdir * 1]
				incr xx $xinc
			}
		}
		if {$ydir && $speed != 2} {
			set yinc [expr $ydir * 1]
			set yy $MV($who.y)
			while { $yy != $y && $yinc != [expr $speed * $ydir]} {
				set yy $MV($who.y)
				incr yinc [expr $ydir * 1]
				incr yy $yinc
			}
		}
		.top.c move $MV($who.icon) $xinc $yinc
		incr MV($who.x) $xinc
		incr MV($who.y) $yinc
		if $MV(names) {
			KillName $who
			if $MV($who.nomoremove) {return}
			ShowName $who
		}
		update idletasks
		update
	}
	if {[lsearch -exact $MV(people) $who] == -1} {
		if $MV(names) {KillName $who}
		return
	}
	#
	# Process Plugins!
	#
	foreach plugin $MV(plugin.traps.MoveUser.Post) {
		if ![$MV(plugin.traps.MoveUser.Post.$plugin) $who $x $y $speed] {return}
	}	
}

proc AvatarEffect {who what} {
	global MV

	if {$who == $MV(nick)} {
		set image $MV(img)
	} else {
		set image $MV($who.icon)
	}
	set x $MV($who.x)
	set y $MV($who.y)
	set xxx $x
	set yyy $y
	if $MV(debug) {puts "(Effect) - $who $what $x $y"}
	switch -- [string tolower $what] {
		"shiver" {
			set dir 0
			for {set c 0} {$c < 50} {incr c} {
				if $dir {
					set dir 0
					set xx [expr $x - 15]
				} else {
					set dir 1
					set xx [expr $x + 15]
				}
				MoveImage $image $xx $y $xxx $y 12
				set xxx $xx
			}
			MoveImage $image $x $y $xxx $y 12
		}
		"jump" {
			set dir 0
			for {set c 0} {$c < 50} {incr c} {
				switch -- $dir {
					"0" {
						set dir 1
						set yy [expr $y - 15]
					}
					"1" {
						set dir 2
						set yy [expr $y - 30]
					}
					"2" {
						set dir 3
						set yy [expr $y - 45]
					}
					"3" {
						set dir 4
						set yy [expr $y - 30]
					}
					"4" {
						set dir 5
						set yy [expr $y - 15]
					}
					"5" {
						set dir 0
						set yy $y
					}
				}
				MoveImage $image $x $yy $x $yyy 1
				set yyy $yy
			}
			MoveImage $image $x $y $x $yyy 1
		}
	}
}
