# OpenVerse Base Functions
# 
# This file contains some basic functions for 
# OpenVerse
#
# Module Name		- Main Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

#
# Images which we use with our chat balloons.
#
image create photo CHAT_notes -file "$MV(icondir)/notes.gif"

#
# Will fill the names button with people who are in the channel.
# 
proc DoNames {} {
	global MV

	destroy $MV(names_menu).m
	menu $MV(names_menu).m 

	$MV(names_menu).m add command -label "Whois Everyone" \
			-command "SendToServer \"WHOIS *\""
	set people 0
	foreach person $MV(people) {
		set MV(whois.$people) $person
		$MV(names_menu).m add cascade -menu \
			$MV(names_menu).m.$people -label "$person"
		if !$MV(use_windowmanager_colors) {
			menu $MV(names_menu).m.$people -bg $MV(colors.name.bg) \
				-fg $MV(colors.name.fg) -activebackground $MV(colors.name.abg) \
				-activeforeground $MV(colors.name.afg)
		} else {
			menu $MV(names_menu).m.$people
		}

		$MV(names_menu).m.$people add command -label "Whois" \
			-command "WhoisCMD $people"
		$MV(names_menu).m.$people add command -label "Message" \
			-command "MessageCMD $people"
		if {[lsearch -exact $MV(ignore.avatar) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Avatar" \
				-command "IgnoreUser $people AVATAR"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Avatar" \
				-command "UnIgnoreUser $people AVATAR"
		}
		if {[lsearch -exact $MV(ignore.effect) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Effects" \
				-command "IgnoreUser $people EFFECT"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Effects" \
				-command "UnIgnoreUser $people EFFECT"
		}
		if {[lsearch -exact $MV(ignore.move) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Moves" \
				-command "IgnoreUser $people MOVE"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Moves" \
				-command "UnIgnoreUser $people MOVE"
		}
		if {[lsearch -exact $MV(ignore.speech) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Speech" \
				-command "IgnoreUser $people SPEECH"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Speech" \
				-command "UnIgnoreUser $people SPEECH"
		}
		if {[lsearch -exact $MV(ignore.sub) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Sub" \
				-command "IgnoreUser $people SUB"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Sub" \
				-command "UnIgnoreUser $people SUB"
		}
		if {[lsearch -exact $MV(ignore.url) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore Url" \
				-command "IgnoreUser $people URL"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore Url" \
				-command "UnIgnoreUser $people URL"
		}
		if {[lsearch -exact $MV(ignore.all) $person] == -1} {
			$MV(names_menu).m.$people add command -label "Ignore All" \
				-command "IgnoreUser $people ALL"
		} else {
			$MV(names_menu).m.$people add command -label "UnIgnore All" \
				-command "UnIgnoreUser $people ALL"
		}
		$MV(names_menu).m.$people add command -label "Kick" \
			-command {} -state disabled
		$MV(names_menu).m.$people add command -label "Ban" \
			-command {} -state disabled
		#
		# Process Plugins!
		#
		foreach plugin $MV(plugin.traps.DoNames) {
			if ![$MV(plugin.traps.DoNames.$plugin) $MV(names_menu).m.$people $person $people] {return}
		}
		incr people
	}
	ColorNames
}

proc NickComplete {} {
	global MV

	if $MV(debug) {puts "-- In NickComplete"}
        set stuff [$MV(chat_entry) get]
	if {$stuff == ""} {return}
	set wrds [split $stuff " "]
	set lastwrd [string tolower [lindex $wrds [expr [llength $wrds] -1]]]
	set len [expr [string length $lastwrd] -1]
	foreach person $MV(people) {
		if {[string range $person 0 $len] == $lastwrd} {
			$MV(chat_entry) insert end [string range $person [expr $len +1] end]
			return
		}
	}
}

proc SetRoom {what size} {
	global MV

	if [file exists "$MV(roomdir)/$what"] {
		if {[file size "$MV(roomdir)/$what"] != $size} {
			if $MV(debug) {puts "size mismatch for $what"}
			catch {file delete "$MV(roomdir)/$what"}
			if {[lsearch -exact $MV(roomloads) $what] == -1} {
				SendToServer "DCCSENDROOM $what"
			}
		} else {
			image create photo room -file "$MV(roomdir)/$what"
		}
	} else {
		if {[lsearch -exact $MV(roomloads) $what] == -1} {
			SendToServer "DCCSENDROOM $what"
		}
	}
}


proc WhoisCMD {person} {
	global MV

	SendToServer "WHOIS $MV(whois.$person)"
}

proc WHOISUser {who hostmask} {
	global MV
	if {[lsearch -exact $MV(people) $who] == -1} {return}
	ProcChat $who "My host information is $hostmask" 0 3 $MV(colors.whois.baloon)
}

proc ProcChat {who what que system baloon} {
	global MV

	if {$who == $MV(nick)} {
		set MV($MV(nick).x) $MV(x)
		set MV($MV(nick).y) $MV(y)
		set MV($MV(nick).baloon_x) $MV(anim.baloon_x)
		set MV($MV(nick).baloon_y) $MV(anim.baloon_y)
	}
	set MV($who.chattime) [clock seconds]
	if {$MV($who.haschat) && !$que} {
		lappend MV($who.chatque) "$system$baloon:$what"
		return
	} else {
		set MV($who.lastsaid) "$what"
	}
	set MV($who.haschat) 1
	#
	# Types of balloons.
	#
	#	0	Normal Chat
	#	1	System Messages.
	#	2	Private Messages.
	#	3	Whois Messages.
	#	4	Singing Chat
	#
	switch $system {
		0 {set textcolor $MV(colors.chat.text)}
		1 {set textcolor $MV(colors.system.text)}
		2 {set textcolor $MV(colors.privmsg.text)}
		3 {set textcolor $MV(colors.whois.text)}
		4 {set textcolor $MV(colors.chat.text)}
		default {set textcolor "black"}
	}
	if {[string length $what] >= 40} {
		set width 240
		set rows [expr [string length $what] / 40]
		if {$rows < 3} {set rows 2}
		set height [expr ([string length $what] / 40) * (25 - ($rows * 2))]
		set hoff [expr $rows * 7]
	} else {
		if {[string length $what] > 3} {
			set width [expr [string length $what] * 9]
			set height 30
			set rows 2
			set hoff [expr [string length $what] / 2]
		} else {
			set width [expr [string length $what] * 40]
			set height 30
			set rows 2
			set hoff 0
		}
	}
	if {$width > 300} {set width 300}
	if {$height < 30} {set height 30}
	if {[expr $MV($who.x) + $width + $MV($who.baloon_x)] > 620} {
		set xoff [expr $MV($who.baloon_x) - 35]
		set yoff -1
	} else {
		set xoff $MV($who.baloon_x)
		set yoff 1
	}
	set MV($who.baloon) [.top.c create polygon \
	[expr $MV($who.x) + ($xoff - (20 * $yoff))] [expr $MV($who.y) + $MV($who.baloon_y)] \
	[expr $MV($who.x) + $xoff] [expr $MV($who.y) + $MV($who.baloon_y)] \
	[expr $MV($who.x) + $xoff + ($yoff * 20)] [expr ($MV($who.y)+ $MV($who.baloon_y)) - $hoff] \
	[expr $MV($who.x) + $xoff + ($width * $yoff) - ($yoff * 20)] [expr ($MV($who.y)+ $MV($who.baloon_y)) - $hoff] \
	[expr $MV($who.x) + $xoff + ($width * $yoff)] [expr $MV($who.y) + $MV($who.baloon_y)] \
	[expr $MV($who.x) + $xoff + ($width * $yoff)] [expr ($MV($who.y)+ $MV($who.baloon_y)) + $height]\
	[expr $MV($who.x) + $xoff + ($width * $yoff) - ($yoff * 20)] [expr ($MV($who.y)+ $MV($who.baloon_y)) + $height +$hoff] \
	[expr $MV($who.x) + $xoff + ($yoff * 20)] [expr ($MV($who.y)+ $MV($who.baloon_y)) + $hoff + $height] \
	[expr $MV($who.x) + $xoff] [expr ($MV($who.y)+ $MV($who.baloon_y)) + $height] \
	[expr $MV($who.x) + $xoff] [expr ($MV($who.y)+ $MV($who.baloon_y)) + 5] \
	[expr $MV($who.x) + ($xoff - (20 * $yoff))] [expr $MV($who.y) + $MV($who.baloon_y)] \
	-fill $baloon -outline black -smooth 1]
	set MV($who.text) [.top.c create text [expr $MV($who.x) + $xoff + \
		($yoff * ($width / 2))] [expr ($MV($who.y)+ $MV($who.baloon_y)) + (8 * $rows)] \
		-width 230 -text $what -fill $textcolor]
	if [winfo exists .chat] {
		switch $system {
			0 {.chat.chat.text insert end "<$who> $what\n"}
			1 {.chat.chat.text insert end "***SYSTEM*** $what\n"}
			2 {.chat.chat.text insert end "<!>$who<!> $what\n"}
			3 {.chat.chat.text insert end "<!>$who<!> $what\n"}
			4 {.chat.chat.text insert end "<>$who<> $what\n"}
			default {.chat.chat.text insert end "<$who> $what\n"}
		}
		if !$MV(textwindow.lock) {.chat.chat.text see end}
	}
	switch $system {
		0 {lappend MV(chats) "<$who> $what\n"}
		1 {lappend MV(chats) "**SYSTEM** $what\n"}
		2 {lappend MV(chats) "<!>$who<!> $what\n"}
		3 {lappend MV(chats) "<!>$who<!> $what\n"}
		4 {
			incr MV(killnotes)
			lappend MV(chats) "<>$who<> $what\n"
			set MV(NotesKill.$MV(killnotes)) "$who"
			set MV($who.notes) [.top.c create image \
				[expr $MV($who.x) + $xoff + ($yoff * 8)] \
				[expr (($MV($who.y)+ $MV($who.baloon_y)) - $hoff) + (((($MV($who.y)+ $MV($who.baloon_y)) +$hoff + $height) - (($MV($who.y)+ $MV($who.baloon_y)) - $hoff)) / 2)] \
				-image CHAT_notes]
			after [expr $MV(staytime) * 1000] "KillNotes $MV(killnotes)"
		}
		default {lappend MV(chats) "<$who> $what\n"}
	}
	if {[llength $MV(chats)] > $MV(chatsave)} {
		set MV(chats) [lreplace $MV(chats) 0 0]
	}
	if $MV(bell) {bell}
	incr MV(killhigh)
	set MV(BaloonKill.$MV(killhigh)) "$who"
	after [expr $MV(staytime) * 1000] "KillBaloon $MV(killhigh)"
	update idletasks
}

proc KillNotes {which} {
	global MV

	if $MV(debug) {puts "Killing Music Notes!"}
	set who "$MV(NotesKill.$which)"
	unset MV(NotesKill.$which)
	.top.c delete $MV($who.notes)
}

proc KillBaloon {which} {
	global MV

	set who "$MV(BaloonKill.$which)"
	unset MV(BaloonKill.$which)
	.top.c delete $MV($who.text)
	.top.c delete $MV($who.baloon)
	if [llength $MV($who.chatque)] {
		set stuff [lindex $MV($who.chatque) 0]
		set system [string range $stuff 0 0]
		set what [string range $stuff 1 end]
		set color [string range $stuff 1 [expr [string first ":" $stuff] -1]]
		set what [string range $stuff [expr [string first ":" $stuff] +1] end]
		set MV($who.chatque) [lreplace $MV($who.chatque) 0 0]
		ProcChat $who $what 1 $system $color
	} else {
		set MV($who.haschat) 0
	}
}

proc NewPerson {who x y image xx yy size bx by} {
	global MV

	if {$who == $MV(nick)} {return}
	if {[lsearch -exact $MV(people) $who] != -1} {return}
	lappend MV(people) $who
	set MV($who.name) $who
	set MV($who.avatar) $image
	set MV($who.x) $x
	set MV($who.y) $y
	set MV($who.lastsaid) ""
	set MV($who.name_x_offset) $xx
	set MV($who.name_y_offset) $yy
	set MV($who.baloon_x) $bx
	set MV($who.baloon_y) $by
	set MV($who.haschat) 0
	set MV($who.nomoremove) 0
	set MV($who.chatque) {}

	#
	# Proces Plugins!
        foreach plugin $MV(plugin.traps.NewPerson) {
                if ![$MV(plugin.traps.NewPerson.$plugin) $who $x $y $image $xx $yy $size $bx $by] {return}
        }
	
	if [winfo exists .chat] {
		.chat.chat.text insert end "<*>$who<*> Entered the room\n"
		if !$MV(textwindow.lock) {.chat.chat.text see end}
	}
	lappend MV(chats) "<*>$who<*> Entered the room\n"
	if {$image == "default.gif"} {
		image create photo $who -file "$MV(images)/default.gif"
		set MV($who.icon) [.top.c create image $x $y -image $who]
		if $MV(names) {ShowName $who}
		DoNames
		return
	}
	if ![file exists "$MV(rem_images)/$image"] {
		image create photo $who -file "$MV(images)/default.gif"
		set MV($who.icon) [.top.c create image $x $y -image $who]
		if {[lsearch -exact $MV(downloads) $image] == -1} {
			if $MV(debug) {puts "I do not have $image"}
			if $MV(download_avatars) {SendToServer "DCCSENDAV $image"}
		}
	} else {
		if {[file size "$MV(rem_images)/$image"] != $size} {
			image create photo $who -file "$MV(images)/default.gif"
			set MV($who.icon) [.top.c create image $x $y -image $who]
			if {[lsearch -exact $MV(downloads) $image] == -1} {
				if $MV(debug) {puts "size mismatch for $image"}
				if $MV(download_avatars) {SendToServer "DCCSENDAV $image"}
			}
		} else {
			catch {image create photo $who -file "$MV(rem_images)/$image"} err
			if {$err != $who} {
				image create photo $who -file "$MV(images)/default.gif"
			}
			set MV($who.icon) [.top.c create image $x $y -image $who]
		}
	}
	if $MV(names) {
		ShowName $who
	}
	DoNames
}

proc PersonLeft {who} {
	global MV

	if {[lsearch -exact $MV(people) $who] == -1} {return}
	set idx [lsearch -exact $MV(people) $who]
	set MV(people) [lreplace $MV(people) $idx $idx]
	#
	# Remove from ignorance lists.
	#
	if {[lsearch -exact $MV(ignore.all)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.all)) $who]
		set MV(ignore.all) [lreplace $MV(ignore.all) $idx $idx]
	}
	if {[lsearch -exact $MV(ignore.avatar)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.avatar)) $who]
		set MV(ignore.avatar) [lreplace $MV(ignore.avatar) $idx $idx]
	}
	if {[lsearch -exact $MV(ignore.effect)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.effect)) $who]
		set MV(ignore.effect) [lreplace $MV(ignore.effect) $idx $idx]
	}
	if {[lsearch -exact $MV(ignore.move)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.move)) $who]
		set MV(ignore.move) [lreplace $MV(ignore.move) $idx $idx]
	}
	if {[lsearch -exact $MV(ignore.speech)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.speech)) $who]
		set MV(ignore.speech) [lreplace $MV(ignore.speech) $idx $idx]
	}
	if {[lsearch -exact $MV(ignore.url)) $who] != -1} {
		set idx [lsearch -exact $MV(ignore.url)) $who]
		set MV(ignore.url) [lreplace $MV(ignore.url) $idx $idx]
	}
	#
	# Proces Plugins!
        foreach plugin $MV(plugin.traps.PersonLeft) {
                if ![$MV(plugin.traps.PersonLeft.$plugin) $who] {return}
        }
	

	set MV($who.nomoremove) 1
	.top.c delete $MV($who.icon)
	if [winfo exists .chat] {
		.chat.chat.text insert end "<*>$who<*> Left the room\n"
		if !$MV(textwindow.lock) {.chat.chat.text see end}
	}
	lappend MV(chats) "<*>$who<*> Left the room\n"
	if {$MV($who.haschat)} {
		.top.c delete $MV($who.text)
		.top.c delete $MV($who.baloon)
		set MV($who.chatque) {}
		set MV(haschat) 0
	}
	if $MV(names) {
		KillName $who
	}
	DoNames
}

proc SanityCheck {what} {
        if {[string first "../" $what] != -1} { return 0} else { return 1}
}

#
# checks the length of stuff typped into the chat windows.
#
proc CheckLen {win} {
        if {[string length [$win get]] > 256} {
                $win delete 256 end
                bell
        }
}

#
# Sends text to the server.
#
proc SendText {} {
        global MV
        
        set stuff [$MV(chat_entry) get]
        $MV(chat_entry) delete 0 end
        lappend MV(prev) $stuff
        if {[llength $MV(prev)] > $MV(prevsave)} {
                set MV(prev) [lreplace $MV(prev) 0 0]
        }
        set MV(curprev) -1

        #
        # Process Plugins!
        #
        foreach plugin $MV(plugin.traps.SendText) {
                if ![$MV(plugin.traps.SendText.$plugin) $stuff] {return}
        }

        if {[string range $stuff 0 0] == "/"} {
                ProcessCommand $stuff
        } else {
                SendToServer "CHAT $stuff"
        }
}

#
# Checks to be sure a nick is within preset limits.
# The maximum nick length is currently 12 characters.
#
proc CheckThatNick {nick} {
        global MV
        
        set max 0
        set newnck {}
        set nck [split $nick ""]
        foreach letter $nck {
                incr max
                if {$max <= 12} {
                        switch -- $letter {
                                " " {
                                        # No spaces allowed :)
                                }
                                default {
                                        lappend newnck $letter
                                }
                        }
                }
        }
        if {[lsearch -exact $MV(people) [join $newnck ""]] != -1} {
                ProcChat $MV(nick) "The nick you have chosen is in use. Please choose another. You can use the setup button to do this or type '/nick YourNick'  in the chat windows." 0 1 $MV(colors.system.baloon)
                bell
                return ""
        }
        return [join $newnck ""]
}

#
# Toggles DEBUG mode on and off.
# While in debug mode, it will output everything it sends and received to
# stdout.
#
proc ToggleDebug {} {
        global MV
        
        if $MV(debug) {
                set MV(debug) 0
        } else {
                set MV(debug) 1
        }
}

proc ShowPrev {win} {
        global MV

        if ![llength $MV(prev)] {return}
        set top [expr [llength $MV(prev)] -1]
        if {$MV(curprev) <= 0} {
                set MV(curprev) $top
        } else {
                incr MV(curprev) -1
        }
        $win delete 0 end
        $win insert end [lindex $MV(prev) $MV(curprev)]
}

proc ShowNext {win} {
        global MV

        if ![llength $MV(prev)] {return}
        set top [expr [llength $MV(prev)] -1]
        if {$MV(curprev) >= $top} {
                set MV(curprev) 0
        } else {
                incr MV(curprev)
        }
        $win delete 0 end
        $win insert end [lindex $MV(prev) $MV(curprev)]
}

proc CheckNick {} {
        global MV
        
        set max 0
        set newnck {}
        set nck [split [.setup.na.l.t.nick.entry get] ""]
        foreach letter $nck {
                incr max
                if {$max <= 12} {
                        switch -- $letter {
                                " " {
                                        bell
                                        # No spaces allowed :)
                                }
                                default {
                                        lappend newnck $letter
                                }
                        }
                } else {
                        bell
                }
        }
        .setup.na.l.t.nick.entry delete 0 end
        .setup.na.l.t.nick.entry insert end [join $newnck ""]
}

proc MessageCMD {which} {
	global MV

	if [winfo exists .msg] {destroy .msg}
	toplevel .msg
	wm title .msg "Messaging $MV(whois.$which)"
	button .msg.send -text "Send" -command "SendPrivMsg $which"
	entry .msg.entry -width 60
	pack .msg.send .msg.entry -side left -fill both -expand y
	bind .msg <Return> "SendPrivMsg $which"
}

proc SendPrivMsg {which} {
	global MV

	SendToServer "PRIVMSG $MV(whois.$which) [.msg.entry get]"
	ProcChat $MV(nick) "[.msg.entry get]" 0 2 $MV(colors.privmsg.baloon)
	destroy .msg
}

proc TestNum {what} {
	global MV

	if {$what == ""} {return 1}
	set bad 0
	for {set c 0} {$c < [string length $what] && !$bad} {incr c} {
		switch -exact -- [string range $what $c $c] {
			1 {
			}
			2 {
			}
			3 {
			}
			4 {
			}
			5 {
			}
			6 {
			}
			7 {
			}
			8 {
			}
			9 {
			}
			0 {
			}
			- {
			}
			default {
				set bad 1
			}
		}
	}
	return $bad
}

#
# Change the user's nick and provide a place for plugin's to link to.
#
proc ChangeNick {newnick} {
	global MV

	set MV(nick) "$newnick"

        #
        # Process Plugins!
        #
        foreach plugin $MV(plugin.traps.ChangeNick) {
                if ![$MV(plugin.traps.ChangeNick.$plugin) $newnick] {return}
        }
}

proc ColorNames {} {
	global MV

	if $MV(use_windowmanager_colors) {return}

	$MV(names_menu).m configure -bg $MV(colors.name.bg) \
		-fg $MV(colors.name.fg) -activebackground $MV(colors.name.abg) \
		-activeforeground $MV(colors.name.afg)

}

proc IgnoreUser {who how} {
	global MV
	
	set who $MV(whois.$who)
	if $MV(debug) {puts "Ignoring $who ($how)"}

	switch -exact -- [string tolower $how] {
		"all" {
			if {[lsearch -exact $MV(ignore.all) $who] == -1} {
				lappend MV(ignore.all) $who
				ChangeUserAvatar $who default.gif -4 36 0 12 -14
			}
		}
		"avatar" {
			if {[lsearch -exact $MV(ignore.avatar) $who] == -1} {
				lappend MV(ignore.avatar) $who
				ChangeUserAvatar $who default.gif -4 36 0 12 -14
			}
		}
		"effect" {
			if {[lsearch -exact $MV(ignore.effect) $who] == -1} {
				lappend MV(ignore.effect) $who
			}
		}
		"move" {
			if {[lsearch -exact $MV(ignore.move) $who] == -1} {
				lappend MV(ignore.move) $who
			}
		}
		"speech" {
			if {[lsearch -exact $MV(ignore.speech) $who] == -1} {
				lappend MV(ignore.speech) $who
			}
		}
		"sub" {
			if {[lsearch -exact $MV(ignore.sub) $who] == -1} {
				lappend MV(ignore.sub) $who
			}
		}
		"url" {
			if {[lsearch -exact $MV(ignore.url) $who] == -1} {
				lappend MV(ignore.url) $who
			}
		}
	}
	DoNames
}

proc UnIgnoreUser {who how} {
	global MV
	
	set who $MV(whois.$who)
	if $MV(debug) {puts "UnIgnoring $who ($how)"}

	switch -exact -- [string tolower $how] {
		"all" {
			if {[lsearch -exact $MV(ignore.all) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.all) $who]
				set MV(ignore.all) [lreplace $MV(ignore.all) $idx $idx]
			}
		}
		"avatar" {
			if {[lsearch -exact $MV(ignore.avatar) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.avatar) $who]
				set MV(ignore.avatar) [lreplace $MV(ignore.avatar) $idx $idx]
			}
		}
		"effect" {
			if {[lsearch -exact $MV(ignore.effect) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.effect) $who]
				set MV(ignore.effect) [lreplace $MV(ignore.effect) $idx $idx]
			}
		}
		"move" {
			if {[lsearch -exact $MV(ignore.move) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.move) $who]
				set MV(ignore.move) [lreplace $MV(ignore.move) $idx $idx]
			}
		}
		"speech" {
			if {[lsearch -exact $MV(ignore.speech) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.speech) $who]
				set MV(ignore.speech) [lreplace $MV(ignore.speech) $idx $idx]
			}
		}
		"sub" {
			if {[lsearch -exact $MV(ignore.sub) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.sub) $who]
				set MV(ignore.sub) [lreplace $MV(ignore.sub) $idx $idx]
			}
		}
		"url" {
			if {[lsearch -exact $MV(ignore.url) $who] != -1} {
				set idx [lsearch -exact $MV(ignore.url) $who]
				set MV(ignore.url) [lreplace $MV(ignore.url) $idx $idx]
			}
		}
	}
	DoNames
}

