#!/usr/bin/tclsh

#
# This will read in a gif file header and decide
# if it is within bounds. (or even a valid file)
#

proc CheckGif {file} {
	global MV

	set infile [open $file r]
	fconfigure $infile -translation binary
	set bits [read $infile 10]
	close $infile
	binary scan $bits c* var1
	if {[string range $bits 0 2] != "GIF"} {puts "FAILED";return 0}
	binary scan $bits s* var2
	if {[lindex $var2 3] < $MV(maxheight) & [lindex $var2 4] < $MV(maxwidth)} {
		puts "PASSED"
		return 1
	} else {
		puts "FAILED"
		return 0
	}
}
